/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.webauthn;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.cbor.CBORGenerator;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.impl.Codec;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.util.Base64;
import java.util.Random;

public class WebAuthnHardware {
    private KeyPair keyPair;
    private String id;
    private byte[] credID;
    private int counter = 1;
    private URL origin;

    public WebAuthnHardware(URL origin) {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance("EC");
            generator.initialize(new ECGenParameterSpec("secp256r1"));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.keyPair = generator.generateKeyPair();
        Random random = new Random();
        this.credID = new byte[32];
        random.nextBytes(this.credID);
        this.id = Base64.getUrlEncoder().withoutPadding().encodeToString(this.credID);
        this.origin = origin;
    }

    public JsonObject makeRegistrationJson(String challenge) {
        JsonObject clientData = new JsonObject().put("type", (Object)"webauthn.create").put("challenge", (Object)challenge).put("origin", (Object)this.origin.toString()).put("crossOrigin", (Object)false);
        String clientDataEncoded = Base64.getUrlEncoder().encodeToString(clientData.encode().getBytes(StandardCharsets.UTF_8));
        byte[] authBytes = this.makeAuthBytes(true);
        CBORFactory cborFactory = new CBORFactory();
        ByteArrayOutputStream byteWriter = new ByteArrayOutputStream();
        try {
            CBORGenerator generator = cborFactory.createGenerator((OutputStream)byteWriter);
            generator.writeStartObject();
            generator.writeStringField("fmt", "none");
            generator.writeObjectFieldStart("attStmt");
            generator.writeEndObject();
            generator.writeBinaryField("authData", authBytes);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException t) {
            throw new RuntimeException(t);
        }
        String attestationObjectEncoded = Base64.getUrlEncoder().encodeToString(byteWriter.toByteArray());
        return new JsonObject().put("id", (Object)this.id).put("rawId", (Object)this.id).put("response", (Object)new JsonObject().put("attestationObject", (Object)attestationObjectEncoded).put("clientDataJSON", (Object)clientDataEncoded)).put("type", (Object)"public-key");
    }

    public JsonObject makeLoginJson(String challenge) {
        byte[] signatureBytes;
        MessageDigest md;
        JsonObject clientData = new JsonObject().put("type", (Object)"webauthn.get").put("challenge", (Object)challenge).put("origin", (Object)this.origin.toString()).put("crossOrigin", (Object)false);
        byte[] clientDataBytes = clientData.encode().getBytes(StandardCharsets.UTF_8);
        String clientDataEncoded = Base64.getUrlEncoder().encodeToString(clientDataBytes);
        byte[] authBytes = this.makeAuthBytes(false);
        String authenticatorData = Base64.getUrlEncoder().encodeToString(authBytes);
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] clientDataHash = md.digest(clientDataBytes);
        byte[] signedBytes = new byte[authBytes.length + clientDataHash.length];
        System.arraycopy(authBytes, 0, signedBytes, 0, authBytes.length);
        System.arraycopy(clientDataHash, 0, signedBytes, authBytes.length, clientDataHash.length);
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(this.keyPair.getPrivate());
            signature.update(signedBytes);
            signatureBytes = signature.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
        String signatureEncoded = Base64.getUrlEncoder().encodeToString(signatureBytes);
        return new JsonObject().put("id", (Object)this.id).put("rawId", (Object)this.id).put("response", (Object)new JsonObject().put("authenticatorData", (Object)authenticatorData).put("clientDataJSON", (Object)clientDataEncoded).put("signature", (Object)signatureEncoded)).put("type", (Object)"public-key");
    }

    private byte[] makeAuthBytes(boolean attest) {
        MessageDigest md;
        Buffer buffer = Buffer.buffer();
        String rpDomain = "localhost";
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] rpIdHash = md.digest(rpDomain.getBytes(StandardCharsets.UTF_8));
        buffer.appendBytes(rpIdHash);
        byte flags = 69;
        buffer.appendByte(flags);
        long signCounter = this.counter++;
        buffer.appendUnsignedInt(signCounter);
        if (attest) {
            String aaguidString = "00000000-0000-0000-0000-000000000000";
            String aaguidStringShort = aaguidString.replace("-", "");
            byte[] aaguid = Codec.base16Decode((String)aaguidStringShort);
            buffer.appendBytes(aaguid);
            buffer.appendUnsignedShort(this.credID.length);
            buffer.appendBytes(this.credID);
            ECPublicKey publicKey = (ECPublicKey)this.keyPair.getPublic();
            Base64.Encoder urlEncoder = Base64.getEncoder();
            String x = urlEncoder.encodeToString(publicKey.getW().getAffineX().toByteArray());
            String y = urlEncoder.encodeToString(publicKey.getW().getAffineY().toByteArray());
            CBORFactory cborFactory = new CBORFactory();
            ByteArrayOutputStream byteWriter = new ByteArrayOutputStream();
            try {
                CBORGenerator generator = cborFactory.createGenerator((OutputStream)byteWriter);
                generator.writeStartObject();
                generator.writeNumberField("1", 2);
                generator.writeNumberField("3", -7);
                generator.writeNumberField("-1", 1);
                generator.writeStringField("-2", x);
                generator.writeStringField("-3", y);
                generator.writeEndObject();
                generator.close();
            }
            catch (IOException t) {
                throw new RuntimeException(t);
            }
            buffer.appendBytes(byteWriter.toByteArray());
        }
        return buffer.getBytes();
    }
}

