/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security.webauthn;

import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import io.vertx.core.json.JsonObject;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

public class WebAuthnEndpointHelper {
    public static String invokeRegistration(String userName, Filter cookieFilter) {
        JsonObject registerJson = new JsonObject().put("name", (Object)userName);
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().body(registerJson.encode()).contentType(ContentType.JSON).filter(cookieFilter).log().ifValidationFails()).post("/q/webauthn/register", new Object[0])).then()).statusCode(200)).log().ifValidationFails()).cookie("_quarkus_webauthn_challenge", Matchers.notNullValue())).cookie("_quarkus_webauthn_username", Matchers.notNullValue())).extract();
        JsonObject responseJson = new JsonObject(response.asString());
        String challenge = responseJson.getString("challenge");
        Assertions.assertNotNull((Object)challenge);
        return challenge;
    }

    public static void invokeCallback(JsonObject registration, Filter cookieFilter) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().body(registration.encode()).filter(cookieFilter).contentType(ContentType.JSON).log().ifValidationFails()).post("/q/webauthn/callback", new Object[0])).then()).statusCode(204)).log().ifValidationFails()).cookie("_quarkus_webauthn_challenge", Matchers.is((Object)""))).cookie("_quarkus_webauthn_username", Matchers.is((Object)""))).cookie("quarkus-credential", Matchers.notNullValue());
    }

    public static String invokeLogin(String userName, Filter cookieFilter) {
        JsonObject loginJson = new JsonObject().put("name", (Object)userName);
        ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().body(loginJson.encode()).contentType(ContentType.JSON).filter(cookieFilter).log().ifValidationFails()).post("/q/webauthn/login", new Object[0])).then()).statusCode(200)).log().ifValidationFails()).cookie("_quarkus_webauthn_challenge", Matchers.notNullValue())).cookie("_quarkus_webauthn_username", Matchers.notNullValue())).extract();
        JsonObject responseJson = new JsonObject(response.asString());
        String challenge = responseJson.getString("challenge");
        Assertions.assertNotNull((Object)challenge);
        return challenge;
    }

    public static void addWebAuthnRegistrationFormParameters(RequestSpecification request, JsonObject registration) {
        request.formParam("webAuthnId", new Object[]{registration.getString("id")}).formParam("webAuthnRawId", new Object[]{registration.getString("rawId")}).formParam("webAuthnResponseAttestationObject", new Object[]{registration.getJsonObject("response").getString("attestationObject")}).formParam("webAuthnResponseClientDataJSON", new Object[]{registration.getJsonObject("response").getString("clientDataJSON")}).formParam("webAuthnType", new Object[]{registration.getString("type")});
    }

    public static void addWebAuthnLoginFormParameters(RequestSpecification request, JsonObject login) {
        request.formParam("webAuthnId", new Object[]{login.getString("id")}).formParam("webAuthnRawId", new Object[]{login.getString("rawId")}).formParam("webAuthnResponseAuthenticatorData", new Object[]{login.getJsonObject("response").getString("authenticatorData")}).formParam("webAuthnResponseSignature", new Object[]{login.getJsonObject("response").getString("signature")}).formParam("webAuthnResponseUserHandle", new Object[]{login.getJsonObject("response").getString("userHandle")}).formParam("webAuthnResponseClientDataJSON", new Object[]{login.getJsonObject("response").getString("clientDataJSON")}).formParam("webAuthnType", new Object[]{login.getString("type")});
    }

    public static void invokeLogout(Filter cookieFilter) {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().filter(cookieFilter).redirects().follow(false).when().log().ifValidationFails()).get("/q/webauthn/logout", new Object[0])).then()).log().ifValidationFails()).statusCode(302)).cookie("quarkus-credential", Matchers.is((Object)""));
    }
}

