/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.security.TestAuthController;
import io.quarkus.test.security.TestHttpAuthenticationMechanism;
import io.quarkus.test.security.TestIdentityAssociation;
import io.quarkus.test.security.TestSecurity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.util.annotations.AnnotationContainer;
import io.quarkus.test.util.annotations.AnnotationUtils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class QuarkusSecurityTestExtension
implements QuarkusTestBeforeEachCallback,
QuarkusTestAfterEachCallback {
    public void afterEach(QuarkusTestMethodContext context) {
        try {
            if (this.getAnnotationContainer(context).isPresent()) {
                ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(true);
                ((TestHttpAuthenticationMechanism)CDI.current().select(TestHttpAuthenticationMechanism.class, new Annotation[0]).get()).setAuthMechanism(null);
                TestIdentityAssociation testIdentity = (TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get());
                testIdentity.setTestIdentity(null);
                testIdentity.setPathBasedIdentity(false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to reset TestAuthController, TestIdentityAssociation and TestHttpAuthenticationMechanism", e);
        }
    }

    public void beforeEach(QuarkusTestMethodContext context) {
        try {
            Optional<AnnotationContainer<TestSecurity>> annotationContainerOptional = this.getAnnotationContainer(context);
            if (annotationContainerOptional.isEmpty()) {
                return;
            }
            AnnotationContainer<TestSecurity> annotationContainer = annotationContainerOptional.get();
            Annotation[] allAnnotations = annotationContainer.getElement().getAnnotations();
            TestSecurity testSecurity = (TestSecurity)annotationContainer.getAnnotation();
            ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(testSecurity.authorizationEnabled());
            if (testSecurity.user().isEmpty()) {
                if (testSecurity.roles().length != 0) {
                    throw new RuntimeException("Cannot specify roles without a username in @TestSecurity");
                }
            } else {
                QuarkusSecurityIdentity.Builder user = QuarkusSecurityIdentity.builder().setPrincipal((Principal)new QuarkusPrincipal(testSecurity.user())).addRoles(new HashSet<String>(Arrays.asList(testSecurity.roles())));
                if (testSecurity.attributes() != null) {
                    user.addAttributes(Arrays.stream(testSecurity.attributes()).collect(Collectors.toMap(s -> s.key(), s -> s.type().convert(s.value()))));
                }
                SecurityIdentity userIdentity = this.augment((SecurityIdentity)user.build(), allAnnotations);
                ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setTestIdentity(userIdentity);
                if (!testSecurity.authMechanism().isEmpty()) {
                    ((TestHttpAuthenticationMechanism)CDI.current().select(TestHttpAuthenticationMechanism.class, new Annotation[0]).get()).setAuthMechanism(testSecurity.authMechanism());
                    ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setPathBasedIdentity(true);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to setup @TestSecurity", e);
        }
    }

    private Optional<AnnotationContainer<TestSecurity>> getAnnotationContainer(QuarkusTestMethodContext context) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> original = cl.loadClass(context.getTestMethod().getDeclaringClass().getName());
        Method method = original.getDeclaredMethod(context.getTestMethod().getName(), (Class[])Arrays.stream(context.getTestMethod().getParameterTypes()).map(s -> {
            if (s.isPrimitive()) {
                return s;
            }
            try {
                return Class.forName(s.getName(), false, cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).toArray(Class[]::new));
        Optional annotationContainerOptional = AnnotationUtils.findAnnotation((AnnotatedElement)method, TestSecurity.class);
        if (annotationContainerOptional.isEmpty()) {
            annotationContainerOptional = AnnotationUtils.findAnnotation(original, TestSecurity.class);
        }
        return annotationContainerOptional;
    }

    private SecurityIdentity augment(SecurityIdentity identity, Annotation[] annotations) {
        Instance producer = CDI.current().select(TestSecurityIdentityAugmentor.class, new Annotation[0]);
        if (producer.isResolvable()) {
            return ((TestSecurityIdentityAugmentor)producer.get()).augment(identity, annotations);
        }
        return identity;
    }
}

