/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import io.quarkus.test.security.TestAuthController;
import io.quarkus.test.security.TestIdentityAssociation;
import io.quarkus.test.security.TestSecurity;
import io.quarkus.test.security.TestSecurityIdentityAugmentor;
import io.quarkus.test.util.annotations.AnnotationContainer;
import io.quarkus.test.util.annotations.AnnotationUtils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;

public class QuarkusSecurityTestExtension
implements QuarkusTestBeforeEachCallback,
QuarkusTestAfterEachCallback {
    public void afterEach(QuarkusTestMethodContext context) {
        ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(true);
        ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setTestIdentity(null);
    }

    public void beforeEach(QuarkusTestMethodContext context) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> original = cl.loadClass(context.getTestMethod().getDeclaringClass().getName());
            Method method = original.getDeclaredMethod(context.getTestMethod().getName(), (Class[])Arrays.stream(context.getTestMethod().getParameterTypes()).map(s -> {
                if (s.isPrimitive()) {
                    return s;
                }
                try {
                    return Class.forName(s.getName(), false, cl);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }).toArray(Class[]::new));
            Optional annotationContainerOptional = AnnotationUtils.findAnnotation((AnnotatedElement)method, TestSecurity.class);
            if (annotationContainerOptional.isEmpty()) {
                annotationContainerOptional = AnnotationUtils.findAnnotation(original, TestSecurity.class);
            }
            if (annotationContainerOptional.isEmpty()) {
                return;
            }
            AnnotationContainer annotationContainer = (AnnotationContainer)annotationContainerOptional.get();
            Annotation[] allAnnotations = annotationContainer.getElement().getAnnotations();
            TestSecurity testSecurity = (TestSecurity)annotationContainer.getAnnotation();
            ((TestAuthController)((Object)CDI.current().select(TestAuthController.class, new Annotation[0]).get())).setEnabled(testSecurity.authorizationEnabled());
            if (testSecurity.user().isEmpty()) {
                if (testSecurity.roles().length != 0) {
                    throw new RuntimeException("Cannot specify roles without a username in @TestSecurity");
                }
            } else {
                QuarkusSecurityIdentity.Builder user = QuarkusSecurityIdentity.builder().setPrincipal((Principal)new QuarkusPrincipal(testSecurity.user())).addRoles(new HashSet<String>(Arrays.asList(testSecurity.roles())));
                if (testSecurity.attributes() != null) {
                    user.addAttributes(Arrays.stream(testSecurity.attributes()).collect(Collectors.toMap(s -> s.key(), s -> s.value())));
                }
                SecurityIdentity userIdentity = this.augment((SecurityIdentity)user.build(), allAnnotations);
                ((TestIdentityAssociation)((Object)CDI.current().select(TestIdentityAssociation.class, new Annotation[0]).get())).setTestIdentity(userIdentity);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to setup @TestSecurity", e);
        }
    }

    private SecurityIdentity augment(SecurityIdentity identity, Annotation[] annotations) {
        Instance producer = CDI.current().select(TestSecurityIdentityAugmentor.class, new Annotation[0]);
        if (producer.isResolvable()) {
            return ((TestSecurityIdentityAugmentor)producer.get()).augment(identity, annotations);
        }
        return identity;
    }
}

