/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.vertx;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.test.TestMethodInvoker;
import io.quarkus.test.TestReactiveTransaction;
import io.quarkus.test.vertx.DefaultUniAsserter;
import io.quarkus.test.vertx.RunOnVertxContext;
import io.quarkus.test.vertx.UniAsserter;
import io.quarkus.test.vertx.UnwrappableUniAsserter;
import io.quarkus.vertx.core.runtime.VertxCoreRecorder;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;

public class RunOnVertxContextTestMethodInvoker
implements TestMethodInvoker {
    private UniAsserter uniAsserter;

    public boolean handlesMethodParamType(String paramClassName) {
        return UniAsserter.class.getName().equals(paramClassName);
    }

    public Object methodParamInstance(String paramClassName) {
        if (!this.handlesMethodParamType(paramClassName)) {
            throw new IllegalStateException(this.getClass().getName() + " does not handle '" + paramClassName + "' method param types");
        }
        this.uniAsserter = this.createUniAsserter();
        return this.uniAsserter;
    }

    protected UniAsserter createUniAsserter() {
        return new DefaultUniAsserter();
    }

    public boolean supportsMethod(Class<?> originalTestClass, Method originalTestMethod) {
        return this.hasSupportedAnnotation(originalTestClass, originalTestMethod) && this.hasSupportedParams(originalTestMethod);
    }

    private boolean hasSupportedParams(Method originalTestMethod) {
        return originalTestMethod.getParameterCount() == 0 || originalTestMethod.getParameterCount() == 1 && originalTestMethod.getParameterTypes()[0].getName().equals(UniAsserter.class.getName());
    }

    protected boolean hasSupportedAnnotation(Class<?> originalTestClass, Method originalTestMethod) {
        return this.hasAnnotation(RunOnVertxContext.class, originalTestMethod.getAnnotations()) || this.hasAnnotation(RunOnVertxContext.class, originalTestClass.getAnnotations()) || this.hasAnnotation(TestReactiveTransaction.class, originalTestMethod.getAnnotations()) || this.hasAnnotation(TestReactiveTransaction.class, originalTestClass.getAnnotations());
    }

    protected boolean hasAnnotation(Class<? extends Annotation> annotation, Annotation[] annotations) {
        return this.hasAnnotation(annotation.getName(), annotations);
    }

    private boolean hasAnnotation(String annotationName, Annotation[] annotations) {
        if (annotations != null) {
            for (Annotation methodAnnotation : annotations) {
                if (!annotationName.equals(methodAnnotation.annotationType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public Object invoke(Object actualTestInstance, Method actualTestMethod, List<Object> actualTestMethodArgs, String testClassName) throws Throwable {
        Object handler;
        CompletableFuture cf;
        Vertx vertx = (Vertx)VertxCoreRecorder.getVertx().get();
        if (vertx == null) {
            throw new IllegalStateException("Vert.x instance has not been created before attempting to run test method '" + actualTestMethod.getName() + "' of test class '" + testClassName + "'");
        }
        Context context = vertx.getOrCreateContext();
        Class testClass = actualTestInstance != null ? actualTestInstance.getClass() : Object.class;
        boolean shouldDuplicateContext = this.shouldContextBeDuplicated(testClass, actualTestMethod);
        if (shouldDuplicateContext) {
            context = VertxContext.getOrCreateDuplicatedContext((Context)context);
            VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
        }
        if (this.shouldRunOnEventLoop(testClass, actualTestMethod)) {
            cf = new CompletableFuture();
            handler = new RunTestMethodOnVertxEventLoopContextHandler(actualTestInstance, actualTestMethod, actualTestMethodArgs, this.uniAsserter, cf);
            context.runOnContext((Handler)handler);
        } else {
            handler = new RunTestMethodOnVertxBlockingContextHandler(actualTestInstance, actualTestMethod, actualTestMethodArgs, this.uniAsserter);
            cf = (CompletableFuture)context.executeBlocking((Handler)handler).toCompletionStage();
        }
        try {
            return cf.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    private boolean shouldContextBeDuplicated(Class<?> c, Method m) {
        RunOnVertxContext runOnVertxContext = m.getAnnotation(RunOnVertxContext.class);
        if (runOnVertxContext == null) {
            runOnVertxContext = c.getAnnotation(RunOnVertxContext.class);
        }
        if (runOnVertxContext == null) {
            return m.isAnnotationPresent(TestReactiveTransaction.class) || m.getDeclaringClass().isAnnotationPresent(TestReactiveTransaction.class);
        }
        return runOnVertxContext.duplicateContext();
    }

    private boolean shouldRunOnEventLoop(Class<?> c, Method m) {
        RunOnVertxContext runOnVertxContext = m.getAnnotation(RunOnVertxContext.class);
        if (runOnVertxContext == null) {
            runOnVertxContext = c.getAnnotation(RunOnVertxContext.class);
        }
        if (runOnVertxContext == null) {
            return true;
        }
        return runOnVertxContext.runOnEventLoop();
    }

    public static class RunTestMethodOnVertxBlockingContextHandler
    implements Handler<Promise<Object>> {
        private static final Runnable DO_NOTHING = () -> {};
        private final Object testInstance;
        private final Method targetMethod;
        private final List<Object> methodArgs;
        private final UnwrappableUniAsserter uniAsserter;

        public RunTestMethodOnVertxBlockingContextHandler(Object testInstance, Method targetMethod, List<Object> methodArgs, UniAsserter uniAsserter) {
            this.testInstance = testInstance;
            this.targetMethod = targetMethod;
            this.methodArgs = methodArgs;
            this.uniAsserter = (UnwrappableUniAsserter)uniAsserter;
        }

        public void handle(Promise<Object> promise) {
            final ManagedContext requestContext = Arc.container().requestContext();
            if (requestContext.isActive()) {
                this.doRun(promise, DO_NOTHING);
            } else {
                requestContext.activate();
                this.doRun(promise, new Runnable(){

                    @Override
                    public void run() {
                        requestContext.terminate();
                    }
                });
            }
        }

        private void doRun(final Promise<Object> promise, final Runnable onTerminate) {
            try {
                Object testMethodResult = this.targetMethod.invoke(this.testInstance, this.methodArgs.toArray(new Object[0]));
                if (this.uniAsserter != null) {
                    this.uniAsserter.asUni().subscribe().with((Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object o) {
                            onTerminate.run();
                            promise.complete();
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable t) {
                            onTerminate.run();
                            promise.fail(t);
                        }
                    });
                } else {
                    onTerminate.run();
                    promise.complete(testMethodResult);
                }
            }
            catch (Throwable t) {
                onTerminate.run();
                promise.fail(t.getCause());
            }
        }
    }

    public static class RunTestMethodOnVertxEventLoopContextHandler
    implements Handler<Void> {
        private static final Runnable DO_NOTHING = new Runnable(){

            @Override
            public void run() {
            }
        };
        private final Object testInstance;
        private final Method targetMethod;
        private final List<Object> methodArgs;
        private final UnwrappableUniAsserter uniAsserter;
        private final CompletableFuture<Object> future;

        public RunTestMethodOnVertxEventLoopContextHandler(Object testInstance, Method targetMethod, List<Object> methodArgs, UniAsserter uniAsserter, CompletableFuture<Object> future) {
            this.testInstance = testInstance;
            this.future = future;
            this.targetMethod = targetMethod;
            this.methodArgs = methodArgs;
            this.uniAsserter = (UnwrappableUniAsserter)uniAsserter;
        }

        public void handle(Void event) {
            final ManagedContext requestContext = Arc.container().requestContext();
            if (requestContext.isActive()) {
                this.doRun(DO_NOTHING);
            } else {
                requestContext.activate();
                this.doRun(new Runnable(){

                    @Override
                    public void run() {
                        requestContext.terminate();
                    }
                });
            }
        }

        private void doRun(final Runnable onTerminate) {
            try {
                final Object testMethodResult = this.targetMethod.invoke(this.testInstance, this.methodArgs.toArray(new Object[0]));
                if (this.uniAsserter != null) {
                    this.uniAsserter.asUni().subscribe().with((Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object o) {
                            onTerminate.run();
                            future.complete(testMethodResult);
                        }
                    }, (Consumer)new Consumer<Throwable>(){

                        @Override
                        public void accept(Throwable t) {
                            onTerminate.run();
                            future.completeExceptionally(t);
                        }
                    });
                } else {
                    onTerminate.run();
                    this.future.complete(testMethodResult);
                }
            }
            catch (Throwable t) {
                onTerminate.run();
                this.future.completeExceptionally(t.getCause());
            }
        }
    }
}

