/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.common.runtime.graal;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.xnio.channels.StreamSourceChannel;

@TargetClass(className="org.xnio.channels.Channels")
public final class ChannelsSubstitution {
    @Delete
    private static ByteBuffer DRAIN_BUFFER = null;

    @Substitute
    public static long drain(StreamSourceChannel channel, long count) throws IOException {
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (count != 0L) {
            if ((long)buffer.limit() > count) {
                buffer.limit((int)count);
            }
            int ires = channel.read(buffer);
            buffer.clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
            count -= (long)ires;
        }
        return total;
    }

    @Substitute
    public static long drain(ReadableByteChannel channel, long count) throws IOException {
        if (channel instanceof StreamSourceChannel) {
            return ChannelsSubstitution.drain((StreamSourceChannel)channel, count);
        }
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (count != 0L) {
            if ((long)buffer.limit() > count) {
                buffer.limit((int)count);
            }
            int ires = channel.read(buffer);
            buffer.clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
            count -= (long)ires;
        }
        return total;
    }

    @Substitute
    public static long drain(FileChannel channel, long position, long count) throws IOException {
        if (channel instanceof StreamSourceChannel) {
            return ChannelsSubstitution.drain((StreamSourceChannel)channel, count);
        }
        long total = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        while (count != 0L) {
            if ((long)buffer.limit() > count) {
                buffer.limit((int)count);
            }
            int ires = channel.read(buffer);
            buffer.clear();
            switch (ires) {
                case -1: {
                    return total == 0L ? -1L : total;
                }
                case 0: {
                    return total;
                }
            }
            total += (long)ires;
        }
        return total;
    }
}

