/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.common.runtime.graal;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

@TargetClass(className="io.undertow.server.handlers.resource.URLResource")
final class URLResourceSubstitution {
    @Alias
    private boolean connectionOpened = false;
    @Alias
    private Date lastModified;
    @Alias
    private Long contentLength;
    @Alias
    private String path;

    URLResourceSubstitution() {
    }

    @Substitute
    private void openConnection() {
        if (!this.connectionOpened) {
            this.connectionOpened = true;
            ResourceInfo res = ResourceInfo.RESOURCES.get(this.path.startsWith("/") ? this.path : "/" + this.path);
            if (res != null) {
                this.contentLength = res.contentLength;
                this.lastModified = new Date(res.lastModified);
            }
        }
    }

    static final class ResourceInfo {
        private static final String META_INF_RESOURCES = "META-INF/resources";
        static final Map<String, ResourceInfo> RESOURCES;
        private final long lastModified;
        private final long contentLength;

        ResourceInfo(long lastModified, long contentLength) {
            this.lastModified = lastModified;
            this.contentLength = contentLength;
        }

        public String toString() {
            return "ResourceInfo{lastModified=" + this.lastModified + ", contentLength=" + this.contentLength + '}';
        }

        static {
            ClassLoader cl = URLResourceSubstitution.class.getClassLoader();
            HashMap<String, ResourceInfo> map = new HashMap<String, ResourceInfo>();
            URLClassLoader ucl = (URLClassLoader)cl;
            for (URL res : ucl.getURLs()) {
                if (!res.getProtocol().equals("file") || !res.getPath().endsWith(".jar")) continue;
                try (JarFile file = new JarFile(res.toURI().getPath());){
                    Enumeration<JarEntry> e = file.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        if (!entry.getName().startsWith(META_INF_RESOURCES)) continue;
                        map.put(entry.getName().substring(META_INF_RESOURCES.length()), new ResourceInfo(entry.getLastModifiedTime().toMillis(), entry.getSize()));
                    }
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            RESOURCES = Collections.unmodifiableMap(map);
        }
    }
}

