/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.undertow.deployment.MPConfigExpressionResolver;
import io.quarkus.undertow.deployment.WebMetadataBuildItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.merge.web.spec.WebCommonMetaDataMerger;
import org.jboss.metadata.parser.servlet.WebFragmentMetaDataParser;
import org.jboss.metadata.parser.servlet.WebMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.parser.util.NoopXMLResolver;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;
import org.jboss.metadata.property.SimpleExpressionResolver;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.WebCommonMetaData;
import org.jboss.metadata.web.spec.WebFragmentMetaData;
import org.jboss.metadata.web.spec.WebMetaData;

public class WebXmlParsingBuildStep {
    public static final String WEB_XML = "META-INF/web.xml";
    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> configFile() {
        return Arrays.asList(new HotDeploymentWatchedFileBuildItem(WEB_XML), new HotDeploymentWatchedFileBuildItem(WEB_FRAGMENT_XML));
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem marker() {
        return new AdditionalApplicationArchiveMarkerBuildItem(WEB_FRAGMENT_XML);
    }

    @BuildStep
    WebMetadataBuildItem createWebMetadata(ApplicationArchivesBuildItem applicationArchivesBuildItem, Consumer<AdditionalBeanBuildItem> additionalBeanBuildItemConsumer) throws Exception {
        WebMetaData result = (WebMetaData)applicationArchivesBuildItem.getRootArchive().apply(tree -> {
            WebMetaData metadata;
            Path webXml = tree.getPath(WEB_XML);
            if (webXml == null) {
                return new WebMetaData();
            }
            HashSet<String> additionalBeans = new HashSet<String>();
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            MetaDataElementParser.DTDInfo dtdInfo = new MetaDataElementParser.DTDInfo();
            inputFactory.setXMLResolver((XMLResolver)dtdInfo);
            try (InputStream in = Files.newInputStream(webXml, new OpenOption[0]);){
                XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(in);
                metadata = WebMetaDataParser.parse((XMLStreamReader)xmlReader, (MetaDataElementParser.DTDInfo)dtdInfo, (PropertyReplacer)PropertyReplacers.resolvingExpressionReplacer((SimpleExpressionResolver)new MPConfigExpressionResolver()));
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
            if (metadata.getServlets() != null) {
                for (ServletMetaData i : metadata.getServlets()) {
                    additionalBeans.add(i.getServletClass());
                }
            }
            if (metadata.getFilters() != null) {
                for (ServletMetaData i : metadata.getFilters()) {
                    additionalBeans.add(i.getFilterClass());
                }
            }
            if (metadata.getListeners() != null) {
                for (ServletMetaData i : metadata.getListeners()) {
                    additionalBeans.add(i.getListenerClass());
                }
            }
            additionalBeanBuildItemConsumer.accept(AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(additionalBeans).build());
            return metadata;
        });
        List<WebFragmentMetaData> webFragments = this.parseWebFragments(applicationArchivesBuildItem);
        for (WebFragmentMetaData webFragment : webFragments) {
            WebCommonMetaDataMerger.augment((WebCommonMetaData)result, (WebCommonMetaData)webFragment, null, (boolean)false);
        }
        return new WebMetadataBuildItem(result);
    }

    private List<WebFragmentMetaData> parseWebFragments(ApplicationArchivesBuildItem applicationArchivesBuildItem) {
        ArrayList<WebFragmentMetaData> webFragments = new ArrayList<WebFragmentMetaData>();
        for (ApplicationArchive archive : applicationArchivesBuildItem.getAllApplicationArchives()) {
            archive.accept(tree -> {
                Path webFragment = tree.getPath(WEB_FRAGMENT_XML);
                if (webFragment != null && Files.isRegularFile(webFragment, new LinkOption[0])) {
                    try (InputStream is = Files.newInputStream(webFragment, new OpenOption[0]);){
                        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                        inputFactory.setXMLResolver(NoopXMLResolver.create());
                        XMLStreamReader xmlReader = inputFactory.createXMLStreamReader(is);
                        WebFragmentMetaData webFragmentMetaData = WebFragmentMetaDataParser.parse((XMLStreamReader)xmlReader, (PropertyReplacer)PropertyReplacers.resolvingExpressionReplacer((SimpleExpressionResolver)new MPConfigExpressionResolver()));
                        webFragments.add(webFragmentMetaData);
                    }
                    catch (XMLStreamException e) {
                        throw new RuntimeException("Failed to parse " + webFragment + " " + e.getLocation(), e);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to parse " + webFragment, e);
                    }
                }
            });
        }
        return webFragments;
    }
}

