/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.undertow.deployment.GeneratedWebResourceBuildItem;
import io.quarkus.undertow.deployment.KnownPathsBuildItem;
import io.quarkus.undertow.deployment.StaticResourceFilesBuildItem;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.jar.JarEntry;

public class UndertowStaticResourcesBuildStep {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    void handleGeneratedWebResources(BuildProducer<GeneratedResourceBuildItem> generatedResources, List<GeneratedWebResourceBuildItem> generatedWebResources) throws Exception {
        for (GeneratedWebResourceBuildItem genResource : generatedWebResources) {
            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(META_INF_RESOURCES_SLASH + genResource.getName(), genResource.getClassData()));
        }
    }

    @BuildStep
    void scanStaticResources(ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<KnownPathsBuildItem> knownPathsBuilds, BuildProducer<StaticResourceFilesBuildItem> staticResourceFiles, List<GeneratedWebResourceBuildItem> generatedWebResources, LaunchModeBuildItem launchModeBuildItem) throws Exception {
        final HashSet<String> knownFiles = new HashSet<String>();
        final HashSet<String> knownDirectories = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            final Path resource = i.getChildPath(META_INF_RESOURCES);
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            Files.walk(resource, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (resource.equals(path)) {
                        return;
                    }
                    Path rel = resource.relativize(path);
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        knownDirectories.add(rel.toString());
                    } else {
                        knownFiles.add(rel.toString());
                    }
                }
            });
        }
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(META_INF_RESOURCES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (!url.getProtocol().equals("jar")) continue;
            JarURLConnection jar = (JarURLConnection)url.openConnection();
            Enumeration<JarEntry> entries = jar.getJarFile().entries();
            while (entries.hasMoreElements()) {
                String sub;
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(META_INF_RESOURCES_SLASH) || (sub = entry.getName().substring(META_INF_RESOURCES_SLASH.length())).isEmpty()) continue;
                if (entry.getName().endsWith("/")) {
                    String dir = sub.substring(0, sub.length() - 1);
                    knownDirectories.add(dir);
                    continue;
                }
                knownFiles.add(sub);
            }
        }
        for (GeneratedWebResourceBuildItem genResource : generatedWebResources) {
            String sub = genResource.getName();
            if (sub.startsWith("/")) {
                sub = sub.substring(1);
            }
            if (sub.isEmpty()) continue;
            knownFiles.add(sub);
            for (int i = 0; i < sub.length(); ++i) {
                if (sub.charAt(i) != '/') continue;
                knownDirectories.add(sub.substring(0, i));
            }
        }
        if (launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            knownPathsBuilds.produce((BuildItem)new KnownPathsBuildItem(Collections.emptySet(), Collections.emptySet()));
            staticResourceFiles.produce((BuildItem)new StaticResourceFilesBuildItem(knownFiles));
        } else {
            knownPathsBuilds.produce((BuildItem)new KnownPathsBuildItem(knownFiles, knownDirectories));
        }
    }

    @BuildStep
    void nativeImageResources(KnownPathsBuildItem paths, BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        for (String i : paths.knownFiles) {
            nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{META_INF_RESOURCES_SLASH + i}));
        }
    }
}

