/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.deployment;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.undertow.websockets.deployment.WebsocketHotReloadSetup;
import io.undertow.util.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.zip.InflaterInputStream;
import javax.websocket.HandshakeResponse;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.jboss.logging.Logger;

@ServerEndpoint(value="/quarkus/live-reload", configurator=ServerConfigurator.class)
public class HotReplacementWebsocketEndpoint {
    static final String QUARKUS_HOT_RELOAD = "/quarkus/live-reload";
    static final String QUARKUS_SECURITY_KEY = "quarkus-security-key";
    static final String QUARKUS_LIVE_RELOAD_PASSWORD = "quarkus.live-reload.password";
    static final String QUARKUS_LIVE_RELOAD_PASSWORD_ENV = "QUARKUS_LIVE_RELOAD_PASSWORD";
    private static Logger logger = Logger.getLogger(HotReplacementWebsocketEndpoint.class);
    private static final long MAX_WAIT_TIME = 15000L;
    private static final int CLASS_CHANGE_RESPONSE = 2;
    private static final int CLASS_CHANGE_REQUEST = 1;
    private static final Object lock = new Object();
    private static ConnectionContext connection;
    private ConnectionContext currentConnection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    void close() {
        Object object = lock;
        synchronized (object) {
            if (connection == this.currentConnection) {
                connection = null;
            }
        }
        this.currentConnection.messages.add(new Message());
    }

    @OnError
    public void error(Throwable t) {
        logger.error((Object)"Error in hot replacement websocket connection", t);
        this.currentConnection.messages.add(new Message());
        IoUtils.safeClose((Closeable)this.currentConnection.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnOpen
    public void onConnect(Session session) {
        Session old = null;
        Object object = lock;
        synchronized (object) {
            if (connection != null) {
                old = HotReplacementWebsocketEndpoint.connection.connection;
                HotReplacementWebsocketEndpoint.connection.messages.add(new Message());
            }
            connection = this.currentConnection = new ConnectionContext(session);
        }
        IoUtils.safeClose((Closeable)old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkForChanges(HotReplacementContext hrc) {
        block35: {
            ConnectionContext con;
            Object object = lock;
            synchronized (object) {
                con = connection;
            }
            if (con == null) {
                return;
            }
            try {
                con.connection.getBasicRemote().sendBinary(ByteBuffer.wrap(new byte[]{1}));
            }
            catch (IOException e) {
                try {
                    con.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                con.messages.add(new Message());
            }
            try {
                List resourcesDir;
                Message m = con.messages.poll(15000L, TimeUnit.MILLISECONDS);
                if (m == null) {
                    logger.error((Object)"Timed out processing hot replacement");
                    break block35;
                }
                if (m.srcFiles.isEmpty() && m.resources.isEmpty()) break block35;
                if (hrc.getSourcesDir() != null) {
                    for (Map.Entry<String, byte[]> i : m.srcFiles.entrySet()) {
                        for (Path sourcesDir : hrc.getSourcesDir()) {
                            Path path = sourcesDir.resolve(i.getKey());
                            Files.createDirectories(path.getParent(), new FileAttribute[0]);
                            FileOutputStream out = new FileOutputStream(path.toFile());
                            Throwable throwable = null;
                            try {
                                out.write(i.getValue());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (out == null) continue;
                                if (throwable != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                out.close();
                            }
                        }
                    }
                }
                if ((resourcesDir = hrc.getResourcesDir()) == null || resourcesDir.isEmpty()) break block35;
                for (Map.Entry<String, byte[]> i : m.resources.entrySet()) {
                    Path path = ((Path)resourcesDir.get(0)).resolve(i.getKey());
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    FileOutputStream out = new FileOutputStream(path.toFile());
                    Throwable throwable = null;
                    try {
                        out.write(i.getValue());
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to process hot deployment", (Throwable)e);
            }
        }
    }

    @OnMessage
    public void handleResponseMessage(byte[] message) throws IOException {
        byte first = message[0];
        if (first == 2) {
            Message m = new Message();
            try (DataInputStream in = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(message, 1, message.length - 1)));){
                byte[] rd;
                int byteLength;
                String key;
                int i;
                Map<String, byte[]> srcFiles = m.srcFiles;
                Map<String, byte[]> resources = m.resources;
                int count = in.readInt();
                for (i = 0; i < count; ++i) {
                    key = in.readUTF();
                    byteLength = in.readInt();
                    rd = new byte[byteLength];
                    in.readFully(rd);
                    srcFiles.put(key, rd);
                }
                count = in.readInt();
                for (i = 0; i < count; ++i) {
                    key = in.readUTF();
                    byteLength = in.readInt();
                    rd = new byte[byteLength];
                    in.readFully(rd);
                    resources.put(key, rd);
                }
                this.currentConnection.messages.add(m);
            }
        }
    }

    public static final class ServerConfigurator
    extends ServerEndpointConfig.Configurator {
        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            List headers = (List)request.getHeaders().get(HotReplacementWebsocketEndpoint.QUARKUS_SECURITY_KEY);
            if (headers == null || headers.isEmpty()) {
                throw new RuntimeException("No security key present");
            }
            if (!((String)headers.get(0)).equals(WebsocketHotReloadSetup.replacementPassword)) {
                throw new RuntimeException("Security key did not match");
            }
            super.modifyHandshake(sec, request, response);
        }
    }

    private static final class ConnectionContext {
        final Session connection;
        final BlockingDeque<Message> messages = new LinkedBlockingDeque<Message>();

        private ConnectionContext(Session connection) {
            this.connection = connection;
        }
    }

    static final class Message {
        Map<String, byte[]> srcFiles = new HashMap<String, byte[]>();
        Map<String, byte[]> resources = new HashMap<String, byte[]>();

        Message() {
        }
    }
}

