/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.runtime.devmode;

import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.undertow.runtime.UndertowDeploymentRecorder;
import io.quarkus.undertow.websockets.runtime.devmode.HotReplacementWebsocketEndpoint;
import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import org.jboss.logging.Logger;

public class WebsocketHotReloadSetup
implements HotReplacementSetup {
    private static Logger logger = Logger.getLogger(WebsocketHotReloadSetup.class);
    static volatile String replacementPassword;

    public void setupHotDeployment(final HotReplacementContext hotReplacementContext) {
        String password = System.getProperty("quarkus.live-reload.password");
        if (password == null || password.isEmpty()) {
            password = System.getenv("QUARKUS_LIVE_RELOAD_PASSWORD");
        }
        if (password != null && !password.isEmpty()) {
            replacementPassword = password;
        } else {
            File appConfig;
            List resources = hotReplacementContext.getResourcesDir();
            if (!resources.isEmpty() && (appConfig = ((Path)resources.get(0)).resolve("application.properties").toFile()).isFile()) {
                try (FileInputStream is = new FileInputStream(appConfig);
                     InputStreamReader isr = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
                     BufferedReader br = new BufferedReader(isr);){
                    Properties p = new Properties();
                    p.load(br);
                    replacementPassword = p.getProperty("quarkus.live-reload.password");
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to read application.properties", (Throwable)e);
                }
            }
        }
        if (replacementPassword == null) {
            return;
        }
        logger.info((Object)"Using websocket based hot deployment");
        try {
            hotReplacementContext.addPreScanStep(new Runnable(){

                @Override
                public void run() {
                    HotReplacementWebsocketEndpoint.checkForChanges(hotReplacementContext);
                }
            });
            WebSocketDeploymentInfo info = new WebSocketDeploymentInfo();
            info.addEndpoint(HotReplacementWebsocketEndpoint.class);
            DeploymentInfo d = new DeploymentInfo();
            d.setDeploymentName("hot-replacement-websockets");
            d.setContextPath("/");
            d.setClassLoader(this.getClass().getClassLoader());
            d.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)info);
            ServletContainer servletContainer = Servlets.defaultContainer();
            DeploymentManager manager = servletContainer.addDeployment(d);
            manager.deploy();
            final HttpHandler ws = manager.start();
            UndertowDeploymentRecorder.addHotDeploymentWrapper((HandlerWrapper)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return Handlers.predicate((Predicate)Predicates.path((String)"/quarkus/live-reload"), (HttpHandler)ws, (HttpHandler)handler);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

