/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ComputingCache;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.ContextInstanceHandleImpl;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.undertow.servlet.handlers.ServletRequestContext;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

@WebListener
public class HttpSessionContext
implements InjectableContext,
HttpSessionListener {
    private static final String CONTEXTUAL_INSTANCES_KEY = HttpSessionContext.class.getName() + ".contextualInstances";

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        HttpServletRequest request = this.servletRequest();
        if (request == null) {
            throw new ContextNotActiveException();
        }
        InjectableBean bean = (InjectableBean)contextual;
        ComputingCache<Key, ContextInstanceHandle<?>> contextualInstances = this.getContextualInstances(request);
        if (creationalContext != null) {
            return (T)((ContextInstanceHandle)contextualInstances.getValue((Object)new Key(creationalContext, bean.getIdentifier()))).get();
        }
        InstanceHandle handle = (InstanceHandle)contextualInstances.getValueIfPresent((Object)new Key(null, bean.getIdentifier()));
        return (T)(handle != null ? handle.get() : null);
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return this.servletRequest() != null;
    }

    public Collection<ContextInstanceHandle<?>> getAll() {
        HttpServletRequest httpServletRequest = this.servletRequest();
        if (httpServletRequest != null) {
            return new ArrayList(this.getContextualInstances(httpServletRequest).getPresentValues());
        }
        return Collections.emptyList();
    }

    public void destroy(Contextual<?> contextual) {
        HttpServletRequest httpServletRequest = this.servletRequest();
        if (httpServletRequest == null) {
            throw new ContextNotActiveException();
        }
        InjectableBean bean = (InjectableBean)contextual;
        InstanceHandle instanceHandle = (InstanceHandle)this.getContextualInstances(httpServletRequest).remove((Object)new Key(null, bean.getIdentifier()));
        if (instanceHandle != null) {
            instanceHandle.destroy();
        }
    }

    public void destroy() {
        HttpServletRequest httpServletRequest = this.servletRequest();
        if (httpServletRequest == null) {
            throw new ContextNotActiveException();
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            this.destroy(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy(HttpSession session) {
        HttpSessionContext httpSessionContext = this;
        synchronized (httpSessionContext) {
            ComputingCache<Key, ContextInstanceHandle<?>> contextualInstances = this.getContextualInstances(session);
            for (ContextInstanceHandle instance : contextualInstances.getPresentValues()) {
                try {
                    instance.destroy();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to destroy instance" + instance.get(), e);
                }
            }
            contextualInstances.clear();
        }
    }

    private ComputingCache<Key, ContextInstanceHandle<?>> getContextualInstances(HttpServletRequest httpServletRequest) {
        return this.getContextualInstances(httpServletRequest.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComputingCache<Key, ContextInstanceHandle<?>> getContextualInstances(HttpSession session) {
        ComputingCache contextualInstances = (ComputingCache)session.getAttribute(CONTEXTUAL_INSTANCES_KEY);
        if (contextualInstances == null) {
            HttpSessionContext httpSessionContext = this;
            synchronized (httpSessionContext) {
                contextualInstances = (ComputingCache)session.getAttribute(CONTEXTUAL_INSTANCES_KEY);
                if (contextualInstances == null) {
                    contextualInstances = new ComputingCache(key -> {
                        InjectableBean bean = Arc.container().bean(key.beanIdentifier);
                        return new ContextInstanceHandleImpl(bean, bean.create(key.creationalContext), key.creationalContext);
                    });
                    session.setAttribute(CONTEXTUAL_INSTANCES_KEY, (Object)contextualInstances);
                }
            }
        }
        return contextualInstances;
    }

    private HttpServletRequest servletRequest() {
        try {
            return (HttpServletRequest)ServletRequestContext.requireCurrent().getServletRequest();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        this.destroy(se.getSession());
    }

    static class Key {
        CreationalContext<?> creationalContext;
        String beanIdentifier;

        public Key(CreationalContext<?> creationalContext, String beanIdentifier) {
            this.creationalContext = creationalContext;
            this.beanIdentifier = beanIdentifier;
        }

        public int hashCode() {
            return Objects.hash(this.beanIdentifier);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return Objects.equals(this.beanIdentifier, other.beanIdentifier);
        }
    }
}

