/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime.filters;

import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.undertow.runtime.HttpConfig;
import io.quarkus.undertow.runtime.filters.CORSFilter;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;

@Recorder
public class CORSRecorder {
    public CORSServletExtension buildCORSExtension() {
        return new CORSServletExtension();
    }

    public void setHttpConfig(HttpConfig config) {
        CORSFilter.corsConfig = config.cors;
    }

    public static class CORSServletExtension
    implements ServletExtension {
        public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
            CORSFilter filter = new CORSFilter();
            ImmediateInstanceFactory filterFactory = new ImmediateInstanceFactory((Object)filter);
            FilterInfo filterInfo = new FilterInfo(CORSFilter.class.getName(), CORSFilter.class, (InstanceFactory)filterFactory);
            filterInfo.setAsyncSupported(true);
            deploymentInfo.addFilter(filterInfo);
            deploymentInfo.addFilterServletNameMapping(CORSFilter.class.getName(), "*", DispatcherType.ERROR);
            deploymentInfo.addFilterServletNameMapping(CORSFilter.class.getName(), "*", DispatcherType.FORWARD);
            deploymentInfo.addFilterServletNameMapping(CORSFilter.class.getName(), "*", DispatcherType.INCLUDE);
            deploymentInfo.addFilterServletNameMapping(CORSFilter.class.getName(), "*", DispatcherType.REQUEST);
            deploymentInfo.addFilterServletNameMapping(CORSFilter.class.getName(), "*", DispatcherType.ASYNC);
        }
    }
}

