/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.SingleConstraintMatch;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Singleton;

@Singleton
public class ServletHttpSecurityPolicy
implements HttpSecurityPolicy {
    private volatile Deployment deployment;
    private volatile String contextPath;

    public CompletionStage<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, SecurityIdentity identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        SecurityPathMatch match;
        SingleConstraintMatch mergedConstraint;
        String requestPath = request.request().path();
        if (!requestPath.startsWith(this.contextPath)) {
            return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.PERMIT);
        }
        if (!this.contextPath.equals("/")) {
            requestPath = requestPath.substring(this.contextPath.length() - 1);
        }
        if ((mergedConstraint = (match = this.deployment.getSecurityPathMatches().getSecurityInfo(requestPath, request.request().rawMethod())).getMergedConstraint()).getRequiredRoles().isEmpty()) {
            SecurityInfo.EmptyRoleSemantic emptyRoleSemantic = mergedConstraint.getEmptyRoleSemantic();
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.PERMIT) {
                return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.PERMIT);
            }
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.DENY) {
                return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.DENY);
            }
            if (emptyRoleSemantic == SecurityInfo.EmptyRoleSemantic.AUTHENTICATE) {
                if (identity.isAnonymous()) {
                    return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.DENY);
                }
                return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.PERMIT);
            }
            CompletableFuture<HttpSecurityPolicy.CheckResult> c = new CompletableFuture<HttpSecurityPolicy.CheckResult>();
            c.completeExceptionally(new RuntimeException("Unknown empty role semantic " + emptyRoleSemantic));
            return c;
        }
        for (String i : mergedConstraint.getRequiredRoles()) {
            if (!identity.hasRole(i)) continue;
            return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.PERMIT);
        }
        return CompletableFuture.completedFuture(HttpSecurityPolicy.CheckResult.DENY);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public ServletHttpSecurityPolicy setDeployment(Deployment deployment) {
        this.deployment = deployment;
        this.contextPath = deployment.getDeploymentInfo().getContextPath();
        if (!this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath + "/";
        }
        return this;
    }
}

