/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.undertow.servlet.handlers.ServletRequestContext;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;

public class ServletThreadContextProvider
implements ThreadContextProvider {
    public ThreadContextSnapshot currentContext(Map<String, String> props) {
        ServletRequestContext captured = ServletRequestContext.current();
        return () -> {
            ServletRequestContext current = this.restore(captured);
            return () -> this.restore(current);
        };
    }

    private ServletRequestContext restore(ServletRequestContext context) {
        ServletRequestContext currentContext = ServletRequestContext.current();
        if (context == null) {
            ServletRequestContext.clearCurrentServletAttachments();
        } else {
            ServletRequestContext.setCurrentRequestContext((ServletRequestContext)context);
        }
        return currentContext;
    }

    public ThreadContextSnapshot clearedContext(Map<String, String> props) {
        return () -> {
            ServletRequestContext current = this.restore(null);
            return () -> this.restore(current);
        };
    }

    public String getThreadContextType() {
        return "Servlet";
    }
}

