/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.runtime;

import io.undertow.httpcore.OutputChannel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class KnownPathResourceManager
implements ResourceManager {
    public static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
    private final NavigableSet<String> files;
    private final NavigableSet<String> directories;
    private final ResourceManager underlying;

    public KnownPathResourceManager(Set<String> files, Set<String> directories, ResourceManager underlying) {
        this.underlying = underlying;
        TreeSet<String> tree = new TreeSet<String>();
        for (String i : files) {
            if (i.startsWith("/")) {
                i = i.substring(1);
            }
            if (i.endsWith("/")) {
                i = i.substring(0, i.length() - 1);
            }
            tree.add(i);
        }
        this.files = tree;
        HashSet<String> tmp = new HashSet<String>();
        for (String i : directories) {
            if (i.startsWith("/")) {
                i = i.substring(1);
            }
            if (i.endsWith("/")) {
                i = i.substring(0, i.length() - 1);
            }
            tmp.add(i);
        }
        tmp.add("");
        this.directories = new TreeSet<String>(tmp);
    }

    public Resource getResource(String path) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (this.directories.contains(path)) {
            return new DirectoryResource(path);
        }
        return this.underlying.getResource(path);
    }

    public void close() throws IOException {
        this.underlying.close();
    }

    private class DirectoryResource
    implements Resource {
        private final String path;

        private DirectoryResource(String path) {
            this.path = this.evaluatePath(path);
        }

        private String evaluatePath(String path) {
            return path.replaceAll("\\\\", "/");
        }

        public String getPath() {
            return this.path;
        }

        public Date getLastModified() {
            return null;
        }

        public String getLastModifiedString() {
            return null;
        }

        public ETag getETag() {
            return null;
        }

        public String getName() {
            int i = this.path.lastIndexOf(47);
            if (i == -1) {
                return this.path;
            }
            return this.path.substring(i + 1);
        }

        public boolean isDirectory() {
            return true;
        }

        public List<Resource> list() {
            Object slashPath;
            ArrayList<Resource> ret = new ArrayList<Resource>();
            Object object = slashPath = this.path.isEmpty() ? this.path : this.path + "/";
            if (IS_WINDOWS) {
                slashPath = ((String)slashPath).replaceAll("/", "\\\\");
            }
            SortedSet<String> fileSet = KnownPathResourceManager.this.files.tailSet((String)slashPath);
            SortedSet<String> dirSet = KnownPathResourceManager.this.directories.tailSet((String)slashPath);
            block2: for (SortedSet<String> s : List.of(fileSet, dirSet)) {
                for (String file : s) {
                    String i = file;
                    if (i.equals(slashPath)) continue;
                    if (!i.startsWith((String)slashPath)) continue block2;
                    if ((i = this.evaluatePath(i)).substring(((String)slashPath).length()).contains("/")) continue;
                    try {
                        Resource resource = KnownPathResourceManager.this.underlying.getResource(i);
                        if (resource == null && KnownPathResourceManager.this.directories.contains(file)) {
                            resource = new DirectoryResource(file);
                        }
                        if (resource == null) {
                            throw new RuntimeException("Unable to get listed resource " + i + " from directory " + this.path + " for path " + (String)slashPath + " from underlying manager " + String.valueOf(KnownPathResourceManager.this.underlying));
                        }
                        ret.add(resource);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            }
            return ret;
        }

        public String getContentType(MimeMappings mimeMappings) {
            return null;
        }

        public void serveBlocking(OutputStream outputStream, HttpServerExchange exchange) throws IOException {
            throw new IOException("Cannot serve directory");
        }

        public void serveAsync(OutputChannel stream, HttpServerExchange exchange) {
            exchange.setStatusCode(500);
            exchange.endExchange();
        }

        public Long getContentLength() {
            return null;
        }

        public String getCacheKey() {
            return null;
        }

        public File getFile() {
            return null;
        }

        public Path getFilePath() {
            return null;
        }

        public File getResourceManagerRoot() {
            return null;
        }

        public Path getResourceManagerRootPath() {
            return null;
        }

        public URL getUrl() {
            return null;
        }
    }
}

