/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vault.runtime.VaultManager;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import io.quarkus.vault.runtime.config.VaultConfigSourceProvider;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

@Recorder
public class VaultRecorder {
    private static final Logger log = Logger.getLogger(VaultRecorder.class);

    public RuntimeValue<ConfigSourceProvider> configureRuntimeProperties(VaultBuildTimeConfig vaultBuildTimeConfig, VaultRuntimeConfig vaultRuntimeConfig, TlsConfig tlsConfig) {
        if (vaultRuntimeConfig.url.isPresent()) {
            VaultManager.init(vaultBuildTimeConfig, vaultRuntimeConfig, tlsConfig);
            return new RuntimeValue((Object)new VaultConfigSourceProvider(vaultRuntimeConfig));
        }
        return this.emptyRuntimeValue();
    }

    private RuntimeValue<ConfigSourceProvider> emptyRuntimeValue() {
        return new RuntimeValue((Object)new EmptyConfigSourceProvider());
    }

    private static class EmptyConfigSourceProvider
    implements ConfigSourceProvider {
        private EmptyConfigSourceProvider() {
        }

        public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
            return Collections.emptyList();
        }
    }
}

