/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultException;
import io.quarkus.vault.VaultTransitExportKeyType;
import io.quarkus.vault.VaultTransitKeyDetail;
import io.quarkus.vault.VaultTransitSecretEngine;
import io.quarkus.vault.runtime.Base64String;
import io.quarkus.vault.runtime.SigningRequestResultPair;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitCreateKeyBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptBatchInput;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitDecryptDataBatchResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncrypt;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptBatchInput;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitEncryptDataBatchResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyConfigBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyExport;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitKeyExportData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitListKeysData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitReadKeyData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitRewrapBatchInput;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitRewrapBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSign;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignBatchInput;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitSignDataBatchResult;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerify;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyBatchInput;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyBody;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyData;
import io.quarkus.vault.runtime.client.dto.transit.VaultTransitVerifyDataBatchResult;
import io.quarkus.vault.runtime.config.TransitKeyConfig;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.quarkus.vault.runtime.transit.DecryptionResult;
import io.quarkus.vault.runtime.transit.EncryptionResult;
import io.quarkus.vault.runtime.transit.SigningResult;
import io.quarkus.vault.runtime.transit.VaultTransitBatchResult;
import io.quarkus.vault.runtime.transit.VerificationResult;
import io.quarkus.vault.transit.ClearData;
import io.quarkus.vault.transit.DecryptionRequest;
import io.quarkus.vault.transit.EncryptionRequest;
import io.quarkus.vault.transit.KeyConfigRequestDetail;
import io.quarkus.vault.transit.KeyCreationRequestDetail;
import io.quarkus.vault.transit.RewrappingRequest;
import io.quarkus.vault.transit.SigningInput;
import io.quarkus.vault.transit.SigningRequest;
import io.quarkus.vault.transit.TransitContext;
import io.quarkus.vault.transit.VaultDecryptionBatchException;
import io.quarkus.vault.transit.VaultEncryptionBatchException;
import io.quarkus.vault.transit.VaultRewrappingBatchException;
import io.quarkus.vault.transit.VaultSigningBatchException;
import io.quarkus.vault.transit.VaultTransitKeyExportDetail;
import io.quarkus.vault.transit.VaultVerificationBatchException;
import io.quarkus.vault.transit.VerificationRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class VaultTransitManager
implements VaultTransitSecretEngine {
    private VaultAuthManager vaultAuthManager;
    private VaultClient vaultClient;
    private VaultRuntimeConfig serverConfig;

    public VaultTransitManager(VaultAuthManager vaultAuthManager, VaultClient vaultClient, VaultRuntimeConfig serverConfig) {
        this.vaultAuthManager = vaultAuthManager;
        this.vaultClient = vaultClient;
        this.serverConfig = serverConfig;
    }

    @Override
    public String encrypt(String keyName, String clearData) {
        return this.encrypt(keyName, new ClearData(clearData), null);
    }

    @Override
    public String encrypt(String keyName, ClearData clearData, TransitContext transitContext) {
        EncryptionRequest item = new EncryptionRequest(clearData, transitContext);
        return (String)this.encryptBatch(keyName, Collections.singletonList(item)).get(0).getValueOrElseError();
    }

    private String encrypt(String keyName, EncryptionRequest request) {
        VaultTransitEncryptBody body = new VaultTransitEncryptBody();
        body.plaintext = Base64String.from((byte[])request.getData().getValue());
        body.context = Base64String.from((byte[])request.getContext());
        body.keyVersion = request.getKeyVersion();
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
            body.type = config.type.orElse(null);
            body.convergentEncryption = config.convergentEncryption.orElse(null);
        }
        VaultTransitEncrypt encrypt = this.vaultClient.encrypt(this.getToken(), keyName, body);
        EncryptionResult result = new EncryptionResult(((VaultTransitEncryptData)encrypt.data).ciphertext, ((VaultTransitEncryptData)encrypt.data).error);
        if (result.isInError()) {
            HashMap<EncryptionRequest, EncryptionResult> errorMap = new HashMap<EncryptionRequest, EncryptionResult>();
            errorMap.put(request, result);
            throw new VaultEncryptionBatchException("encryption error with key " + keyName, errorMap);
        }
        return (String)result.getValue();
    }

    @Override
    public Map<EncryptionRequest, String> encrypt(String keyName, List<EncryptionRequest> requests) {
        if (requests.size() == 1) {
            EncryptionRequest request = requests.get(0);
            HashMap<EncryptionRequest, String> result = new HashMap<EncryptionRequest, String>();
            result.put(request, this.encrypt(keyName, request));
            return result;
        }
        List<EncryptionResult> results = this.encryptBatch(keyName, requests);
        this.checkBatchErrors(results, errors -> new VaultEncryptionBatchException(errors + " encryption errors", this.zip(requests, results)));
        return this.zipRequestToValue(requests, results);
    }

    private List<EncryptionResult> encryptBatch(String keyName, List<EncryptionRequest> requests) {
        VaultTransitEncryptBody body = new VaultTransitEncryptBody();
        body.batchInput = requests.stream().map(this::getVaultTransitEncryptBatchInput).collect(Collectors.toList());
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
            body.type = config.type.orElse(null);
            body.convergentEncryption = config.convergentEncryption.orElse(null);
        }
        VaultTransitEncrypt encrypt = this.vaultClient.encrypt(this.getToken(), keyName, body);
        return ((VaultTransitEncryptData)encrypt.data).batchResults.stream().map(this::getVaultTransitEncryptBatchResult).collect(Collectors.toList());
    }

    @Override
    public ClearData decrypt(String keyName, String ciphertext) {
        return this.decrypt(keyName, ciphertext, null);
    }

    @Override
    public ClearData decrypt(String keyName, String ciphertext, TransitContext transitContext) {
        DecryptionRequest item = new DecryptionRequest(ciphertext, transitContext);
        return (ClearData)this.decryptBatch(keyName, Collections.singletonList(item)).get(0).getValueOrElseError();
    }

    @Override
    public Map<DecryptionRequest, ClearData> decrypt(String keyName, List<DecryptionRequest> requests) {
        List<DecryptionResult> results = this.decryptBatch(keyName, requests);
        this.checkBatchErrors(results, errors -> new VaultDecryptionBatchException(errors + " decryption errors", this.zip(requests, results)));
        return this.zipRequestToValue(requests, results);
    }

    private List<DecryptionResult> decryptBatch(String keyName, List<DecryptionRequest> requests) {
        VaultTransitDecryptBody body = new VaultTransitDecryptBody();
        body.batchInput = requests.stream().map(this::getVaultTransitDecryptBatchInput).collect(Collectors.toList());
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
        }
        VaultTransitDecrypt decrypt = this.vaultClient.decrypt(this.getToken(), keyName, body);
        return ((VaultTransitDecryptData)decrypt.data).batchResults.stream().map(this::getVaultTransitDecryptBatchResult).collect(Collectors.toList());
    }

    @Override
    public String rewrap(String keyName, String ciphertext) {
        return this.rewrap(keyName, ciphertext, null);
    }

    @Override
    public String rewrap(String keyName, String ciphertext, TransitContext transitContext) {
        RewrappingRequest item = new RewrappingRequest(ciphertext, transitContext);
        return (String)this.rewrapBatch(keyName, Collections.singletonList(item)).get(0).getValueOrElseError();
    }

    @Override
    public Map<RewrappingRequest, String> rewrap(String keyName, List<RewrappingRequest> requests) {
        List<EncryptionResult> results = this.rewrapBatch(keyName, requests);
        this.checkBatchErrors(results, errors -> new VaultRewrappingBatchException(errors + " rewrapping errors", this.zip(requests, results)));
        return this.zipRequestToValue(requests, results);
    }

    private List<EncryptionResult> rewrapBatch(String keyName, List<RewrappingRequest> requests) {
        VaultTransitRewrapBody body = new VaultTransitRewrapBody();
        body.batchInput = requests.stream().map(this::getVaultTransitRewrapBatchInput).collect(Collectors.toList());
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
        }
        VaultTransitEncrypt encrypt = this.vaultClient.rewrap(this.getToken(), keyName, body);
        return ((VaultTransitEncryptData)encrypt.data).batchResults.stream().map(this::getVaultTransitEncryptBatchResult).collect(Collectors.toList());
    }

    @Override
    public String sign(String keyName, String input) {
        return this.sign(keyName, new SigningInput(input), null);
    }

    @Override
    public String sign(String keyName, SigningInput input, TransitContext transitContext) {
        SigningRequest item = new SigningRequest(input, transitContext);
        List<SigningRequestResultPair> pairs = Collections.singletonList(new SigningRequestResultPair(item));
        this.signBatch(keyName, -1, pairs);
        return (String)pairs.get(0).getResult().getValueOrElseError();
    }

    @Override
    public Map<SigningRequest, String> sign(String keyName, List<SigningRequest> requests) {
        List pairs = requests.stream().map(SigningRequestResultPair::new).collect(Collectors.toList());
        pairs.stream().collect(Collectors.groupingBy(SigningRequestResultPair::getKeyVersion)).forEach((keyVersion, subpairs) -> this.signBatch(keyName, (int)keyVersion, (List<SigningRequestResultPair>)subpairs));
        List results = pairs.stream().map(SigningRequestResultPair::getResult).collect(Collectors.toList());
        this.checkBatchErrors(results, errors -> new VaultSigningBatchException(errors + " signing errors", this.zip(requests, results)));
        return this.zipRequestToValue(requests, results);
    }

    private void signBatch(String keyName, int keyVersion, List<SigningRequestResultPair> pairs) {
        String hashAlgorithm = null;
        VaultTransitSignBody body = new VaultTransitSignBody();
        body.keyVersion = keyVersion == -1 ? null : Integer.valueOf(keyVersion);
        body.batchInput = pairs.stream().map(SigningRequestResultPair::getRequest).map(this::getVaultTransitSignBatchInput).collect(Collectors.toList());
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
            hashAlgorithm = config.hashAlgorithm.orElse(null);
            body.signatureAlgorithm = config.signatureAlgorithm.orElse(null);
            body.prehashed = config.prehashed.orElse(null);
        }
        VaultTransitSign sign = this.vaultClient.sign(this.getToken(), keyName, hashAlgorithm, body);
        for (int i = 0; i < pairs.size(); ++i) {
            VaultTransitSignDataBatchResult result = (VaultTransitSignDataBatchResult)((VaultTransitSignData)sign.data).batchResults.get(i);
            pairs.get(i).setResult(this.getVaultTransitSignBatchResult(result));
        }
    }

    @Override
    public void verifySignature(String keyName, String signature, String input) {
        this.verifySignature(keyName, signature, new SigningInput(input), null);
    }

    @Override
    public void verifySignature(String keyName, String signature, SigningInput input, TransitContext transitContext) {
        VerificationRequest item = new VerificationRequest(signature, input, transitContext);
        Boolean valid = (Boolean)this.verifyBatch(keyName, Collections.singletonList(item)).get(0).getValueOrElseError();
        if (!Boolean.TRUE.equals(valid)) {
            throw new VaultException("invalid signature");
        }
    }

    @Override
    public void verifySignature(String keyName, List<VerificationRequest> requests) {
        List<VerificationResult> results = this.verifyBatch(keyName, requests);
        Map<VerificationRequest, VerificationResult> resultMap = this.zip(requests, results);
        this.checkBatchErrors(results, errors -> new VaultVerificationBatchException(errors + " verification errors", resultMap));
    }

    private List<VerificationResult> verifyBatch(String keyName, List<VerificationRequest> requests) {
        String hashAlgorithm = null;
        VaultTransitVerifyBody body = new VaultTransitVerifyBody();
        body.batchInput = requests.stream().map(this::getVaultTransitVerifyBatchInput).collect(Collectors.toList());
        TransitKeyConfig config = this.serverConfig.transit.key.get(keyName);
        if (config != null) {
            keyName = config.name.orElse(keyName);
            hashAlgorithm = config.hashAlgorithm.orElse(null);
            body.prehashed = config.prehashed.orElse(null);
            body.signatureAlgorithm = config.signatureAlgorithm.orElse(null);
        }
        VaultTransitVerify verify = this.vaultClient.verify(this.getToken(), keyName, hashAlgorithm, body);
        return ((VaultTransitVerifyData)verify.data).batchResults.stream().map(this::getVaultTransitVerifyBatchResult).collect(Collectors.toList());
    }

    @Override
    public void createKey(String keyName, KeyCreationRequestDetail detail) {
        VaultTransitCreateKeyBody body = new VaultTransitCreateKeyBody();
        if (detail != null) {
            body.allowPlaintextBackup = detail.getAllowPlaintextBackup();
            body.convergentEncryption = detail.getConvergentEncryption();
            body.derived = detail.getDerived();
            body.exportable = detail.getExportable();
            body.type = detail.getType();
        }
        this.vaultClient.createTransitKey(this.getToken(), keyName, body);
    }

    @Override
    public void updateKeyConfiguration(String keyName, KeyConfigRequestDetail detail) {
        VaultTransitKeyConfigBody body = new VaultTransitKeyConfigBody();
        body.allowPlaintextBackup = detail.getAllowPlaintextBackup();
        body.deletionAllowed = detail.getDeletionAllowed();
        body.minEncryptionVersion = detail.getMinEncryptionVersion();
        body.minDecryptionVersion = detail.getMinDecryptionVersion();
        body.exportable = detail.getExportable();
        this.vaultClient.updateTransitKeyConfiguration(this.getToken(), keyName, body);
    }

    @Override
    public void deleteKey(String keyName) {
        this.vaultClient.deleteTransitKey(this.getToken(), keyName);
    }

    @Override
    public VaultTransitKeyExportDetail exportKey(String keyName, VaultTransitExportKeyType keyType, String keyVersion) {
        VaultTransitKeyExport keyExport = this.vaultClient.exportTransitKey(this.getToken(), keyType.name() + "-key", keyName, keyVersion);
        VaultTransitKeyExportDetail detail = new VaultTransitKeyExportDetail();
        detail.setName(((VaultTransitKeyExportData)keyExport.data).name);
        detail.setKeys(((VaultTransitKeyExportData)keyExport.data).keys);
        return detail;
    }

    @Override
    public VaultTransitKeyDetail readKey(String keyName) {
        try {
            return this.map((VaultTransitReadKeyData)this.vaultClient.readTransitKey((String)this.getToken(), (String)keyName).data);
        }
        catch (VaultClientException e) {
            if (e.getStatus() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public List<String> listKeys() {
        return ((VaultTransitListKeysData)this.vaultClient.listTransitKeys((String)this.getToken()).data).keys;
    }

    protected VaultTransitKeyDetail map(VaultTransitReadKeyData data) {
        VaultTransitKeyDetail result = new VaultTransitKeyDetail();
        result.setDetail(data.detail);
        result.setDeletionAllowed(data.deletionAllowed);
        result.setDerived(data.derived);
        result.setExportable(data.exportable);
        result.setAllowPlaintextBackup(data.allowPlaintextBackup);
        result.setKeys(data.keys);
        result.setMinDecryptionVersion(data.minDecryptionVersion);
        result.setMinEncryptionVersion(data.minEncryptionVersion);
        result.setName(data.name);
        result.setSupportsEncryption(data.supportsEncryption);
        result.setSupportsDecryption(data.supportsDecryption);
        result.setSupportsDerivation(data.supportsDerivation);
        result.setSupportsSigning(data.supportsSigning);
        return result;
    }

    private void checkBatchErrors(List<? extends VaultTransitBatchResult> results, Function<Long, ? extends VaultException> exceptionProducer) {
        long errors = results.stream().filter(VaultTransitBatchResult::isInError).count();
        if (errors != 0L) {
            throw exceptionProducer.apply(errors);
        }
    }

    private String getToken() {
        return this.vaultAuthManager.getClientToken();
    }

    private EncryptionResult getVaultTransitEncryptBatchResult(VaultTransitEncryptDataBatchResult result) {
        return new EncryptionResult(result.ciphertext, result.error);
    }

    private VaultTransitEncryptBatchInput getVaultTransitEncryptBatchInput(EncryptionRequest data) {
        Base64String plaintext = Base64String.from((byte[])data.getData().getValue());
        Base64String context = Base64String.from((byte[])data.getContext());
        VaultTransitEncryptBatchInput batchInput = new VaultTransitEncryptBatchInput(plaintext, context);
        batchInput.keyVersion = data.getKeyVersion();
        return batchInput;
    }

    private VaultTransitRewrapBatchInput getVaultTransitRewrapBatchInput(RewrappingRequest data) {
        String ciphertext = data.getCiphertext();
        Base64String context = Base64String.from((byte[])data.getContext());
        VaultTransitRewrapBatchInput batchInput = new VaultTransitRewrapBatchInput(ciphertext, context);
        batchInput.keyVersion = data.getKeyVersion();
        return batchInput;
    }

    private DecryptionResult getVaultTransitDecryptBatchResult(VaultTransitDecryptDataBatchResult result) {
        return new DecryptionResult(new ClearData(result.plaintext.decodeAsBytes()), result.error);
    }

    private VaultTransitDecryptBatchInput getVaultTransitDecryptBatchInput(DecryptionRequest data) {
        String ciphertext = data.getCiphertext();
        Base64String context = Base64String.from((byte[])data.getContext());
        return new VaultTransitDecryptBatchInput(ciphertext, context);
    }

    private SigningResult getVaultTransitSignBatchResult(VaultTransitSignDataBatchResult result) {
        return new SigningResult(result.signature, result.error);
    }

    private VerificationResult getVaultTransitVerifyBatchResult(VaultTransitVerifyDataBatchResult result) {
        if (Boolean.TRUE.equals(result.valid)) {
            return new VerificationResult(true, null);
        }
        String error = result.error == null ? "invalid signature" : result.error;
        return new VerificationResult(false, error);
    }

    private VaultTransitSignBatchInput getVaultTransitSignBatchInput(SigningRequest data) {
        Base64String input = Base64String.from((byte[])data.getInput().getValue());
        Base64String context = Base64String.from((byte[])data.getContext());
        return new VaultTransitSignBatchInput(input, context);
    }

    private VaultTransitVerifyBatchInput getVaultTransitVerifyBatchInput(VerificationRequest data) {
        Base64String input = Base64String.from((byte[])data.getInput().getValue());
        Base64String context = Base64String.from((byte[])data.getContext());
        String signature = data.getSignature();
        return VaultTransitVerifyBatchInput.fromSignature((Base64String)input, (String)signature, (Base64String)context);
    }

    private <K, V> Map<K, V> zip(List<K> keys, List<V> values) {
        return this.zip(keys, values, Function.identity());
    }

    private <K, V extends VaultTransitBatchResult, T> Map<K, T> zipRequestToValue(List<K> keys, List<V> values) {
        return this.zip(keys, values, VaultTransitBatchResult::getValue);
    }

    private <K, T, V> Map<K, V> zip(List<K> keys, List<T> values, Function<T, V> f) {
        if (keys.size() != values.size()) {
            throw new VaultException("unable to zip " + keys.size() + " keys with " + values.size() + " values");
        }
        IdentityHashMap map = new IdentityHashMap();
        IntStream.range(0, keys.size()).forEach(i -> map.put(keys.get(i), f.apply(values.get(i))));
        return map;
    }
}

