/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.util.JavaVersionUtil;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.client.CertificateHelper;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import org.jboss.logging.Logger;

public class OkHttpClientFactory {
    private static final Logger log = Logger.getLogger((String)OkHttpClientFactory.class.getName());

    public static OkHttpClient createHttpClient(VaultRuntimeConfig serverConfig, TlsConfig tlsConfig) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(serverConfig.connectTimeout).readTimeout(serverConfig.readTimeout);
        if (!JavaVersionUtil.isJava11OrHigher()) {
            builder.protocols(Collections.singletonList(Protocol.HTTP_1_1));
        }
        try {
            boolean trustAll;
            boolean bl = trustAll = serverConfig.tls.skipVerify.isPresent() ? serverConfig.tls.skipVerify.get() : tlsConfig.trustAll;
            if (trustAll) {
                OkHttpClientFactory.skipVerify(builder);
            } else if (serverConfig.tls.caCert.isPresent()) {
                OkHttpClientFactory.cacert(builder, serverConfig.tls.caCert.get());
            } else if (serverConfig.getAuthenticationType() == VaultAuthenticationType.KUBERNETES && serverConfig.tls.useKubernetesCaCert) {
                OkHttpClientFactory.cacert(builder, "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new VaultException(e);
        }
        return builder.build();
    }

    private static void cacert(OkHttpClient.Builder builder, String cacert) throws GeneralSecurityException, IOException {
        log.debug((Object)("create SSLSocketFactory with tls " + cacert));
        OkHttpClientFactory.sslSocketFactory(builder, CertificateHelper.createTrustManagers(cacert));
    }

    private static void skipVerify(OkHttpClient.Builder builder) throws GeneralSecurityException {
        log.debug((Object)"create SSLSocketFactory with tls.skip-verify");
        builder.hostnameVerifier((hostname, session) -> true);
        OkHttpClientFactory.sslSocketFactory(builder, new TrustManager[]{new TrustAllTrustManager()});
    }

    private static void sslSocketFactory(OkHttpClient.Builder builder, TrustManager[] trustManagers) throws GeneralSecurityException {
        SSLContext sslContext = CertificateHelper.createSslContext(trustManagers);
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustManagers[0]);
    }

    static class TrustAllTrustManager
    implements X509TrustManager {
        TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

