/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.vault.runtime.VaultManager;
import io.quarkus.vault.runtime.config.VaultCacheEntry;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class VaultConfigSource
implements ConfigSource {
    private static final Logger log = Logger.getLogger(VaultConfigSource.class);
    private AtomicReference<VaultCacheEntry<Map<String, String>>> cache = new AtomicReference<Object>(null);
    private VaultRuntimeConfig serverConfig;
    private int ordinal;

    public VaultConfigSource(int ordinal, VaultRuntimeConfig vaultRuntimeConfig) {
        this.ordinal = ordinal;
        this.serverConfig = vaultRuntimeConfig;
    }

    public String getName() {
        return "vault";
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public String getValue(String propertyName) {
        return this.serverConfig.url.isPresent() ? this.getSecretConfig().get(propertyName) : null;
    }

    private Map<String, String> getSecretConfig() {
        VaultCacheEntry<Map<String, String>> cacheEntry = this.cache.get();
        if (cacheEntry != null && cacheEntry.youngerThan(this.serverConfig.secretConfigCachePeriod)) {
            return cacheEntry.getValue();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            this.serverConfig.secretConfigKvPath.ifPresent(strings -> this.fetchSecrets((List<String>)strings, null, (Map<String, String>)properties));
            this.serverConfig.secretConfigKvPathPrefix.forEach((key, value) -> this.fetchSecrets(value.paths, (String)key, (Map<String, String>)properties));
            log.debug((Object)("loaded " + properties.size() + " properties from vault"));
        }
        catch (RuntimeException e) {
            return VaultCacheEntry.tryReturnLastKnownValue(e, cacheEntry);
        }
        this.cache.set(new VaultCacheEntry(properties));
        return properties;
    }

    private void fetchSecrets(List<String> paths, String prefix, Map<String, String> properties) {
        paths.forEach(path -> properties.putAll(this.fetchSecrets((String)path, prefix)));
    }

    private Map<String, String> fetchSecrets(String path, String prefix) {
        return this.prefixMap(VaultManager.getInstance().getVaultKvManager().readSecret(path), prefix);
    }

    private Map<String, String> prefixMap(Map<String, String> map, String prefix) {
        return prefix == null ? map : map.entrySet().stream().collect(Collectors.toMap(entry -> prefix + "." + (String)entry.getKey(), Map.Entry::getValue));
    }
}

