/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.vault.runtime.LogConfidentialityLevel;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationType;
import io.quarkus.vault.runtime.config.VaultTlsConfig;
import io.quarkus.vault.runtime.config.VaultTransitConfig;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="vault", phase=ConfigPhase.BOOTSTRAP)
public class VaultRuntimeConfig {
    public static final String NAME = "vault";
    public static final String DEFAULT_KUBERNETES_JWT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String DEFAULT_KV_SECRET_ENGINE_MOUNT_PATH = "secret";
    public static final String KV_SECRET_ENGINE_VERSION_V2 = "2";
    public static final String DEFAULT_RENEW_GRACE_PERIOD = "1H";
    public static final String DEFAULT_SECRET_CONFIG_CACHE_PERIOD = "10M";
    public static final String KUBERNETES_CACERT = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String DEFAULT_CONNECT_TIMEOUT = "5S";
    public static final String DEFAULT_READ_TIMEOUT = "1S";
    public static final String DEFAULT_TLS_USE_KUBERNETES_CACERT = "true";
    public static final String DEFAULT_KUBERNETES_AUTH_MOUNT_PATH = "auth/kubernetes";
    @ConfigItem
    public Optional<URL> url;
    @ConfigItem
    public VaultAuthenticationConfig authentication;
    @ConfigItem(defaultValue="1H")
    public Duration renewGracePeriod;
    @ConfigItem(defaultValue="10M")
    public Duration secretConfigCachePeriod;
    @ConfigItem
    public Optional<List<String>> secretConfigKvPath;
    @ConfigItem(name="secret-config-kv-path")
    public Map<String, KvPathConfig> secretConfigKvPathPrefix;
    @ConfigItem(defaultValue="medium")
    public LogConfidentialityLevel logConfidentialityLevel;
    @ConfigItem(defaultValue="2")
    public int kvSecretEngineVersion;
    @ConfigItem(defaultValue="secret")
    public String kvSecretEngineMountPath;
    @ConfigItem
    public VaultTlsConfig tls;
    @ConfigItem(defaultValue="5S")
    public Duration connectTimeout;
    @ConfigItem(defaultValue="1S")
    public Duration readTimeout;
    @ConfigItem
    public Map<String, CredentialsProviderConfig> credentialsProvider;
    @ConfigItem
    public VaultTransitConfig transit;

    public VaultAuthenticationType getAuthenticationType() {
        if (this.authentication.kubernetes.role.isPresent()) {
            return VaultAuthenticationType.KUBERNETES;
        }
        if (this.authentication.isUserpass()) {
            return VaultAuthenticationType.USERPASS;
        }
        if (this.authentication.isAppRole()) {
            return VaultAuthenticationType.APPROLE;
        }
        return null;
    }

    public String toString() {
        return "VaultRuntimeConfig{url=" + this.url + ", kubernetesAuthenticationMountPath=" + this.authentication.kubernetes.authMountPath + ", kubernetesAuthenticationRole=" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.kubernetes.role.orElse(""), LogConfidentialityLevel.MEDIUM) + ", kubernetesJwtTokenPath='" + this.authentication.kubernetes.jwtTokenPath + '\'' + ", userpassUsername='" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.userpass.username.orElse(""), LogConfidentialityLevel.MEDIUM) + '\'' + ", userpassPassword='" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.userpass.password.orElse(""), LogConfidentialityLevel.LOW) + '\'' + ", appRoleRoleId='" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.appRole.roleId.orElse(""), LogConfidentialityLevel.MEDIUM) + '\'' + ", appRoleSecretId='" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.appRole.secretId.orElse(""), LogConfidentialityLevel.LOW) + '\'' + ", appRoleSecretIdWrappingToken='" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.appRole.secretIdWrappingToken.orElse(""), LogConfidentialityLevel.LOW) + '\'' + ", clientToken=" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.clientToken.orElse(""), LogConfidentialityLevel.LOW) + ", clientTokenWrappingToken=" + this.logConfidentialityLevel.maskWithTolerance(this.authentication.clientTokenWrappingToken.orElse(""), LogConfidentialityLevel.LOW) + ", renewGracePeriod=" + this.renewGracePeriod + ", cachePeriod=" + this.secretConfigCachePeriod + ", logConfidentialityLevel=" + (Object)((Object)this.logConfidentialityLevel) + ", kvSecretEngineVersion=" + this.kvSecretEngineVersion + ", kvSecretEngineMountPath='" + this.kvSecretEngineMountPath + '\'' + ", tlsSkipVerify=" + this.tls.skipVerify + ", tlsCaCert=" + this.tls.caCert + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + '}';
    }

    @ConfigGroup
    public static class KvPathConfig {
        @ConfigItem(name="<<parent>>")
        List<String> paths;

        public KvPathConfig(List<String> paths) {
            this.paths = paths;
        }

        public KvPathConfig() {
            this.paths = Collections.emptyList();
        }

        public String toString() {
            return "SecretConfigKvPathConfig{paths=" + this.paths + '}';
        }
    }
}

