/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.runtime.LeaseBase;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.VaultDynamicDatabaseCredentials;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.client.backend.VaultInternalSystemBackend;
import io.quarkus.vault.runtime.client.dto.database.VaultDatabaseCredentials;
import io.quarkus.vault.runtime.client.dto.database.VaultDatabaseCredentialsData;
import io.quarkus.vault.runtime.client.dto.sys.VaultRenewLease;
import io.quarkus.vault.runtime.client.secretengine.VaultInternalDatabaseSecretEngine;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class VaultDbManager {
    private static final Logger log = Logger.getLogger((String)VaultDbManager.class.getName());
    ConcurrentHashMap<String, VaultDynamicDatabaseCredentials> credentialsCache = new ConcurrentHashMap();
    private VaultAuthManager vaultAuthManager;
    private VaultConfigHolder vaultConfigHolder;
    private VaultInternalSystemBackend vaultInternalSystemBackend;
    private VaultInternalDatabaseSecretEngine vaultInternalDatabaseSecretEngine;

    public VaultDbManager(VaultConfigHolder vaultConfigHolder, VaultAuthManager vaultAuthManager, VaultInternalSystemBackend vaultInternalSystemBackend, VaultInternalDatabaseSecretEngine vaultInternalDatabaseSecretEngine) {
        this.vaultConfigHolder = vaultConfigHolder;
        this.vaultAuthManager = vaultAuthManager;
        this.vaultInternalSystemBackend = vaultInternalSystemBackend;
        this.vaultInternalDatabaseSecretEngine = vaultInternalDatabaseSecretEngine;
    }

    private VaultBootstrapConfig getConfig() {
        return this.vaultConfigHolder.getVaultBootstrapConfig();
    }

    public Map<String, String> getDynamicDbCredentials(String databaseCredentialsRole) {
        String clientToken = this.vaultAuthManager.getClientToken();
        VaultDynamicDatabaseCredentials currentCredentials = this.credentialsCache.get(databaseCredentialsRole);
        VaultDynamicDatabaseCredentials credentials = this.getCredentials(currentCredentials, clientToken, databaseCredentialsRole);
        this.credentialsCache.put(databaseCredentialsRole, credentials);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("user", credentials.username);
        properties.put("password", credentials.password);
        return properties;
    }

    public VaultDynamicDatabaseCredentials getCredentials(VaultDynamicDatabaseCredentials currentCredentials, String clientToken, String databaseCredentialsRole) {
        VaultDynamicDatabaseCredentials credentials = currentCredentials;
        if (credentials != null) {
            credentials = this.validate(credentials, clientToken);
        }
        if (credentials != null && credentials.shouldExtend(this.getConfig().renewGracePeriod)) {
            credentials = this.extend(credentials, clientToken, databaseCredentialsRole);
        }
        if (credentials == null || credentials.isExpired() || credentials.expiresSoon(this.getConfig().renewGracePeriod)) {
            credentials = this.create(clientToken, databaseCredentialsRole);
        }
        return credentials;
    }

    private VaultDynamicDatabaseCredentials validate(VaultDynamicDatabaseCredentials credentials, String clientToken) {
        try {
            this.vaultInternalSystemBackend.lookupLease(clientToken, credentials.leaseId);
            return credentials;
        }
        catch (VaultClientException e) {
            if (e.getStatus() == 400) {
                log.debug((Object)("lease " + credentials.leaseId + " has become invalid"));
                return null;
            }
            throw e;
        }
    }

    private VaultDynamicDatabaseCredentials extend(VaultDynamicDatabaseCredentials currentCredentials, String clientToken, String databaseCredentialsRole) {
        VaultRenewLease vaultRenewLease = this.vaultInternalSystemBackend.renewLease(clientToken, currentCredentials.leaseId);
        LeaseBase lease = new LeaseBase(vaultRenewLease.leaseId, vaultRenewLease.renewable, vaultRenewLease.leaseDurationSecs);
        VaultDynamicDatabaseCredentials credentials = new VaultDynamicDatabaseCredentials(lease, currentCredentials.username, currentCredentials.password);
        this.sanityCheck(credentials, databaseCredentialsRole);
        log.debug((Object)("extended " + databaseCredentialsRole + " credentials with: " + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
        return credentials;
    }

    private VaultDynamicDatabaseCredentials create(String clientToken, String databaseCredentialsRole) {
        VaultDatabaseCredentials vaultDatabaseCredentials = this.vaultInternalDatabaseSecretEngine.generateCredentials(clientToken, databaseCredentialsRole);
        LeaseBase lease = new LeaseBase(vaultDatabaseCredentials.leaseId, vaultDatabaseCredentials.renewable, vaultDatabaseCredentials.leaseDurationSecs);
        VaultDynamicDatabaseCredentials credentials = new VaultDynamicDatabaseCredentials(lease, ((VaultDatabaseCredentialsData)vaultDatabaseCredentials.data).username, ((VaultDatabaseCredentialsData)vaultDatabaseCredentials.data).password);
        log.debug((Object)("generated " + databaseCredentialsRole + " credentials: " + credentials.getConfidentialInfo(this.getConfig().logConfidentialityLevel)));
        this.sanityCheck(credentials, databaseCredentialsRole);
        return credentials;
    }

    private void sanityCheck(VaultDynamicDatabaseCredentials credentials, String databaseCredentialsRole) {
        credentials.leaseDurationSanityCheck(databaseCredentialsRole, this.getConfig().renewGracePeriod);
    }
}

