/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultConfigHolder;
import io.quarkus.vault.runtime.client.MutinyVertxClientFactory;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.VaultClientException;
import io.quarkus.vault.runtime.config.VaultBootstrapConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.HttpMethod;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

@Singleton
public class VertxVaultClient
implements VaultClient {
    private static final Logger log = Logger.getLogger(VertxVaultClient.class);
    private static final List<String> ROOT_NAMESPACE_API = Arrays.asList("sys/init", "sys/license", "sys/leader", "sys/health", "sys/metrics", "sys/config/state", "sys/host-info", "sys/key-status", "sys/storage", "sys/storage/raft");
    private final Vertx vertx;
    private URL baseUrl;
    private final TlsConfig tlsConfig;
    private final VaultConfigHolder vaultConfigHolder;
    private WebClient webClient;
    ObjectMapper mapper = new ObjectMapper();

    public VertxVaultClient(VaultConfigHolder vaultConfigHolder, TlsConfig tlsConfig) {
        this.vaultConfigHolder = vaultConfigHolder;
        this.tlsConfig = tlsConfig;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.vertx = Vertx.vertx();
    }

    public void init() {
        VaultBootstrapConfig config = this.vaultConfigHolder.getVaultBootstrapConfig();
        this.webClient = MutinyVertxClientFactory.createHttpClient(this.vertx, config, this.tlsConfig);
        this.baseUrl = config.url.orElseThrow(() -> new VaultException("no vault url provided"));
    }

    @Override
    @PreDestroy
    public void close() {
        try {
            if (this.webClient != null) {
                this.webClient.close();
            }
        }
        finally {
            this.vertx.close();
        }
    }

    @Override
    public <T> T put(String path, String token, Object body, int expectedCode) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.PUT);
        return this.exec((HttpRequest<Buffer>)request, body, null, expectedCode);
    }

    @Override
    public <T> T list(String path, String token, Class<T> resultClass) {
        HttpRequest request = this.builder(path, token).rawMethod("LIST");
        return this.exec((HttpRequest<Buffer>)request, resultClass);
    }

    @Override
    public <T> T delete(String path, String token, int expectedCode) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.DELETE);
        return this.exec((HttpRequest<Buffer>)request, expectedCode);
    }

    @Override
    public <T> T post(String path, String token, Object body, Class<T> resultClass, int expectedCode) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.POST);
        return this.exec((HttpRequest<Buffer>)request, body, resultClass, expectedCode);
    }

    @Override
    public <T> T post(String path, String token, Object body, Class<T> resultClass) {
        return this.post(path, token, Collections.emptyMap(), body, resultClass);
    }

    @Override
    public <T> T post(String path, String token, Map<String, String> headers, Object body, Class<T> resultClass) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.POST);
        headers.forEach((arg_0, arg_1) -> ((HttpRequest)request).putHeader(arg_0, arg_1));
        return this.exec((HttpRequest<Buffer>)request, body, resultClass);
    }

    @Override
    public <T> T post(String path, String token, Object body, int expectedCode) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.POST);
        return this.exec((HttpRequest<Buffer>)request, body, null, expectedCode);
    }

    @Override
    public <T> T put(String path, String token, Object body, Class<T> resultClass) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.PUT);
        return this.exec((HttpRequest<Buffer>)request, body, resultClass);
    }

    @Override
    public <T> T put(String path, Object body, Class<T> resultClass) {
        HttpRequest request = this.builder(path).method(HttpMethod.PUT);
        return this.exec((HttpRequest<Buffer>)request, body, resultClass);
    }

    @Override
    public <T> T get(String path, String token, Class<T> resultClass) {
        HttpRequest request = this.builder(path, token).method(HttpMethod.GET);
        return this.exec((HttpRequest<Buffer>)request, resultClass);
    }

    @Override
    public <T> T get(String path, Map<String, String> queryParams, Class<T> resultClass) {
        HttpRequest request = this.builder(path, queryParams).method(HttpMethod.GET);
        return this.exec((HttpRequest<Buffer>)request, resultClass);
    }

    @Override
    public int head(String path) {
        HttpRequest request = this.builder(path).method(HttpMethod.HEAD);
        return this.exec((HttpRequest<Buffer>)request);
    }

    @Override
    public int head(String path, Map<String, String> queryParams) {
        HttpRequest request = this.builder(path, queryParams).method(HttpMethod.HEAD);
        return this.exec((HttpRequest<Buffer>)request);
    }

    private <T> T exec(HttpRequest<Buffer> request, Class<T> resultClass) {
        return this.exec(request, null, resultClass, 200);
    }

    private <T> T exec(HttpRequest<Buffer> request, int expectedCode) {
        return this.exec(request, null, null, expectedCode);
    }

    private <T> T exec(HttpRequest<Buffer> request, Object body, Class<T> resultClass) {
        return this.exec(request, body, resultClass, 200);
    }

    private <T> T exec(HttpRequest<Buffer> request, Object body, Class<T> resultClass, int expectedCode) {
        try {
            Buffer responseBuffer;
            Uni uni = body == null ? request.send() : request.sendBuffer(Buffer.buffer((String)this.requestBody(body)));
            HttpResponse response = (HttpResponse)uni.await().atMost(this.getRequestTimeout());
            if (response.statusCode() != expectedCode) {
                this.throwVaultException((HttpResponse<Buffer>)response);
            }
            if ((responseBuffer = (Buffer)response.body()) != null) {
                return (T)(resultClass == null ? null : this.mapper.readValue(responseBuffer.toString(), resultClass));
            }
            return null;
        }
        catch (JsonProcessingException e) {
            throw new VaultException(e);
        }
    }

    private Duration getRequestTimeout() {
        return this.vaultConfigHolder.getVaultBootstrapConfig().readTimeout;
    }

    private int exec(HttpRequest<Buffer> request) {
        return ((HttpResponse)request.send().await().atMost(this.getRequestTimeout())).statusCode();
    }

    private void throwVaultException(HttpResponse<Buffer> response) {
        String body = null;
        try {
            body = ((Buffer)response.body()).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new VaultClientException(response.statusCode(), body);
    }

    private HttpRequest<Buffer> builder(String path, String token) {
        Optional<String> namespace;
        HttpRequest<Buffer> request = this.builder(path);
        if (token != null) {
            request.putHeader("X-Vault-Token", token);
        }
        if ((namespace = this.vaultConfigHolder.getVaultBootstrapConfig().enterprise.namespace).isPresent() && !this.isRootNamespaceAPI(path)) {
            request.putHeader("X-Vault-Namespace", namespace.get());
        }
        return request;
    }

    private boolean isRootNamespaceAPI(String path) {
        return ROOT_NAMESPACE_API.stream().anyMatch(path::startsWith);
    }

    private HttpRequest<Buffer> builder(String path) {
        return this.webClient.getAbs(this.getUrl(path).toString());
    }

    private HttpRequest<Buffer> builder(String path, Map<String, String> queryParams) {
        HttpRequest<Buffer> request = this.builder(path);
        if (queryParams != null) {
            queryParams.forEach((arg_0, arg_1) -> request.addQueryParam(arg_0, arg_1));
        }
        return request;
    }

    private String requestBody(Object body) {
        try {
            return this.mapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new VaultException(e);
        }
    }

    private URL getUrl(String path) {
        try {
            return new URL(this.baseUrl, "v1/" + path);
        }
        catch (MalformedURLException e) {
            throw new VaultException(e);
        }
    }
}

