/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.client.backend;

import io.quarkus.vault.runtime.client.VaultInternalBase;
import io.quarkus.vault.runtime.client.dto.sys.VaultHealthResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultInitBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultInitResponse;
import io.quarkus.vault.runtime.client.dto.sys.VaultLeasesBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultLeasesLookup;
import io.quarkus.vault.runtime.client.dto.sys.VaultListPolicyResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultPolicyResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultRenewLease;
import io.quarkus.vault.runtime.client.dto.sys.VaultSealStatusResult;
import io.quarkus.vault.runtime.client.dto.sys.VaultUnwrapBody;
import io.quarkus.vault.runtime.client.dto.sys.VaultWrapResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class VaultInternalSystemBackend
extends VaultInternalBase {
    public int systemHealth(boolean isStandByOk, boolean isPerfStandByOk) {
        Map<String, String> queryParams = this.getHealthParams(isStandByOk, isPerfStandByOk);
        return this.vaultClient.head("sys/health", queryParams);
    }

    public VaultHealthResult systemHealthStatus(boolean isStandByOk, boolean isPerfStandByOk) {
        Map<String, String> queryParams = this.getHealthParams(isStandByOk, isPerfStandByOk);
        return this.vaultClient.get("sys/health", queryParams, VaultHealthResult.class);
    }

    public VaultSealStatusResult systemSealStatus() {
        return this.vaultClient.get("sys/seal-status", Collections.emptyMap(), VaultSealStatusResult.class);
    }

    public VaultInitResponse init(int secretShares, int secretThreshold) {
        VaultInitBody body = new VaultInitBody(secretShares, secretThreshold);
        return this.vaultClient.put("sys/init", body, VaultInitResponse.class);
    }

    public VaultWrapResult wrap(String token, long ttl, Object object) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Vault-Wrap-TTL", "" + ttl);
        return this.vaultClient.post("sys/wrapping/wrap", token, headers, object, VaultWrapResult.class);
    }

    public <T> T unwrap(String wrappingToken, Class<T> resultClass) {
        return this.vaultClient.post("sys/wrapping/unwrap", wrappingToken, (Object)VaultUnwrapBody.EMPTY, resultClass);
    }

    public VaultPolicyResult getPolicy(String token, String name) {
        return this.vaultClient.get("sys/policy/" + name, token, VaultPolicyResult.class);
    }

    public void createUpdatePolicy(String token, String name, VaultPolicyBody body) {
        this.vaultClient.put("sys/policy/" + name, token, (Object)body, 204);
    }

    public VaultListPolicyResult listPolicies(String token) {
        return this.vaultClient.get("sys/policy", token, VaultListPolicyResult.class);
    }

    public void deletePolicy(String token, String name) {
        this.vaultClient.delete("sys/policy/" + name, token, 204);
    }

    public VaultLeasesLookup lookupLease(String token, String leaseId) {
        VaultLeasesBody body = new VaultLeasesBody(leaseId);
        return this.vaultClient.put("sys/leases/lookup", token, (Object)body, VaultLeasesLookup.class);
    }

    public VaultRenewLease renewLease(String token, String leaseId) {
        VaultLeasesBody body = new VaultLeasesBody(leaseId);
        return this.vaultClient.put("sys/leases/renew", token, (Object)body, VaultRenewLease.class);
    }

    private Map<String, String> getHealthParams(boolean isStandByOk, boolean isPerfStandByOk) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (isStandByOk) {
            queryParams.put("standbyok", "true");
        }
        if (isPerfStandByOk) {
            queryParams.put("perfstandbyok", "true");
        }
        return queryParams;
    }
}

