/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.credentials.CredentialsProvider;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.VaultDbManager;
import io.quarkus.vault.runtime.VaultKvManager;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.util.HashMap;
import java.util.Map;

public class VaultCredentialsProvider
implements CredentialsProvider {
    private VaultKvManager vaultKvManager;
    private VaultDbManager vaultDbManager;
    private VaultRuntimeConfig serverConfig;

    public VaultCredentialsProvider(VaultRuntimeConfig serverConfig, VaultKvManager vaultKvManager, VaultDbManager vaultDbManager) {
        this.serverConfig = serverConfig;
        this.vaultKvManager = vaultKvManager;
        this.vaultDbManager = vaultDbManager;
    }

    public Map<String, String> getCredentials(String credentialsProviderName) {
        CredentialsProviderConfig config = this.serverConfig.credentialsProvider.get(credentialsProviderName);
        if (config == null) {
            throw new VaultException("unknown credentials provider with name " + credentialsProviderName);
        }
        if (config.databaseCredentialsRole.isPresent()) {
            return this.vaultDbManager.getDynamicDbCredentials(config.databaseCredentialsRole.get());
        }
        if (config.kvPath.isPresent()) {
            String password = this.vaultKvManager.readSecret(config.kvPath.get()).get(config.kvKey);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("password", password);
            return result;
        }
        throw new VaultException("one of database-credentials-role or kv-path is required on credentials provider " + credentialsProviderName);
    }
}

