/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime;

import io.quarkus.vault.VaultKVSecretEngine;
import io.quarkus.vault.runtime.VaultAuthManager;
import io.quarkus.vault.runtime.client.VaultClient;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV1;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2Data;
import io.quarkus.vault.runtime.client.dto.kv.VaultKvSecretV2WriteBody;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import java.util.Map;

public class VaultKvManager
implements VaultKVSecretEngine {
    private VaultAuthManager vaultAuthManager;
    private VaultClient vaultClient;
    private VaultRuntimeConfig serverConfig;

    public VaultKvManager(VaultAuthManager vaultAuthManager, VaultClient vaultClient, VaultRuntimeConfig serverConfig) {
        this.vaultAuthManager = vaultAuthManager;
        this.vaultClient = vaultClient;
        this.serverConfig = serverConfig;
    }

    @Override
    public Map<String, String> readSecret(String path) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.serverConfig.kvSecretEngineMountPath;
        if (this.serverConfig.kvSecretEngineVersion == 1) {
            VaultKvSecretV1 secretV1 = this.vaultClient.getSecretV1(clientToken, mount, path);
            return (Map)secretV1.data;
        }
        VaultKvSecretV2 secretV2 = this.vaultClient.getSecretV2(clientToken, mount, path);
        return ((VaultKvSecretV2Data)secretV2.data).data;
    }

    @Override
    public void writeSecret(String path, Map<String, String> secret) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.serverConfig.kvSecretEngineMountPath;
        if (this.serverConfig.kvSecretEngineVersion == 1) {
            this.vaultClient.writeSecretV1(clientToken, mount, path, secret);
        } else {
            VaultKvSecretV2WriteBody body = new VaultKvSecretV2WriteBody();
            body.data = secret;
            this.vaultClient.writeSecretV2(clientToken, mount, path, body);
        }
    }

    @Override
    public void deleteSecret(String path) {
        String clientToken = this.vaultAuthManager.getClientToken();
        String mount = this.serverConfig.kvSecretEngineMountPath;
        if (this.serverConfig.kvSecretEngineVersion == 1) {
            this.vaultClient.deleteSecretV1(clientToken, mount, path);
        } else {
            this.vaultClient.deleteSecretV2(clientToken, mount, path);
        }
    }
}

