/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vault.runtime.config;

import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.vault.VaultException;
import io.quarkus.vault.runtime.LogConfidentialityLevel;
import io.quarkus.vault.runtime.VaultManager;
import io.quarkus.vault.runtime.config.CredentialsProviderConfig;
import io.quarkus.vault.runtime.config.HealthConfig;
import io.quarkus.vault.runtime.config.TransitKeyConfig;
import io.quarkus.vault.runtime.config.VaultAppRoleAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultBuildTimeConfig;
import io.quarkus.vault.runtime.config.VaultCacheEntry;
import io.quarkus.vault.runtime.config.VaultKubernetesAuthenticationConfig;
import io.quarkus.vault.runtime.config.VaultMapConfigParser;
import io.quarkus.vault.runtime.config.VaultRuntimeConfig;
import io.quarkus.vault.runtime.config.VaultTlsConfig;
import io.quarkus.vault.runtime.config.VaultTransitConfig;
import io.quarkus.vault.runtime.config.VaultUserpassAuthenticationConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public class VaultConfigSource
implements ConfigSource {
    private static final Logger log = Logger.getLogger(VaultConfigSource.class);
    private static final String PROPERTY_PREFIX = "quarkus.vault.";
    public static final Pattern CREDENTIALS_PATTERN = Pattern.compile("^quarkus\\.vault\\.credentials-provider\\.([^.]+)\\.");
    public static final Pattern TRANSIT_KEY_PATTERN = Pattern.compile("^quarkus\\.vault\\.transit.key\\.([^.]+)\\.");
    public static final Pattern SECRET_CONFIG_KV_PATH_PATTERN = Pattern.compile("^quarkus\\.vault\\.secret-config-kv-path\\.([^.]+)$");
    private AtomicReference<VaultCacheEntry<Map<String, String>>> cache = new AtomicReference<Object>(null);
    private AtomicReference<VaultRuntimeConfig> serverConfig = new AtomicReference<Object>(null);
    private AtomicReference<VaultBuildTimeConfig> buildServerConfig = new AtomicReference<Object>(null);
    private AtomicBoolean init = new AtomicBoolean(false);
    private int ordinal;
    private DurationConverter durationConverter = new DurationConverter();

    public VaultConfigSource(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getName() {
        return "vault";
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public String getValue(String propertyName) {
        VaultRuntimeConfig serverConfig = this.getRuntimeConfig();
        if (!serverConfig.url.isPresent()) {
            return null;
        }
        return this.getSecretConfig().get(propertyName);
    }

    private Map<String, String> getSecretConfig() {
        VaultRuntimeConfig serverConfig = this.getRuntimeConfig();
        VaultCacheEntry<Map<String, String>> cacheEntry = this.cache.get();
        if (cacheEntry != null && cacheEntry.youngerThan(serverConfig.secretConfigCachePeriod)) {
            return cacheEntry.getValue();
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            if (serverConfig.secretConfigKvPath.isPresent()) {
                this.fetchSecrets(serverConfig.secretConfigKvPath.get(), null, properties);
            }
            serverConfig.secretConfigKvPrefixPath.entrySet().forEach(entry -> this.fetchSecrets((List)entry.getValue(), (String)entry.getKey(), properties));
            log.debug((Object)("loaded " + properties.size() + " properties from vault"));
        }
        catch (RuntimeException e) {
            return VaultCacheEntry.tryReturnLastKnownValue(e, cacheEntry);
        }
        this.cache.set(new VaultCacheEntry<HashMap<String, String>>(properties));
        return properties;
    }

    private void fetchSecrets(List<String> paths, String prefix, Map<String, String> properties) {
        paths.forEach(path -> properties.putAll(this.fetchSecrets((String)path, prefix)));
    }

    private Map<String, String> fetchSecrets(String path, String prefix) {
        VaultManager instance = this.getVaultManager();
        return instance == null ? Collections.emptyMap() : this.prefixMap(instance.getVaultKvManager().readSecret(path), prefix);
    }

    private Map<String, String> prefixMap(Map<String, String> map, String prefix) {
        return prefix == null ? map : map.entrySet().stream().collect(Collectors.toMap(entry -> prefix + "." + (String)entry.getKey(), Map.Entry::getValue));
    }

    private VaultManager getVaultManager() {
        VaultBuildTimeConfig buildTimeConfig = this.getBuildtimeConfig();
        VaultRuntimeConfig serverConfig = this.getRuntimeConfig();
        if (this.init.compareAndSet(false, true)) {
            VaultManager.init(buildTimeConfig, serverConfig);
        }
        return VaultManager.getInstance();
    }

    private VaultRuntimeConfig getRuntimeConfig() {
        return this.getConfig(this.serverConfig, () -> this.loadRuntimeConfig(), "runtime");
    }

    private VaultBuildTimeConfig getBuildtimeConfig() {
        return this.getConfig(this.buildServerConfig, () -> this.loadBuildtimeConfig(), "buildtime");
    }

    private <T> T getConfig(AtomicReference<T> ref, Supplier<T> supplier, String name) {
        T config = ref.get();
        if (config != null) {
            return config;
        }
        config = supplier.get();
        log.debug((Object)("loaded vault " + name + " config " + config));
        ref.set(config);
        return ref.get();
    }

    private VaultBuildTimeConfig loadBuildtimeConfig() {
        VaultBuildTimeConfig vaultBuildTimeConfig = new VaultBuildTimeConfig();
        vaultBuildTimeConfig.health = new HealthConfig();
        vaultBuildTimeConfig.health.enabled = Boolean.parseBoolean(this.getVaultProperty("health.enabled", "false"));
        vaultBuildTimeConfig.health.standByOk = Boolean.parseBoolean(this.getVaultProperty("health.stand-by-ok", "false"));
        vaultBuildTimeConfig.health.performanceStandByOk = Boolean.parseBoolean(this.getVaultProperty("health.performance-stand-by-ok", "false"));
        return vaultBuildTimeConfig;
    }

    private VaultRuntimeConfig loadRuntimeConfig() {
        VaultRuntimeConfig serverConfig = new VaultRuntimeConfig();
        serverConfig.tls = new VaultTlsConfig();
        serverConfig.transit = new VaultTransitConfig();
        serverConfig.authentication = new VaultAuthenticationConfig();
        serverConfig.authentication.userpass = new VaultUserpassAuthenticationConfig();
        serverConfig.authentication.appRole = new VaultAppRoleAuthenticationConfig();
        serverConfig.authentication.kubernetes = new VaultKubernetesAuthenticationConfig();
        serverConfig.url = this.newURL(this.getOptionalVaultProperty("url"));
        serverConfig.authentication.clientToken = this.getOptionalVaultProperty("authentication.client-token");
        serverConfig.authentication.clientTokenWrappingToken = this.getOptionalVaultProperty("authentication.client-token-wrapping-token");
        serverConfig.authentication.kubernetes.role = this.getOptionalVaultProperty("authentication.kubernetes.role");
        serverConfig.authentication.kubernetes.jwtTokenPath = this.getVaultProperty("authentication.kubernetes.jwt-token-path", "/var/run/secrets/kubernetes.io/serviceaccount/token");
        serverConfig.authentication.kubernetes.authMountPath = this.getVaultProperty("authentication.kubernetes.auth-mount-path", "auth/kubernetes");
        serverConfig.authentication.userpass.username = this.getOptionalVaultProperty("authentication.userpass.username");
        serverConfig.authentication.userpass.password = this.getOptionalVaultProperty("authentication.userpass.password");
        serverConfig.authentication.userpass.passwordWrappingToken = this.getOptionalVaultProperty("authentication.userpass.password-wrapping-token");
        serverConfig.authentication.appRole.roleId = this.getOptionalVaultProperty("authentication.app-role.role-id");
        serverConfig.authentication.appRole.secretId = this.getOptionalVaultProperty("authentication.app-role.secret-id");
        serverConfig.authentication.appRole.secretIdWrappingToken = this.getOptionalVaultProperty("authentication.app-role.secret-id-wrapping-token");
        serverConfig.renewGracePeriod = this.getVaultDuration("renew-grace-period", "1H");
        serverConfig.secretConfigCachePeriod = this.getVaultDuration("secret-config-cache-period", "10M");
        serverConfig.logConfidentialityLevel = LogConfidentialityLevel.valueOf(this.getVaultProperty("log-confidentiality-level", LogConfidentialityLevel.MEDIUM.name()).toUpperCase());
        serverConfig.kvSecretEngineVersion = Integer.parseInt(this.getVaultProperty("kv-secret-engine-version", "2"));
        serverConfig.kvSecretEngineMountPath = this.getVaultProperty("kv-secret-engine-mount-path", "secret");
        serverConfig.secretConfigKvPath = this.getOptionalListProperty("secret-config-kv-path");
        serverConfig.tls.skipVerify = Boolean.parseBoolean(this.getVaultProperty("tls.skip-verify", "false"));
        serverConfig.tls.useKubernetesCaCert = Boolean.parseBoolean(this.getVaultProperty("tls.use-kubernetes-ca-cert", "true"));
        serverConfig.tls.caCert = this.getOptionalVaultProperty("tls.ca-cert");
        serverConfig.connectTimeout = this.getVaultDuration("connect-timeout", "5S");
        serverConfig.readTimeout = this.getVaultDuration("read-timeout", "1S");
        serverConfig.credentialsProvider = this.createCredentialProviderConfigParser().getConfig();
        serverConfig.transit.key = this.createTransitKeyConfigParser().getConfig();
        serverConfig.secretConfigKvPrefixPath = this.getSecretConfigKvPrefixPaths();
        return serverConfig;
    }

    private VaultMapConfigParser<CredentialsProviderConfig> createCredentialProviderConfigParser() {
        return new VaultMapConfigParser<CredentialsProviderConfig>(CREDENTIALS_PATTERN, this::getCredentialsProviderConfig, this.getConfigSourceStream());
    }

    private CredentialsProviderConfig getCredentialsProviderConfig(String name) {
        String prefix = "credentials-provider." + name;
        CredentialsProviderConfig config = new CredentialsProviderConfig();
        config.databaseCredentialsRole = this.getOptionalVaultProperty(prefix + ".database-credentials-role");
        config.kvPath = this.getOptionalVaultProperty(prefix + ".kv-path");
        config.kvKey = this.getVaultProperty(prefix + ".kv-key", "password");
        return config;
    }

    private VaultMapConfigParser<TransitKeyConfig> createTransitKeyConfigParser() {
        return new VaultMapConfigParser<TransitKeyConfig>(TRANSIT_KEY_PATTERN, this::getTransitKeyConfig, this.getConfigSourceStream());
    }

    private TransitKeyConfig getTransitKeyConfig(String name) {
        String prefix = "transit.key." + name;
        TransitKeyConfig config = new TransitKeyConfig();
        config.name = this.getOptionalVaultProperty(prefix + ".name");
        config.hashAlgorithm = this.getOptionalVaultProperty(prefix + ".hash-algorithm");
        config.signatureAlgorithm = this.getOptionalVaultProperty(prefix + ".signature-algorithm");
        config.type = this.getOptionalVaultProperty(prefix + ".type");
        config.convergentEncryption = this.getOptionalVaultProperty(prefix + ".convergent-encryption");
        Optional<String> prehashed = this.getOptionalVaultProperty(prefix + ".prehashed");
        config.prehashed = Optional.ofNullable(prehashed.isPresent() ? Boolean.valueOf(Boolean.parseBoolean(prehashed.get())) : null);
        return config;
    }

    private Optional<List<String>> getOptionalListProperty(String name) {
        Optional<String> optionalVaultProperty = this.getOptionalVaultProperty(name);
        if (!optionalVaultProperty.isPresent()) {
            return Optional.empty();
        }
        String[] split = optionalVaultProperty.get().split(",");
        return Optional.of(Arrays.stream(split).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
    }

    private Optional<URL> newURL(Optional<String> url) {
        try {
            return Optional.ofNullable(url.isPresent() ? new URL(url.get()) : null);
        }
        catch (MalformedURLException e) {
            throw new VaultException(e);
        }
    }

    private Optional<String> getOptionalVaultProperty(String key) {
        return Optional.ofNullable(this.getVaultProperty(key, null));
    }

    private Duration getVaultDuration(String key, String defaultValue) {
        return this.durationConverter.convert(this.getVaultProperty(key, defaultValue));
    }

    private String getVaultProperty(String key, String defaultValue) {
        String propertyName = PROPERTY_PREFIX + key;
        return this.getConfigSourceStream().map(configSource -> configSource.getValue(propertyName)).filter(value -> value != null && value.length() != 0).map(String::trim).findFirst().orElse(defaultValue);
    }

    private Map<String, List<String>> getSecretConfigKvPrefixPaths() {
        return this.getConfigSourceStream().flatMap(configSource -> configSource.getPropertyNames().stream()).map(this::getSecretConfigKvPrefixPathName).filter(Objects::nonNull).distinct().map(this::createNameSecretConfigKvPrefixPathPair).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private Stream<ConfigSource> getConfigSourceStream() {
        Config config = ConfigProviderResolver.instance().getConfig();
        return StreamSupport.stream(config.getConfigSources().spliterator(), false).filter(this::retain);
    }

    private boolean retain(ConfigSource configSource) {
        String other;
        try {
            other = configSource.getName();
        }
        catch (NullPointerException e) {
            other = null;
        }
        return !this.getName().equals(other);
    }

    private AbstractMap.SimpleEntry<String, List<String>> createNameSecretConfigKvPrefixPathPair(String name) {
        return new AbstractMap.SimpleEntry<String, List<String>>(name, this.getSecretConfigKvPrefixPath(name));
    }

    private String getSecretConfigKvPrefixPathName(String propertyName) {
        Matcher matcher = SECRET_CONFIG_KV_PATH_PATTERN.matcher(propertyName);
        return matcher.find() ? matcher.group(1) : null;
    }

    private List<String> getSecretConfigKvPrefixPath(String prefixName) {
        return this.getOptionalListProperty("secret-config-kv-path." + prefixName).get();
    }
}

