/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.quarkus.vertx.core.runtime.config.ClusterConfiguration;
import io.quarkus.vertx.core.runtime.config.EventBusConfiguration;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class VertxOptionsBuilder {
    static VertxOptions buildVertxOptions(VertxConfiguration conf) {
        VertxOptions options = new VertxOptions();
        VertxOptionsBuilder.buildEventBusOptions(conf, options);
        VertxOptionsBuilder.buildClusterOptions(conf, options);
        VertxOptionsBuilder.buildFileSystemOptions(conf, options);
        options.setWorkerPoolSize(conf.workerPoolSize);
        options.setInternalBlockingPoolSize(conf.internalBlockingPoolSize);
        options.setBlockedThreadCheckInterval(conf.warningExceptionTime.toMillis());
        options.setWarningExceptionTime(conf.warningExceptionTime.toNanos());
        conf.maxEventLoopExecuteTime.ifPresent(d -> options.setMaxEventLoopExecuteTime(d.toMillis()));
        conf.maxWorkerExecuteTime.ifPresent(d -> options.setMaxWorkerExecuteTime(d.toMillis()));
        conf.eventLoopsPoolSize.ifPresent(arg_0 -> ((VertxOptions)options).setEventLoopPoolSize(arg_0));
        return options;
    }

    private static void buildFileSystemOptions(VertxConfiguration conf, VertxOptions options) {
        String fileCacheDir = System.getProperty("vertx.cacheDirBase", System.getProperty("java.io.tmpdir", ".") + File.separator + "quarkus-vertx-cache");
        options.setFileSystemOptions(new FileSystemOptions().setFileCacheDir(fileCacheDir).setFileCachingEnabled(conf.caching).setClassPathResolvingEnabled(conf.classpathResolving));
    }

    private static void buildClusterOptions(VertxConfiguration conf, VertxOptions options) {
        ClusterConfiguration cluster = conf.cluster;
        EventBusOptions eb = options.getEventBusOptions();
        eb.setClustered(cluster.clustered);
        eb.setClusterPingReplyInterval(cluster.pingReplyInterval.toMillis());
        eb.setClusterPingInterval(cluster.pingInterval.toMillis());
        if (cluster.host != null) {
            eb.setHost(cluster.host);
        }
        cluster.port.ifPresent(arg_0 -> ((EventBusOptions)eb).setPort(arg_0));
        cluster.publicHost.ifPresent(arg_0 -> ((EventBusOptions)eb).setClusterPublicHost(arg_0));
        cluster.publicPort.ifPresent(arg_0 -> ((EventBusOptions)eb).setClusterPublicPort(arg_0));
    }

    private static void buildEventBusOptions(VertxConfiguration conf, VertxOptions options) {
        JksOptions o;
        EventBusConfiguration eb = conf.eventbus;
        EventBusOptions opts = new EventBusOptions();
        opts.setAcceptBacklog(eb.acceptBacklog.orElse(-1));
        opts.setClientAuth(ClientAuth.valueOf((String)eb.clientAuth.toUpperCase()));
        opts.setConnectTimeout((int)Math.min(Integer.MAX_VALUE, eb.connectTimeout.toMillis()));
        opts.setIdleTimeout(eb.idleTimeout.map(d -> Math.max(1, (int)Math.min(Integer.MAX_VALUE, d.getSeconds()))).orElse(0).intValue());
        opts.setSendBufferSize(eb.sendBufferSize.orElse(-1));
        opts.setSoLinger(eb.soLinger.orElse(-1));
        opts.setSsl(eb.ssl);
        opts.setReceiveBufferSize(eb.receiveBufferSize.orElse(-1));
        opts.setReconnectAttempts(eb.reconnectAttempts);
        opts.setReconnectInterval(eb.reconnectInterval.toMillis());
        opts.setReuseAddress(eb.reuseAddress);
        opts.setReusePort(eb.reusePort);
        opts.setTrafficClass(eb.trafficClass.orElse(-1));
        opts.setTcpKeepAlive(eb.tcpKeepAlive);
        opts.setTcpNoDelay(eb.tcpNoDelay);
        opts.setTrustAll(eb.trustAll);
        if (eb.keyCertificatePem != null) {
            ArrayList certs = new ArrayList();
            ArrayList keys = new ArrayList();
            eb.keyCertificatePem.certs.ifPresent(s -> certs.addAll(Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).collect(Collectors.toList())));
            eb.keyCertificatePem.keys.ifPresent(s -> keys.addAll(Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).collect(Collectors.toList())));
            PemKeyCertOptions o2 = new PemKeyCertOptions().setCertPaths(certs).setKeyPaths(keys);
            opts.setPemKeyCertOptions(o2);
        }
        if (eb.keyCertificateJks != null) {
            o = new JksOptions();
            eb.keyCertificateJks.path.ifPresent(arg_0 -> ((JksOptions)o).setPath(arg_0));
            eb.keyCertificateJks.password.ifPresent(arg_0 -> ((JksOptions)o).setPassword(arg_0));
            opts.setKeyStoreOptions(o);
        }
        if (eb.keyCertificatePfx != null) {
            o = new PfxOptions();
            eb.keyCertificatePfx.path.ifPresent(arg_0 -> ((PfxOptions)o).setPath(arg_0));
            eb.keyCertificatePfx.password.ifPresent(arg_0 -> ((PfxOptions)o).setPassword(arg_0));
            opts.setPfxKeyCertOptions((PfxOptions)o);
        }
        if (eb.trustCertificatePem != null) {
            eb.trustCertificatePem.certs.ifPresent(s -> {
                PemTrustOptions o = new PemTrustOptions();
                Pattern.compile(",").splitAsStream((CharSequence)s).map(String::trim).forEach(arg_0 -> ((PemTrustOptions)o).addCertPath(arg_0));
                opts.setPemTrustOptions(o);
            });
        }
        if (eb.trustCertificateJks != null) {
            o = new JksOptions();
            eb.trustCertificateJks.path.ifPresent(arg_0 -> ((JksOptions)o).setPath(arg_0));
            eb.trustCertificateJks.password.ifPresent(arg_0 -> ((JksOptions)o).setPassword(arg_0));
            opts.setTrustStoreOptions(o);
        }
        if (eb.trustCertificatePfx != null) {
            o = new PfxOptions();
            eb.trustCertificatePfx.path.ifPresent(arg_0 -> ((PfxOptions)o).setPath(arg_0));
            eb.trustCertificatePfx.password.ifPresent(arg_0 -> ((PfxOptions)o).setPassword(arg_0));
            opts.setPfxTrustOptions((PfxOptions)o);
        }
        options.setEventBusOptions(opts);
    }
}

