/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.core.runtime;

import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.quarkus.runtime.IOThreadDetector;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.core.runtime.SSLConfigHelper;
import io.quarkus.vertx.core.runtime.config.AddressResolverConfiguration;
import io.quarkus.vertx.core.runtime.config.ClusterConfiguration;
import io.quarkus.vertx.core.runtime.config.EventBusConfiguration;
import io.quarkus.vertx.core.runtime.config.VertxConfiguration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.file.FileSystemOptions;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.impl.VertxImpl;
import io.vertx.core.net.TCPSSLOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.cpu.ProcessorInfo;

@Recorder
public class VertxCoreRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)VertxCoreRecorder.class.getName());
    public static final String VERTX_CACHE = "vertx-cache";
    static volatile VertxSupplier vertx;
    static volatile int blockingThreadPoolSize;
    private static volatile String webDeploymentId;

    public Supplier<Vertx> configureVertx(VertxConfiguration config, LaunchMode launchMode, ShutdownContext shutdown, List<Consumer<VertxOptions>> customizers) {
        if (launchMode != LaunchMode.DEVELOPMENT) {
            vertx = new VertxSupplier(config, customizers, shutdown);
            shutdown.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    VertxCoreRecorder.this.destroy();
                }
            });
        } else {
            if (vertx == null) {
                vertx = new VertxSupplier(config, customizers, shutdown);
            } else if (VertxCoreRecorder.vertx.v != null) {
                this.tryCleanTccl(VertxCoreRecorder.vertx.v);
            }
            shutdown.addLastShutdownTask(new Runnable(){

                @Override
                public void run() {
                    ArrayList<CountDownLatch> latches = new ArrayList<CountDownLatch>();
                    if (VertxCoreRecorder.vertx.v != null) {
                        HashSet ids = new HashSet(VertxCoreRecorder.vertx.v.deploymentIDs());
                        for (String id : ids) {
                            if (id.equals(webDeploymentId)) continue;
                            final CountDownLatch latch = new CountDownLatch(1);
                            latches.add(latch);
                            VertxCoreRecorder.vertx.v.undeploy(id, (Handler)new Handler<AsyncResult<Void>>(){

                                public void handle(AsyncResult<Void> event) {
                                    latch.countDown();
                                }
                            });
                        }
                        for (CountDownLatch latch : latches) {
                            try {
                                latch.await();
                            }
                            catch (InterruptedException e) {
                                LOGGER.error((Object)"Failed waiting for verticle undeploy", (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        return vertx;
    }

    private void tryCleanTccl(Vertx devModeVertx) {
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < blockingThreadPoolSize; ++i) {
            devModeVertx.executeBlocking((Handler)new Handler<Promise<Object>>(){

                public void handle(Promise<Object> event) {
                    Thread.currentThread().setContextClassLoader(cl);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }, null);
        }
        EventLoopGroup group = ((VertxImpl)devModeVertx).getEventLoopGroup();
        for (EventExecutor i : group) {
            i.execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setContextClassLoader(cl);
                }
            });
        }
    }

    public IOThreadDetector detector() {
        return new IOThreadDetector(){

            public boolean isInIOThread() {
                return Context.isOnEventLoopThread();
            }
        };
    }

    static void shutdownDevMode() {
        if (vertx != null) {
            final CountDownLatch latch = new CountDownLatch(1);
            vertx.get().close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> event) {
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static Supplier<Vertx> getVertx() {
        return vertx;
    }

    public static Vertx initialize(VertxConfiguration conf, VertxOptionsCustomizer customizer, ShutdownContext shutdown) {
        Vertx vertx;
        VertxOptions options = new VertxOptions();
        if (conf != null) {
            VertxCoreRecorder.convertToVertxOptions(conf, options, true, shutdown);
        }
        if (customizer != null) {
            customizer.customize(options);
        }
        if (conf != null && conf.cluster != null && conf.cluster.clustered) {
            final CompletableFuture latch = new CompletableFuture();
            Vertx.clusteredVertx((VertxOptions)options, (Handler)new Handler<AsyncResult<Vertx>>(){

                public void handle(AsyncResult<Vertx> ar) {
                    if (ar.failed()) {
                        latch.completeExceptionally(ar.cause());
                    } else {
                        latch.complete((Vertx)ar.result());
                    }
                }
            });
            vertx = (Vertx)latch.join();
        } else {
            vertx = Vertx.vertx((VertxOptions)options);
        }
        vertx.exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable error) {
                LOGGER.error((Object)"Uncaught exception received by Vert.x", error);
            }
        });
        return VertxCoreRecorder.logVertxInitialization(vertx);
    }

    private static Vertx logVertxInitialization(Vertx vertx) {
        LOGGER.debugf("Vertx has Native Transport Enabled: %s", (Object)vertx.isNativeTransportEnabled());
        return vertx;
    }

    private static VertxOptions convertToVertxOptions(VertxConfiguration conf, VertxOptions options, boolean allowClustering, ShutdownContext shutdown) {
        String fileCacheDir;
        if (!conf.useAsyncDNS) {
            System.setProperty("vertx.disableDnsResolver", "true");
        }
        VertxCoreRecorder.setAddressResolverOptions(conf, options);
        if (allowClustering) {
            VertxCoreRecorder.setEventBusOptions(conf, options);
            VertxCoreRecorder.initializeClusterOptions(conf, options);
        }
        if ((fileCacheDir = System.getProperty("vertx.cacheDirBase")) == null) {
            File tmp = new File(System.getProperty("java.io.tmpdir", ".") + File.separator + VERTX_CACHE);
            if (!tmp.isDirectory()) {
                if (!tmp.mkdirs()) {
                    LOGGER.warnf("Unable to create Vert.x cache directory : %s", (Object)tmp.getAbsolutePath());
                }
                if (!tmp.setReadable(true, false) || !tmp.setWritable(true, false)) {
                    LOGGER.warnf("Unable to make the Vert.x cache directory (%s) world readable and writable", (Object)tmp.getAbsolutePath());
                }
            }
            final File cache = VertxCoreRecorder.getRandomDirectory(tmp);
            LOGGER.debugf("Vert.x Cache configured to: %s", (Object)cache.getAbsolutePath());
            fileCacheDir = cache.getAbsolutePath();
            if (shutdown != null) {
                shutdown.addLastShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        VertxCoreRecorder.deleteDirectory(cache);
                    }
                });
            }
        }
        options.setFileSystemOptions(new FileSystemOptions().setFileCachingEnabled(conf.caching).setFileCacheDir(fileCacheDir).setClassPathResolvingEnabled(conf.classpathResolving));
        options.setWorkerPoolSize(conf.workerPoolSize);
        options.setInternalBlockingPoolSize(conf.internalBlockingPoolSize);
        blockingThreadPoolSize = conf.internalBlockingPoolSize;
        options.setBlockedThreadCheckInterval(conf.warningExceptionTime.toMillis());
        if (conf.eventLoopsPoolSize.isPresent()) {
            options.setEventLoopPoolSize(conf.eventLoopsPoolSize.getAsInt());
        } else {
            options.setEventLoopPoolSize(VertxCoreRecorder.calculateDefaultIOThreads());
        }
        options.setMaxEventLoopExecuteTime(conf.maxEventLoopExecuteTime.toMillis());
        options.setMaxEventLoopExecuteTimeUnit(TimeUnit.MILLISECONDS);
        options.setMaxWorkerExecuteTime(conf.maxWorkerExecuteTime.toMillis());
        options.setMaxWorkerExecuteTimeUnit(TimeUnit.MILLISECONDS);
        options.setWarningExceptionTime(conf.warningExceptionTime.toNanos());
        options.setPreferNativeTransport(conf.preferNativeTransport);
        return options;
    }

    private static File getRandomDirectory(File tmp) {
        long random = Math.abs(UUID.randomUUID().getMostSignificantBits());
        File cache = new File(tmp, Long.toString(random));
        if (cache.isDirectory()) {
            return VertxCoreRecorder.getRandomDirectory(tmp);
        }
        return cache;
    }

    private static int calculateDefaultIOThreads() {
        int recommended = ProcessorInfo.availableProcessors() * 2;
        long mem = Runtime.getRuntime().maxMemory();
        long memInMb = mem / 0x100000L;
        long maxAllowed = memInMb / 10L;
        return (int)Math.max(2L, Math.min(maxAllowed, (long)recommended));
    }

    void destroy() {
        if (vertx != null && VertxCoreRecorder.vertx.v != null) {
            FastThreadLocal.destroy();
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference problem = new AtomicReference();
            VertxCoreRecorder.vertx.v.close((Handler)new Handler<AsyncResult<Void>>(){

                public void handle(AsyncResult<Void> ar) {
                    if (ar.failed()) {
                        problem.set(ar.cause());
                    }
                    latch.countDown();
                }
            });
            try {
                latch.await();
                if (problem.get() != null) {
                    throw new IllegalStateException("Error when closing Vert.x instance", (Throwable)problem.get());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Exception when closing Vert.x instance", e);
            }
            vertx = null;
        }
    }

    private static void initializeClusterOptions(VertxConfiguration conf, VertxOptions options) {
        ClusterConfiguration cluster = conf.cluster;
        options.getEventBusOptions().setClusterPingReplyInterval(cluster.pingReplyInterval.toMillis());
        options.getEventBusOptions().setClusterPingInterval(cluster.pingInterval.toMillis());
        if (cluster.host != null) {
            options.getEventBusOptions().setHost(cluster.host);
        }
        if (cluster.port.isPresent()) {
            options.getEventBusOptions().setPort(cluster.port.getAsInt());
        }
        cluster.publicHost.ifPresent(arg_0 -> ((EventBusOptions)options.getEventBusOptions()).setClusterPublicHost(arg_0));
        if (cluster.publicPort.isPresent()) {
            options.getEventBusOptions().setPort(cluster.publicPort.getAsInt());
        }
    }

    private static void setEventBusOptions(VertxConfiguration conf, VertxOptions options) {
        EventBusConfiguration eb = conf.eventbus;
        EventBusOptions opts = new EventBusOptions();
        opts.setAcceptBacklog(eb.acceptBacklog.orElse(-1));
        opts.setClientAuth(ClientAuth.valueOf((String)eb.clientAuth.toUpperCase()));
        opts.setConnectTimeout((int)Math.min(Integer.MAX_VALUE, eb.connectTimeout.toMillis()));
        opts.setIdleTimeout(eb.idleTimeout.isPresent() ? (int)Math.max(1L, Math.min(Integer.MAX_VALUE, eb.idleTimeout.get().getSeconds())) : 0);
        opts.setSendBufferSize(eb.sendBufferSize.orElse(-1));
        opts.setSoLinger(eb.soLinger.orElse(-1));
        opts.setSsl(eb.ssl);
        opts.setReceiveBufferSize(eb.receiveBufferSize.orElse(-1));
        opts.setReconnectAttempts(eb.reconnectAttempts);
        opts.setReconnectInterval(eb.reconnectInterval.toMillis());
        opts.setReuseAddress(eb.reuseAddress);
        opts.setReusePort(eb.reusePort);
        opts.setTrafficClass(eb.trafficClass.orElse(-1));
        opts.setTcpKeepAlive(eb.tcpKeepAlive);
        opts.setTcpNoDelay(eb.tcpNoDelay);
        opts.setTrustAll(eb.trustAll);
        SSLConfigHelper.configurePemKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificateJks);
        SSLConfigHelper.configurePfxKeyCertOptions((TCPSSLOptions)opts, eb.keyCertificatePfx);
        SSLConfigHelper.configurePemTrustOptions((TCPSSLOptions)opts, eb.trustCertificatePem);
        SSLConfigHelper.configureJksKeyCertOptions((TCPSSLOptions)opts, eb.trustCertificateJks);
        SSLConfigHelper.configurePfxTrustOptions((TCPSSLOptions)opts, eb.trustCertificatePfx);
        options.setEventBusOptions(opts);
    }

    private static void setAddressResolverOptions(VertxConfiguration conf, VertxOptions options) {
        AddressResolverConfiguration ar = conf.resolver;
        AddressResolverOptions opts = new AddressResolverOptions();
        opts.setCacheMaxTimeToLive(ar.cacheMaxTimeToLive);
        opts.setCacheMinTimeToLive(ar.cacheMinTimeToLive);
        opts.setCacheNegativeTimeToLive(ar.cacheNegativeTimeToLive);
        options.setAddressResolverOptions(opts);
    }

    public Supplier<EventLoopGroup> bossSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                vertx.get();
                return ((VertxImpl)VertxCoreRecorder.vertx.v).getAcceptorEventLoopGroup();
            }
        };
    }

    public Supplier<EventLoopGroup> mainSupplier() {
        return new Supplier<EventLoopGroup>(){

            @Override
            public EventLoopGroup get() {
                return vertx.get().nettyEventLoopGroup();
            }
        };
    }

    public Supplier<Integer> calculateEventLoopThreads(VertxConfiguration conf) {
        final int threads = conf.eventLoopsPoolSize.isPresent() ? conf.eventLoopsPoolSize.getAsInt() : VertxCoreRecorder.calculateDefaultIOThreads();
        return new Supplier<Integer>(){

            @Override
            public Integer get() {
                return threads;
            }
        };
    }

    public static Supplier<Vertx> recoverFailedStart(VertxConfiguration config) {
        vertx = new VertxSupplier(config, Collections.emptyList(), null);
        return vertx;
    }

    public static void setWebDeploymentId(String webDeploymentId) {
        VertxCoreRecorder.webDeploymentId = webDeploymentId;
    }

    private static void deleteDirectory(File directory) {
        File[] children = directory.listFiles();
        if (children != null) {
            for (File child : children) {
                VertxCoreRecorder.deleteDirectory(child);
            }
        }
        directory.delete();
    }

    static class VertxOptionsCustomizer {
        final List<Consumer<VertxOptions>> customizers;

        VertxOptionsCustomizer(List<Consumer<VertxOptions>> customizers) {
            this.customizers = customizers;
        }

        VertxOptions customize(VertxOptions options) {
            for (Consumer<VertxOptions> x : this.customizers) {
                x.accept(options);
            }
            return options;
        }
    }

    static class VertxSupplier
    implements Supplier<Vertx> {
        final VertxConfiguration config;
        final VertxOptionsCustomizer customizer;
        final ShutdownContext shutdown;
        Vertx v;

        VertxSupplier(VertxConfiguration config, List<Consumer<VertxOptions>> customizers, ShutdownContext shutdown) {
            this.config = config;
            this.customizer = new VertxOptionsCustomizer(customizers);
            this.shutdown = shutdown;
        }

        @Override
        public synchronized Vertx get() {
            if (this.v == null) {
                this.v = VertxCoreRecorder.initialize(this.config, this.customizer, this.shutdown);
            }
            return this.v;
        }
    }
}

