/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.substrate.SubstrateConfigBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.ConsumeEvent;
import io.quarkus.vertx.deployment.EventConsumerBusinessMethodItem;
import io.quarkus.vertx.deployment.VertxBuildItem;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.quarkus.vertx.runtime.VertxConfiguration;
import io.quarkus.vertx.runtime.VertxProducer;
import io.quarkus.vertx.runtime.VertxRecorder;
import io.vertx.axle.core.eventbus.Message;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class VertxProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)VertxProcessor.class.getName());
    private static final DotName CONSUME_EVENT = DotName.createSimple((String)ConsumeEvent.class.getName());
    private static final DotName MESSAGE = DotName.createSimple((String)io.vertx.core.eventbus.Message.class.getName());
    private static final DotName RX_MESSAGE = DotName.createSimple((String)io.vertx.reactivex.core.eventbus.Message.class.getName());
    private static final DotName AXLE_MESSAGE = DotName.createSimple((String)Message.class.getName());
    private static final DotName COMPLETION_STAGE = DotName.createSimple((String)CompletionStage.class.getName());
    private static final String INVOKER_SUFFIX = "_VertxInvoker";
    private static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_TYPE = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class});
    private static final MethodDescriptor VERTX_EXECUTE_BLOCKING = MethodDescriptor.ofMethod(Vertx.class, (String)"executeBlocking", Void.TYPE, (Class[])new Class[]{Handler.class, Boolean.TYPE, Handler.class});
    private static final MethodDescriptor FUTURE_COMPLETE = MethodDescriptor.ofMethod(Future.class, (String)"complete", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor FUTURE_FAIL = MethodDescriptor.ofMethod(Future.class, (String)"fail", Void.TYPE, (Class[])new Class[]{Throwable.class});
    private static final MethodDescriptor RX_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(io.vertx.reactivex.core.eventbus.Message.class, (String)"newInstance", io.vertx.reactivex.core.eventbus.Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor AXLE_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(Message.class, (String)"newInstance", Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor MESSAGE_REPLY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"reply", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MESSAGE_BODY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"body", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_DESTROY = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]);
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;

    VertxProcessor() {
    }

    @BuildStep
    SubstrateConfigBuildItem build() {
        return SubstrateConfigBuildItem.builder().addNativeImageSystemProperty("vertx.disableDnsResolver", "true").build();
    }

    @BuildStep
    AdditionalBeanBuildItem registerBean() {
        return AdditionalBeanBuildItem.unremovableOf(VertxProducer.class);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    VertxBuildItem build(VertxRecorder recorder, BeanContainerBuildItem beanContainer, BuildProducer<FeatureBuildItem> feature, List<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, final BuildProducer<GeneratedClassBuildItem> generatedClass, AnnotationProxyBuildItem annotationProxy, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdown, VertxConfiguration config, BuildProducer<ServiceStartBuildItem> serviceStart) {
        feature.produce((BuildItem)new FeatureBuildItem("vertx"));
        HashMap<String, Object> messageConsumerConfigurations = new HashMap<String, Object>();
        ClassOutput classOutput = new ClassOutput(){

            public void write(String name, byte[] data) {
                generatedClass.produce((BuildItem)new GeneratedClassBuildItem(true, name, data));
            }
        };
        for (EventConsumerBusinessMethodItem businessMethod : messageConsumerBusinessMethods) {
            String invokerClass = this.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), businessMethod.getConsumeEvent(), classOutput);
            messageConsumerConfigurations.put(invokerClass, annotationProxy.builder(businessMethod.getConsumeEvent(), ConsumeEvent.class).withDefaultValue("value", (Object)businessMethod.getBean().getBeanClass().toString()).build(classOutput));
            this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
        }
        RuntimeValue vertx = recorder.configureVertx(beanContainer.getValue(), config, messageConsumerConfigurations, launchMode.getLaunchMode(), (ShutdownContext)shutdown);
        serviceStart.produce((BuildItem)new ServiceStartBuildItem("vertx"));
        return new VertxBuildItem((RuntimeValue<Vertx>)vertx);
    }

    @BuildStep
    public UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(CONSUME_EVENT));
    }

    @BuildStep
    void validateBeanDeployment(ValidationPhaseBuildItem validationPhase, BuildProducer<EventConsumerBusinessMethodItem> messageConsumerBusinessMethods, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        AnnotationStore annotationStore = (AnnotationStore)validationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : (List)validationPhase.getContext().get(BuildExtension.Key.BEANS)) {
            if (!bean.isClassBean()) continue;
            for (MethodInfo method : ((AnnotationTarget)bean.getTarget().get()).asClass().methods()) {
                AnnotationInstance consumeEvent = annotationStore.getAnnotation((AnnotationTarget)method, CONSUME_EVENT);
                if (consumeEvent == null) continue;
                List params = method.parameters();
                if (params.size() != 1) {
                    throw new IllegalStateException(String.format("Event consumer business method must accept exactly one parameter: %s [method: %s, bean:%s", params, method, bean));
                }
                messageConsumerBusinessMethods.produce((BuildItem)new EventConsumerBusinessMethodItem(bean, method, consumeEvent));
                LOGGER.debugf("Found event consumer business method %s declared on %s", (Object)method, (Object)bean);
            }
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer() {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (context.getAnnotations().isEmpty() && context.getTarget().asClass().annotations().containsKey(CONSUME_EVENT)) {
                    LOGGER.debugf("Found event consumer business methods on a class %s with no scope annotation - adding @Singleton", (Object)context.getTarget());
                    context.transform().add(Singleton.class, new AnnotationValue[0]).done();
                }
            }
        });
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, AnnotationInstance consumeEvent, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((ClassInfo)bean.getImplClazz()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{EventConsumerInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invoke", Void.TYPE, new Class[]{io.vertx.core.eventbus.Message.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        AnnotationValue blocking = consumeEvent.value("blocking");
        if (blocking != null && blocking.asBoolean()) {
            ResultHandle vertxHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_TYPE, containerHandle, new ResultHandle[]{invoke.loadClass(Vertx.class), invoke.newArray(Annotation.class.getName(), invoke.load(0))}), new ResultHandle[0]);
            FunctionCreator func = invoke.createFunction(Handler.class);
            BytecodeCreator funcBytecode = func.getBytecode();
            AssignableResultHandle messageHandle = funcBytecode.createVariable(io.vertx.core.eventbus.Message.class);
            funcBytecode.assign(messageHandle, invoke.getMethodParam(0));
            TryBlock tryBlock = funcBytecode.tryBlock();
            this.invoke(bean, method, (ResultHandle)messageHandle, (BytecodeCreator)tryBlock);
            tryBlock.invokeInterfaceMethod(FUTURE_COMPLETE, funcBytecode.getMethodParam(0), new ResultHandle[]{tryBlock.loadNull()});
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            catchBlock.invokeInterfaceMethod(FUTURE_FAIL, funcBytecode.getMethodParam(0), new ResultHandle[]{catchBlock.getMethodParam(0)});
            funcBytecode.returnValue(null);
            invoke.invokeInterfaceMethod(VERTX_EXECUTE_BLOCKING, vertxHandle, new ResultHandle[]{func.getInstance(), invoke.load(false), invoke.loadNull()});
        } else {
            this.invoke(bean, method, invoke.getMethodParam(0), (BytecodeCreator)invoke);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private void invoke(BeanInfo bean, MethodInfo method, ResultHandle messageHandle, BytecodeCreator invoke) {
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_BEAN, containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
        Type paramType = (Type)method.parameters().get(0);
        if (paramType.name().equals((Object)MESSAGE)) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{messageHandle});
        } else if (paramType.name().equals((Object)RX_MESSAGE)) {
            ResultHandle rxMessageHandle = invoke.invokeStaticMethod(RX_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.reactivex.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{rxMessageHandle});
        } else if (paramType.name().equals((Object)AXLE_MESSAGE)) {
            ResultHandle axleMessageHandle = invoke.invokeStaticMethod(AXLE_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{Message.class}), beanInstanceHandle, new ResultHandle[]{axleMessageHandle});
        } else {
            ResultHandle bodyHandle = invoke.invokeInterfaceMethod(MESSAGE_BODY, messageHandle, new ResultHandle[0]);
            ResultHandle replyHandle = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)bean.getImplClazz().name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])new String[]{paramType.name().toString()}), beanInstanceHandle, new ResultHandle[]{bodyHandle});
            if (replyHandle != null) {
                if (method.returnType().name().equals((Object)COMPLETION_STAGE)) {
                    FunctionCreator func = invoke.createFunction(Consumer.class);
                    BytecodeCreator funcBytecode = func.getBytecode();
                    funcBytecode.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{funcBytecode.getMethodParam(0)});
                    funcBytecode.returnValue(null);
                    invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(CompletionStage.class, (String)"thenAccept", CompletionStage.class, (Class[])new Class[]{Consumer.class}), replyHandle, new ResultHandle[]{func.getInstance()});
                } else {
                    invoke.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{replyHandle});
                }
            }
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(INSTANCE_HANDLE_DESTROY, instanceHandle, new ResultHandle[0]);
        }
    }
}

