/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.vertx.deployment.MessageCodecBuildItem;
import io.quarkus.vertx.deployment.VertxConstants;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class EventBusCodecProcessor {
    private static final Logger LOGGER = Logger.getLogger((String)EventBusCodecProcessor.class.getName());
    @Inject
    BuildProducer<ReflectiveClassBuildItem> reflectiveClass;
    private static final List<String> BUILT_IN_CODECS = Arrays.asList(Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Integer.class.getName(), Float.class.getName(), Long.class.getName(), Short.class.getName(), String.class.getName(), Void.class.getName(), JsonObject.class.getName(), JsonArray.class.getName(), Buffer.class.getName(), io.vertx.axle.core.buffer.Buffer.class.getName(), io.vertx.reactivex.core.buffer.Buffer.class.getName());

    @BuildStep
    public void registerCodecs(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<MessageCodecBuildItem> messageCodecs) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection consumeEventAnnotationInstances = index.getAnnotations(VertxConstants.CONSUME_EVENT);
        HashMap<Type, DotName> codecByTypes = new HashMap<Type, DotName>();
        for (AnnotationInstance annotationInstance : consumeEventAnnotationInstances) {
            AnnotationTarget typeTarget = annotationInstance.target();
            if (typeTarget.kind() != AnnotationTarget.Kind.METHOD) {
                throw new UnsupportedOperationException("@ConsumeEvent annotation must target a method");
            }
            MethodInfo method = typeTarget.asMethod();
            Type codecTargetFromReturnType = EventBusCodecProcessor.extractPayloadTypeFromReturn(method);
            Type codecTargetFromParameter = EventBusCodecProcessor.extractPayloadTypeFromParameter(method);
            AnnotationValue codec = annotationInstance.value("codec");
            if (codec != null && codec.asClass().kind() == Type.Kind.CLASS) {
                if (codecTargetFromParameter == null) {
                    throw new IllegalStateException("Invalid `codec` argument in @ConsumeEvent - no parameter");
                }
                codecByTypes.put(codecTargetFromParameter, codec.asClass().asClassType().name());
            } else if (codecTargetFromParameter != null && !EventBusCodecProcessor.hasBuiltInCodec(codecTargetFromParameter)) {
                AnnotationValue local = annotationInstance.value("local");
                if (local != null && !local.asBoolean()) {
                    throw new UnsupportedOperationException("The generic message codec can only be used for local delivery,, implement your own event bus codec for " + codecTargetFromParameter.name().toString());
                }
                if (!codecByTypes.containsKey(codecTargetFromParameter)) {
                    LOGGER.infof("Local Message Codec registered for type %s", (Object)codecTargetFromParameter.toString());
                    codecByTypes.put(codecTargetFromParameter, VertxConstants.LOCAL_EVENT_BUS_CODEC);
                }
            }
            if (codecTargetFromReturnType == null || EventBusCodecProcessor.hasBuiltInCodec(codecTargetFromReturnType) || codecByTypes.containsKey(codecTargetFromReturnType)) continue;
            LOGGER.infof("Local Message Codec registered for type %s", (Object)codecTargetFromReturnType.toString());
            codecByTypes.put(codecTargetFromReturnType, VertxConstants.LOCAL_EVENT_BUS_CODEC);
        }
        for (Map.Entry entry : codecByTypes.entrySet()) {
            messageCodecs.produce((BuildItem)new MessageCodecBuildItem(((Type)entry.getKey()).toString(), ((DotName)entry.getValue()).toString()));
        }
        codecByTypes.values().stream().map(DotName::toString).distinct().forEach(name -> this.reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{name})));
    }

    private static Type extractPayloadTypeFromReturn(MethodInfo method) {
        Type returnType = method.returnType();
        if (returnType.kind() == Type.Kind.CLASS) {
            return returnType;
        }
        if (returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType returnedParamType = returnType.asParameterizedType();
            if (!returnedParamType.arguments().isEmpty() && returnedParamType.name().equals((Object)VertxConstants.COMPLETION_STAGE)) {
                return (Type)returnedParamType.arguments().get(0);
            }
            return returnedParamType;
        }
        return null;
    }

    private static Type extractPayloadTypeFromParameter(MethodInfo method) {
        List parameters = method.parameters();
        if (parameters.isEmpty()) {
            return null;
        }
        Type param = (Type)method.parameters().get(0);
        if (param.kind() == Type.Kind.CLASS) {
            return param;
        }
        if (param.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterType = param.asParameterizedType();
            if (EventBusCodecProcessor.isMessageClass(parameterType) && !parameterType.arguments().isEmpty()) {
                return (Type)parameterType.arguments().get(0);
            }
            return parameterType;
        }
        return null;
    }

    private static boolean hasBuiltInCodec(Type type) {
        if (type.kind() == Type.Kind.PRIMITIVE) {
            return true;
        }
        String typeAsString = type.name().toString();
        return BUILT_IN_CODECS.contains(typeAsString);
    }

    private static boolean isMessageClass(ParameterizedType type) {
        return type.name().equals((Object)VertxConstants.MESSAGE) || type.name().equals((Object)VertxConstants.RX_MESSAGE) || type.name().equals((Object)VertxConstants.AXLE_MESSAGE);
    }
}

