/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.vertx.deployment.VertxConstants;
import io.quarkus.vertx.runtime.EventConsumerInvoker;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.eventbus.Message;
import java.lang.annotation.Annotation;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

class EventBusConsumer {
    private static final String INVOKER_SUFFIX = "_VertxInvoker";
    private static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_TYPE = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class});
    private static final MethodDescriptor VERTX_EXECUTE_BLOCKING = MethodDescriptor.ofMethod(Vertx.class, (String)"executeBlocking", Void.TYPE, (Class[])new Class[]{Handler.class, Boolean.TYPE, Handler.class});
    private static final MethodDescriptor FUTURE_COMPLETE = MethodDescriptor.ofMethod(Future.class, (String)"complete", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor FUTURE_FAIL = MethodDescriptor.ofMethod(Future.class, (String)"fail", Void.TYPE, (Class[])new Class[]{Throwable.class});
    private static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    private static final MethodDescriptor ARC_CONTAINER_INSTANCE_FOR_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    private static final MethodDescriptor RX_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(io.vertx.reactivex.core.eventbus.Message.class, (String)"newInstance", io.vertx.reactivex.core.eventbus.Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor AXLE_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(io.vertx.axle.core.eventbus.Message.class, (String)"newInstance", io.vertx.axle.core.eventbus.Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor MUTINY_MESSAGE_NEW_INSTANCE = MethodDescriptor.ofMethod(Message.class, (String)"newInstance", Message.class, (Class[])new Class[]{io.vertx.core.eventbus.Message.class});
    private static final MethodDescriptor MESSAGE_REPLY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"reply", Void.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor MESSAGE_FAIL = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"fail", Void.TYPE, (Class[])new Class[]{Integer.TYPE, String.class});
    private static final MethodDescriptor MESSAGE_BODY = MethodDescriptor.ofMethod(io.vertx.core.eventbus.Message.class, (String)"body", Object.class, (Class[])new Class[0]);
    private static final MethodDescriptor INSTANCE_HANDLE_DESTROY = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]);
    protected static final MethodDescriptor WHEN_COMPLETE = MethodDescriptor.ofMethod(CompletionStage.class, (String)"whenComplete", CompletionStage.class, (Class[])new Class[]{BiConsumer.class});
    protected static final MethodDescriptor SUBSCRIBE_AS_COMPLETION_STAGE = MethodDescriptor.ofMethod(Uni.class, (String)"subscribeAsCompletionStage", CompletableFuture.class, (Class[])new Class[0]);
    protected static final MethodDescriptor THROWABLE_GET_MESSAGE = MethodDescriptor.ofMethod(Throwable.class, (String)"getMessage", String.class, (Class[])new Class[0]);

    static String generateInvoker(BeanInfo bean, MethodInfo method, AnnotationInstance consumeEvent, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((ClassInfo)bean.getImplClazz()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{EventConsumerInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Void.TYPE, new Class[]{Object.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        AnnotationValue blocking = consumeEvent.value("blocking");
        if (blocking != null && blocking.asBoolean()) {
            ResultHandle vertxHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_TYPE, containerHandle, new ResultHandle[]{invoke.loadClass(Vertx.class), invoke.newArray(Annotation.class.getName(), invoke.load(0))}), new ResultHandle[0]);
            FunctionCreator func = invoke.createFunction(Handler.class);
            BytecodeCreator funcBytecode = func.getBytecode();
            AssignableResultHandle messageHandle = funcBytecode.createVariable(io.vertx.core.eventbus.Message.class);
            funcBytecode.assign(messageHandle, invoke.getMethodParam(0));
            TryBlock tryBlock = funcBytecode.tryBlock();
            EventBusConsumer.invoke(bean, method, (ResultHandle)messageHandle, (BytecodeCreator)tryBlock);
            tryBlock.invokeInterfaceMethod(FUTURE_COMPLETE, funcBytecode.getMethodParam(0), new ResultHandle[]{tryBlock.loadNull()});
            CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
            catchBlock.invokeInterfaceMethod(FUTURE_FAIL, funcBytecode.getMethodParam(0), new ResultHandle[]{catchBlock.getMethodParam(0)});
            funcBytecode.returnValue(null);
            invoke.invokeInterfaceMethod(VERTX_EXECUTE_BLOCKING, vertxHandle, new ResultHandle[]{func.getInstance(), invoke.load(false), invoke.loadNull()});
        } else {
            EventBusConsumer.invoke(bean, method, invoke.getMethodParam(0), (BytecodeCreator)invoke);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private static void logDeprecation(BytecodeCreator invoke, MethodInfo method, String deprecatedClass) {
        String msg = String.format("The `%s.%s` method is using the deprecated `%s` class. This class will be removed in a future version. It is recommended to switch to `%s`", method.declaringClass().name(), method.name(), deprecatedClass, Message.class.getName());
        ResultHandle loggerName = invoke.load(EventBusConsumer.class.getName());
        ResultHandle message = invoke.load(msg);
        MethodDescriptor getLoggerMethod = MethodDescriptor.ofMethod(Logger.class, (String)"getLogger", Logger.class, (Class[])new Class[]{String.class});
        ResultHandle logger = invoke.invokeStaticMethod(getLoggerMethod, new ResultHandle[]{loggerName});
        MethodDescriptor warnMethod = MethodDescriptor.ofMethod(Logger.class, (String)"warn", Void.TYPE, (Class[])new Class[]{Object.class});
        invoke.invokeVirtualMethod(warnMethod, logger, new ResultHandle[]{message});
    }

    private static void invoke(BeanInfo bean, MethodInfo method, ResultHandle messageHandle, BytecodeCreator invoke) {
        ResultHandle containerHandle = invoke.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE_FOR_BEAN, containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
        Type paramType = (Type)method.parameters().get(0);
        if (paramType.name().equals((Object)VertxConstants.MESSAGE)) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{messageHandle});
        } else if (paramType.name().equals((Object)VertxConstants.RX_MESSAGE)) {
            EventBusConsumer.logDeprecation(invoke, method, VertxConstants.RX_MESSAGE.toString());
            ResultHandle rxMessageHandle = invoke.invokeStaticMethod(RX_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.reactivex.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{rxMessageHandle});
        } else if (paramType.name().equals((Object)VertxConstants.AXLE_MESSAGE)) {
            EventBusConsumer.logDeprecation(invoke, method, VertxConstants.AXLE_MESSAGE.toString());
            ResultHandle axleMessageHandle = invoke.invokeStaticMethod(AXLE_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{io.vertx.axle.core.eventbus.Message.class}), beanInstanceHandle, new ResultHandle[]{axleMessageHandle});
        } else if (paramType.name().equals((Object)VertxConstants.MUTINY_MESSAGE)) {
            ResultHandle mutinyMessageHandle = invoke.invokeStaticMethod(MUTINY_MESSAGE_NEW_INSTANCE, new ResultHandle[]{messageHandle});
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{Message.class}), beanInstanceHandle, new ResultHandle[]{mutinyMessageHandle});
        } else {
            ResultHandle bodyHandle = invoke.invokeInterfaceMethod(MESSAGE_BODY, messageHandle, new ResultHandle[0]);
            ResultHandle replyHandle = invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((String)bean.getImplClazz().name().toString(), (String)method.name(), (String)method.returnType().name().toString(), (String[])new String[]{paramType.name().toString()}), beanInstanceHandle, new ResultHandle[]{bodyHandle});
            if (replyHandle != null) {
                if (method.returnType().name().equals((Object)VertxConstants.COMPLETION_STAGE)) {
                    FunctionCreator handler = EventBusConsumer.generateWhenCompleteHandler(messageHandle, invoke);
                    invoke.invokeInterfaceMethod(WHEN_COMPLETE, replyHandle, new ResultHandle[]{handler.getInstance()});
                } else if (method.returnType().name().equals((Object)VertxConstants.UNI)) {
                    FunctionCreator handler = EventBusConsumer.generateWhenCompleteHandler(messageHandle, invoke);
                    ResultHandle subscribedCompletionStage = invoke.invokeInterfaceMethod(SUBSCRIBE_AS_COMPLETION_STAGE, replyHandle, new ResultHandle[0]);
                    invoke.invokeInterfaceMethod(WHEN_COMPLETE, subscribedCompletionStage, new ResultHandle[]{handler.getInstance()});
                } else {
                    invoke.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{replyHandle});
                }
            }
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(INSTANCE_HANDLE_DESTROY, instanceHandle, new ResultHandle[0]);
        }
    }

    private static FunctionCreator generateWhenCompleteHandler(ResultHandle messageHandle, BytecodeCreator invoke) {
        FunctionCreator handler = invoke.createFunction(BiConsumer.class);
        BytecodeCreator bytecode = handler.getBytecode();
        AssignableResultHandle whenResult = bytecode.createVariable(Object.class);
        bytecode.assign(whenResult, bytecode.getMethodParam(0));
        AssignableResultHandle whenFailure = bytecode.createVariable(Exception.class);
        bytecode.assign(whenFailure, bytecode.getMethodParam(1));
        AssignableResultHandle message = bytecode.createVariable(io.vertx.core.eventbus.Message.class);
        bytecode.assign(message, messageHandle);
        BranchResult ifFailureIfNull = bytecode.ifNull((ResultHandle)whenFailure);
        BytecodeCreator failureIsNotNull = ifFailureIfNull.falseBranch();
        ResultHandle failureStatus = failureIsNotNull.load(8191);
        ResultHandle failureMessage = failureIsNotNull.invokeVirtualMethod(THROWABLE_GET_MESSAGE, (ResultHandle)whenFailure, new ResultHandle[0]);
        failureIsNotNull.invokeInterfaceMethod(MESSAGE_FAIL, (ResultHandle)message, new ResultHandle[]{failureStatus, failureMessage});
        BytecodeCreator failureIsNull = ifFailureIfNull.trueBranch();
        failureIsNull.invokeInterfaceMethod(MESSAGE_REPLY, messageHandle, new ResultHandle[]{whenResult});
        bytecode.returnValue(null);
        return handler;
    }

    private EventBusConsumer() {
    }
}

