/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class RouteBuildItem
extends MultiBuildItem {
    private RouteType typeOfRoute = RouteType.APPLICATION_ROUTE;
    private OptionalInt order = OptionalInt.empty();
    private String path;
    private Consumer<Route> customizer;
    private boolean isManagement;
    private Handler<RoutingContext> handler;
    private HandlerType typeOfHandler = HandlerType.NORMAL;
    private boolean displayOnNotFoundPage;
    private String notFoundPageTitle;
    private String routeConfigKey;

    public RouteType getTypeOfRoute() {
        return this.typeOfRoute;
    }

    public boolean hasOrder() {
        return this.order.isPresent();
    }

    public int getOrder() {
        if (this.order.isPresent()) {
            return this.order.getAsInt();
        }
        throw new IllegalStateException("No order set");
    }

    public boolean hasRouteConfigKey() {
        return this.routeConfigKey != null;
    }

    public String getRouteConfigKey() {
        return this.routeConfigKey;
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public HandlerType getHandlerType() {
        return this.typeOfHandler;
    }

    public String getPath() {
        return this.path;
    }

    public Consumer<Route> getCustomizer() {
        return this.customizer;
    }

    public String getNotFoundPageTitle() {
        return this.notFoundPageTitle;
    }

    public boolean isDisplayOnNotFoundPage() {
        return this.displayOnNotFoundPage;
    }

    public static Builder newApplicationRoute(String path) {
        return new Builder(RouteType.APPLICATION_ROUTE, path, false);
    }

    public static Builder newAbsoluteRoute(String path) {
        return new Builder(RouteType.ABSOLUTE_ROUTE, path, false);
    }

    public static Builder newFrameworkRoute(String path) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, false);
    }

    public static Builder newManagementRoute(String path) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, true);
    }

    public static Builder newManagementRoute(String path, String managementConfigKey) {
        return new Builder(RouteType.FRAMEWORK_ROUTE, path, managementConfigKey == null || RouteBuildItem.isManagement(managementConfigKey));
    }

    private static boolean isManagement(String managementConfigKey) {
        Config config = ConfigProvider.getConfig();
        return (Boolean)config.getValue(managementConfigKey, Boolean.TYPE);
    }

    public boolean isManagement() {
        return this.isManagement;
    }

    public static enum RouteType {
        FRAMEWORK_ROUTE,
        APPLICATION_ROUTE,
        ABSOLUTE_ROUTE;

    }

    public static enum HandlerType {
        NORMAL,
        BLOCKING,
        FAILURE;

    }

    public static class Builder {
        private final RouteBuildItem item = new RouteBuildItem();

        private Builder(RouteType type, String path, boolean isManagement) {
            this.item.typeOfRoute = type;
            this.item.path = path;
            this.item.isManagement = isManagement;
        }

        public Builder withRouteCustomizer(Consumer<Route> customizer) {
            this.item.customizer = customizer;
            return this;
        }

        public Builder withOrder(int order) {
            this.item.order = OptionalInt.of(order);
            return this;
        }

        public Builder withRequestHandler(Handler<RoutingContext> handler) {
            this.item.handler = handler;
            return this;
        }

        public Builder asBlockingRoute() {
            if (this.item.typeOfHandler == HandlerType.FAILURE) {
                throw new IllegalArgumentException("A failure route cannot be a blocking route");
            }
            this.item.typeOfHandler = HandlerType.BLOCKING;
            return this;
        }

        public Builder asFailureRoute() {
            if (this.item.typeOfHandler == HandlerType.BLOCKING) {
                throw new IllegalArgumentException("A blocking route cannot be a failure route");
            }
            this.item.typeOfHandler = HandlerType.FAILURE;
            return this;
        }

        public Builder displayOnNotFoundPage() {
            this.item.displayOnNotFoundPage = true;
            return this;
        }

        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            this.item.displayOnNotFoundPage = true;
            this.item.notFoundPageTitle = notFoundPageTitle;
            return this;
        }

        public Builder withRoutePathConfigKey(String attributeName) {
            this.item.routeConfigKey = attributeName;
            return this;
        }

        public RouteBuildItem build() {
            if (this.item.handler == null) {
                throw new IllegalArgumentException("The route handler must be set");
            }
            return this.item;
        }
    }
}

