/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpSecurityPolicyBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.PolicyConfig;
import io.quarkus.vertx.http.runtime.security.AuthenticatedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PermitSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.SupplierImpl;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class HttpSecurityProcessor {
    @BuildStep
    public void builtins(BuildProducer<HttpSecurityPolicyBuildItem> producer, HttpBuildTimeConfig buildTimeConfig, BuildProducer<AdditionalBeanBuildItem> beanProducer) {
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("deny", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new DenySecurityPolicy())));
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("permit", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new PermitSecurityPolicy())));
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("authenticated", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new AuthenticatedHttpSecurityPolicy())));
        if (!buildTimeConfig.auth.permissions.isEmpty()) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PathMatchingHttpSecurityPolicy.class));
        }
        for (Map.Entry e : buildTimeConfig.auth.rolePolicy.entrySet()) {
            producer.produce((BuildItem)new HttpSecurityPolicyBuildItem((String)e.getKey(), (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new RolesAllowedHttpSecurityPolicy(((PolicyConfig)e.getValue()).rolesAllowed))));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void initFormAuth(BeanContainerBuildItem beanContainerBuildItem, HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig, HttpConfiguration httpConfiguration) {
        if (buildTimeConfig.auth.form.enabled) {
            recorder.setupFormAuth(beanContainerBuildItem.getValue(), httpConfiguration, buildTimeConfig);
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(HttpSecurityRecorder recorder, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Capabilities capabilities, BuildProducer<BeanContainerListenerBuildItem> beanContainerListenerBuildItemBuildProducer, HttpBuildTimeConfig buildTimeConfig, List<HttpSecurityPolicyBuildItem> httpSecurityPolicyBuildItemList) {
        HashMap<String, Supplier<HttpSecurityPolicy>> policyMap = new HashMap<String, Supplier<HttpSecurityPolicy>>();
        for (HttpSecurityPolicyBuildItem e : httpSecurityPolicyBuildItemList) {
            if (policyMap.containsKey(e.getName())) {
                throw new RuntimeException("Multiple HTTP security policies defined with name " + e.getName());
            }
            policyMap.put(e.getName(), e.policySupplier);
        }
        if (buildTimeConfig.auth.form.enabled) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(FormAuthenticationMechanism.class));
        } else if (buildTimeConfig.auth.basic) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(BasicAuthenticationMechanism.class));
        }
        if (capabilities.isCapabilityPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(HttpAuthorizer.class).build());
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.authenticationMechanismHandler(), 200));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), 100));
            if (!buildTimeConfig.auth.permissions.isEmpty()) {
                beanContainerListenerBuildItemBuildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initPermissions(buildTimeConfig, policyMap)));
            }
        } else if (!buildTimeConfig.auth.permissions.isEmpty()) {
            throw new IllegalStateException("HTTP permissions have been set however security is not enabled");
        }
    }
}

