/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.Expression;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.DevConsole;
import io.quarkus.vertx.http.deployment.devmode.console.DevConsoleHttpHandler;
import io.quarkus.vertx.http.deployment.devmode.console.DevTemplatePathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.DevTemplateVariantsBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.FlashScopeHandler;
import io.quarkus.vertx.http.deployment.devmode.console.JsonObjectValueResolver;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleFilter;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleRecorder;
import io.quarkus.vertx.http.runtime.devmode.RedirectHandler;
import io.quarkus.vertx.http.runtime.devmode.RuntimeDevConsoleRoute;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevConsoleProcessor {
    private static final Logger log = Logger.getLogger(DevConsoleProcessor.class);
    private static final String STATIC_RESOURCES_PATH = "dev-static/";
    private static final String[] suffixes = new String[]{"html", "txt"};
    protected static volatile ServerBootstrap virtualBootstrap;
    protected static volatile Vertx devConsoleVertx;
    protected static volatile Channel channel;
    static Router router;
    static Router mainRouter;

    public static void initializeVirtual() {
        if (virtualBootstrap != null) {
            return;
        }
        devConsoleVertx = Vertx.vertx();
        final VertxInternal vertx = (VertxInternal)devConsoleVertx;
        QuarkusClassLoader ccl = (QuarkusClassLoader)DevConsoleProcessor.class.getClassLoader();
        ccl.addCloseTask(new Runnable(){

            @Override
            public void run() {
                virtualBootstrap = null;
                if (devConsoleVertx != null) {
                    devConsoleVertx.close();
                    devConsoleVertx = null;
                }
                if (channel != null) {
                    try {
                        channel.close().sync();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("failed to close virtual http");
                    }
                }
            }
        });
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<VirtualServerChannel>(){

            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<VirtualChannel>(){

            public void initChannel(VirtualChannel ch) throws Exception {
                ContextInternal context = vertx.createEventLoopContext(null, null, new JsonObject(), Thread.currentThread().getContextClassLoader());
                VertxHandler handler = VertxHandler.create((ContextInternal)context, chctx -> {
                    Http1xServerConnection conn = new Http1xServerConnection(context.owner(), null, new HttpServerOptions(), chctx, context, "localhost", null);
                    conn.handler((Handler)new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest event) {
                            mainRouter.handle((Object)event);
                        }
                    });
                    return conn;
                });
                ch.pipeline().addLast("handler", (ChannelHandler)handler);
            }
        });
        try {
            ChannelFuture future = virtualBootstrap.bind((SocketAddress)DevConsoleHttpHandler.QUARKUS_DEV_CONSOLE);
            future.sync();
            channel = future.channel();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    protected static void newRouter(Engine engine, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        String httpRootPath = httpRootPathBuildItem.adjustPath("/");
        httpRootPath = httpRootPath.substring(0, httpRootPath.lastIndexOf("/"));
        String frameworkRootPath = httpRootPathBuildItem.adjustPath(nonApplicationRootPathBuildItem.adjustPath("/"));
        frameworkRootPath = frameworkRootPath.substring(0, frameworkRootPath.lastIndexOf("/"));
        Handler<RoutingContext> errorHandler = new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                log.error((Object)"Dev console request failed ", event.failure());
            }
        };
        router = Router.router((Vertx)devConsoleVertx);
        router.errorHandler(500, (Handler)errorHandler);
        router.route().order(Integer.MIN_VALUE).handler((Handler)new FlashScopeHandler());
        router.route().method(HttpMethod.GET).order(-2147483647).handler((Handler)new DevConsole(engine, httpRootPath, frameworkRootPath));
        mainRouter = Router.router((Vertx)devConsoleVertx);
        mainRouter.errorHandler(500, (Handler)errorHandler);
        mainRouter.route(httpRootPathBuildItem.adjustPath(nonApplicationRootPathBuildItem.adjustPath("/dev/*"))).subRouter(router);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public ServiceStartBuildItem buildTimeTemplates(List<DevConsoleTemplateInfoBuildItem> items, BuildProducer<DevTemplatePathBuildItem> devTemplatePaths, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        this.collectTemplates(devTemplatePaths);
        HashMap<String, Map> results = new HashMap<String, Map>();
        for (DevConsoleTemplateInfoBuildItem i : items) {
            Map.Entry groupAndArtifact = i.groupIdAndArtifactId(curateOutcomeBuildItem);
            Map map = results.computeIfAbsent((String)groupAndArtifact.getKey() + "." + (String)groupAndArtifact.getValue(), s -> new HashMap());
            map.put(i.getName(), i.getObject());
        }
        DevConsoleManager.setTemplateInfo(results);
        return null;
    }

    @BuildStep
    DevTemplateVariantsBuildItem collectTemplateVariants(List<DevTemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(DevTemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.lastIndexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        return new DevTemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeTemplates(List<DevConsoleRuntimeTemplateInfoBuildItem> items, DevConsoleRecorder recorder, List<ServiceStartBuildItem> gate) {
        for (DevConsoleRuntimeTemplateInfoBuildItem i : items) {
            recorder.addInfo(i.getGroupId(), i.getArtifactId(), i.getName(), i.getObject());
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void setupActions(List<DevConsoleRouteBuildItem> routes, BuildProducer<RouteBuildItem> routeBuildItemBuildProducer, List<DevTemplatePathBuildItem> devTemplatePaths, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, Optional<DevTemplateVariantsBuildItem> devTemplateVariants, CurateOutcomeBuildItem curateOutcomeBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        DevConsoleProcessor.initializeVirtual();
        DevConsoleProcessor.newRouter(this.buildEngine(devTemplatePaths), httpRootPathBuildItem, nonApplicationRootPathBuildItem);
        for (DevConsoleRouteBuildItem i : routes) {
            Map.Entry groupAndArtifact = i.groupIdAndArtifactId(curateOutcomeBuildItem);
            if (i.getHandler() instanceof BytecodeRecorderImpl.ReturnedProxy) {
                routeBuildItemBuildProducer.produce((BuildItem)new RouteBuildItem((Function<Router, Route>)new RuntimeDevConsoleRoute((String)groupAndArtifact.getKey(), (String)groupAndArtifact.getValue(), i.getPath(), i.getMethod()), (Handler<RoutingContext>)i.getHandler()));
                continue;
            }
            router.route(HttpMethod.valueOf((String)i.getMethod()), "/" + (String)groupAndArtifact.getKey() + "." + (String)groupAndArtifact.getValue() + "/" + i.getPath()).handler(i.getHandler());
        }
        DevConsoleManager.registerHandler((Consumer)new DevConsoleHttpHandler());
        routeBuildItemBuildProducer.produce((BuildItem)new RouteBuildItem.Builder().route("/dev/*").handler((Handler<RoutingContext>)new DevConsoleFilter()).nonApplicationRoute(false).build());
        routeBuildItemBuildProducer.produce((BuildItem)new RouteBuildItem.Builder().route("/dev").handler((Handler<RoutingContext>)new RedirectHandler()).nonApplicationRoute(false).build());
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(nonApplicationRootPathBuildItem.adjustPath("/dev/"), "Quarkus DEV Console"));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void deployStaticResources(DevConsoleRecorder recorder, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routeBuildItemBuildProducer) throws IOException {
        AppArtifact devConsoleResourcesArtifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)"io.quarkus", (String)"quarkus-vertx-http-deployment");
        Path devConsoleStaticResourcesDeploymentPath = WebJarUtil.copyResourcesForDevOrTest((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)devConsoleResourcesArtifact, (String)STATIC_RESOURCES_PATH);
        routeBuildItemBuildProducer.produce((BuildItem)new RouteBuildItem.Builder().route("/dev/resources/*").handler((Handler<RoutingContext>)recorder.devConsoleHandler(devConsoleStaticResourcesDeploymentPath.toString(), (ShutdownContext)shutdownContext)).nonApplicationRoute(false).build());
    }

    private Engine buildEngine(List<DevTemplatePathBuildItem> devTemplatePaths) {
        EngineBuilder builder = Engine.builder().addDefaults();
        builder.addResultMapper((ResultMapper)new HtmlEscaper());
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver()).addValueResolver((ValueResolver)new JsonObjectValueResolver()).addValueResolver(ValueResolvers.rawResolver()).addNamespaceResolver(NamespaceResolver.builder((String)"info").resolve(ctx -> {
            String ext = DevConsole.currentExtension.get();
            if (ext == null) {
                return Results.Result.NOT_FOUND;
            }
            Map map = (Map)DevConsoleManager.getTemplateInfo().get(ext);
            if (map == null) {
                return Results.Result.NOT_FOUND;
            }
            Object result = map.get(ctx.getName());
            return result == null ? Results.Result.NOT_FOUND : result;
        }).build());
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"config").resolveAsync(ctx -> {
            List params = ctx.getParams();
            if (params.size() != 1 || !ctx.getName().equals("property")) {
                return Results.NOT_FOUND;
            }
            return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> {
                Optional val = ConfigProvider.getConfig().getOptionalValue(propertyName.toString(), String.class);
                return CompletableFuture.completedFuture(val.isPresent() ? val.get() : Results.Result.NOT_FOUND);
            });
        }).build());
        HashMap<String, String> templates = new HashMap<String, String>();
        for (DevTemplatePathBuildItem devTemplatePath : devTemplatePaths) {
            templates.put(devTemplatePath.getPath(), devTemplatePath.getContents());
            if (!devTemplatePath.isTag()) continue;
            String tagName = devTemplatePath.getTagName();
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, devTemplatePath.getPath()));
        }
        builder.addLocator(id -> DevConsoleProcessor.locateTemplate(id, templates));
        Engine engine = builder.build();
        for (DevTemplatePathBuildItem devTemplatePath : devTemplatePaths) {
            if (devTemplatePath.isTag()) continue;
            engine.getTemplate(devTemplatePath.getPath());
        }
        return engine;
    }

    private static Optional<TemplateLocator.TemplateLocation> locateTemplate(String id, Map<String, String> templates) {
        String template = templates.get(id);
        if (template == null) {
            for (String suffix : suffixes) {
                template = templates.get(id = id + "." + suffix);
                if (template != null) break;
            }
        }
        if (template == null) {
            return Optional.empty();
        }
        final String templateName = id;
        final String finalTemplate = template;
        return Optional.of(new TemplateLocator.TemplateLocation(){

            public Reader read() {
                return new StringReader(finalTemplate);
            }

            public Optional<Variant> getVariant() {
                int dotIdx;
                Variant variant = null;
                String fileName = templateName;
                int slashIdx = fileName.lastIndexOf(47);
                if (slashIdx != -1) {
                    fileName = fileName.substring(slashIdx, fileName.length());
                }
                if ((dotIdx = fileName.lastIndexOf(46)) != -1) {
                    String suffix = fileName.substring(dotIdx + 1, fileName.length());
                    if (suffix.equalsIgnoreCase("json")) {
                        variant = Variant.forContentType((String)"application/json");
                    } else {
                        String contentType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
                        if (contentType != null) {
                            variant = Variant.forContentType((String)contentType);
                        }
                    }
                }
                return Optional.ofNullable(variant);
            }
        });
    }

    private void collectTemplates(BuildProducer<DevTemplatePathBuildItem> devTemplatePaths) {
        try {
            ClassLoader classLoader = DevConsoleProcessor.class.getClassLoader();
            Enumeration<URL> devTemplateURLs = classLoader.getResources("/dev-templates");
            while (devTemplateURLs.hasMoreElements()) {
                String devTemplatesURL = devTemplateURLs.nextElement().toExternalForm();
                if (!devTemplatesURL.startsWith("jar:file:") || !devTemplatesURL.endsWith("!/dev-templates")) continue;
                String jarPath = devTemplatesURL.substring(9, devTemplatesURL.length() - 15);
                if (File.separatorChar == '\\') {
                    jarPath = jarPath.substring(1).replace('/', '\\');
                }
                FileSystem fs = FileSystems.newFileSystem(Paths.get(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()), new String[0]), classLoader);
                Throwable throwable = null;
                try {
                    this.scanTemplates(fs, devTemplatePaths);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fs == null) continue;
                    if (throwable != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fs.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanTemplates(FileSystem fs, final BuildProducer<DevTemplatePathBuildItem> devTemplatePaths) throws IOException {
        Map.Entry entry = ArtifactInfoUtil.groupIdAndArtifactId((FileSystem)fs);
        if (entry == null) {
            throw new RuntimeException("Artifact at " + fs + " is missing pom metadata");
        }
        final String prefix = ((String)entry.getKey()).equals("io.quarkus") && ((String)entry.getValue()).equals("quarkus-vertx-http") ? "" : (String)entry.getKey() + "." + (String)entry.getValue() + "/";
        for (Path root : fs.getRootDirectories()) {
            final Path devTemplatesPath = fs.getPath("/dev-templates", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.toString().equals("/") || dir.startsWith(devTemplatesPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String contents = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                    String relativePath = devTemplatesPath.relativize(file).toString();
                    String correctedPath = relativePath.startsWith("tags/") ? relativePath : prefix + relativePath;
                    devTemplatePaths.produce((BuildItem)new DevTemplatePathBuildItem(correctedPath, contents));
                    return super.visitFile(file, attrs);
                }
            });
        }
    }
}

