/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.util.UriNormalizationUtil;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HandlerType;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;

public final class NonApplicationRootPathBuildItem
extends SimpleBuildItem {
    final URI httpRootPath;
    final URI nonApplicationRootPath;
    final boolean dedicatedRouterRequired;
    final boolean attachedToMainRouter;

    public NonApplicationRootPathBuildItem(String httpRootPath, String nonApplicationRootPath) {
        this.httpRootPath = UriNormalizationUtil.toURI((String)httpRootPath, (boolean)true);
        this.nonApplicationRootPath = UriNormalizationUtil.normalizeWithBase((URI)this.httpRootPath, (String)nonApplicationRootPath, (boolean)true);
        this.dedicatedRouterRequired = !this.nonApplicationRootPath.getPath().equals(this.httpRootPath.getPath());
        this.attachedToMainRouter = this.nonApplicationRootPath.getPath().startsWith(this.httpRootPath.getPath());
    }

    public boolean isDedicatedRouterRequired() {
        return this.dedicatedRouterRequired;
    }

    public boolean isAttachedToMainRouter() {
        return this.attachedToMainRouter;
    }

    String getVertxRouterPath() {
        if (this.attachedToMainRouter) {
            return "/" + this.relativize(this.httpRootPath.getPath(), this.nonApplicationRootPath.getPath());
        }
        return this.getNonApplicationRootPath();
    }

    String relativize(String rootPath, String leafPath) {
        if (leafPath.startsWith(rootPath)) {
            return leafPath.substring(rootPath.length());
        }
        return null;
    }

    public String getNormalizedHttpRootPath() {
        return this.httpRootPath.getPath();
    }

    public String getNonApplicationRootPath() {
        return this.nonApplicationRootPath.getPath();
    }

    public String resolvePath(String path) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        return UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)false).getPath();
    }

    public String resolveNestedPath(String path, String subRoute) {
        if (path == null || path.trim().isEmpty()) {
            throw new IllegalArgumentException("Specified path can not be empty");
        }
        URI base = UriNormalizationUtil.normalizeWithBase((URI)this.nonApplicationRootPath, (String)path, (boolean)true);
        return UriNormalizationUtil.normalizeWithBase((URI)base, (String)subRoute, (boolean)false).getPath();
    }

    public Builder routeBuilder() {
        return new Builder(this);
    }

    public static class Builder
    extends RouteBuildItem.Builder {
        private final NonApplicationRootPathBuildItem buildItem;
        private boolean requiresLegacyRedirect = false;
        private RouteBuildItem.RouteType routeType = RouteBuildItem.RouteType.FRAMEWORK_ROUTE;
        private String path;
        private String absolute;

        Builder(NonApplicationRootPathBuildItem buildItem) {
            this.buildItem = buildItem;
        }

        @Override
        public Builder routeFunction(Function<Router, Route> routeFunction) {
            throw new RuntimeException("This method is not supported for non-application routes");
        }

        @Override
        public Builder routeFunction(String route, Consumer<Route> routeFunction) {
            boolean isFrameworkRoute;
            String temp = route;
            route = this.absolute = this.buildItem.resolvePath(route);
            boolean bl = isFrameworkRoute = this.buildItem.dedicatedRouterRequired && route.startsWith(this.buildItem.getNonApplicationRootPath());
            if (isFrameworkRoute) {
                this.path = "/" + this.buildItem.relativize(this.buildItem.getNonApplicationRootPath(), route);
                this.routeType = RouteBuildItem.RouteType.FRAMEWORK_ROUTE;
            } else if (route.startsWith(this.buildItem.httpRootPath.getPath())) {
                this.path = "/" + this.buildItem.relativize(this.buildItem.httpRootPath.getPath(), route);
                this.routeType = RouteBuildItem.RouteType.APPLICATION_ROUTE;
            } else if (route.startsWith("/")) {
                this.path = route;
                this.routeType = RouteBuildItem.RouteType.ABSOLUTE_ROUTE;
            }
            super.routeFunction(this.path, routeFunction);
            return this;
        }

        @Override
        public Builder route(String route) {
            this.routeFunction(route, (Consumer)null);
            return this;
        }

        public Builder nestedRoute(String baseRoute, String subRoute) {
            if (subRoute.startsWith("/")) {
                this.routeFunction(subRoute, (Consumer)null);
                return this;
            }
            baseRoute = baseRoute.endsWith("/") ? baseRoute : baseRoute + "/";
            this.routeFunction(baseRoute + subRoute, (Consumer)null);
            return this;
        }

        @Deprecated
        public Builder requiresLegacyRedirect() {
            this.requiresLegacyRedirect = true;
            return this;
        }

        @Override
        public Builder handler(Handler<RoutingContext> handler) {
            super.handler(handler);
            return this;
        }

        @Override
        public Builder handlerType(HandlerType handlerType) {
            super.handlerType(handlerType);
            return this;
        }

        @Override
        public Builder blockingRoute() {
            super.blockingRoute();
            return this;
        }

        @Override
        public Builder failureRoute() {
            super.failureRoute();
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage() {
            this.displayOnNotFoundPage = true;
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage(String notFoundPageTitle) {
            this.displayOnNotFoundPage = true;
            this.notFoundPageTitle = notFoundPageTitle;
            return this;
        }

        @Override
        public Builder displayOnNotFoundPage(String notFoundPageTitle, String notFoundPagePath) {
            this.displayOnNotFoundPage = true;
            this.notFoundPageTitle = notFoundPageTitle;
            this.notFoundPagePath = notFoundPagePath;
            return this;
        }

        @Override
        public RouteBuildItem build() {
            if (this.requiresLegacyRedirect && this.path.equals(this.absolute)) {
                this.requiresLegacyRedirect = false;
            }
            return new RouteBuildItem(this, this.routeType, this.requiresLegacyRedirect);
        }

        @Override
        protected NotFoundPageDisplayableEndpointBuildItem getNotFoundEndpoint() {
            if (!this.displayOnNotFoundPage) {
                return null;
            }
            if (this.notFoundPagePath == null) {
                throw new RuntimeException("Cannot display " + this.routeFunction + " on not found page as no explicit path was specified and a route function is in use");
            }
            return new NotFoundPageDisplayableEndpointBuildItem(this.absolute, this.notFoundPageTitle, true);
        }
    }
}

