/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.deployment.dev.remote.RemoteDevClient;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.spi.RemoteDevState;
import io.quarkus.runtime.util.HashUtil;
import io.vertx.core.http.HttpHeaders;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class HttpRemoteDevClient
implements RemoteDevClient {
    private final Logger log = Logger.getLogger(HttpRemoteDevClient.class);
    private final String url;
    private final String password;

    public HttpRemoteDevClient(String url, String password) {
        this.url = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        this.password = password;
    }

    public Closeable sendConnectRequest(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction, Supplier<RemoteDevClient.SyncResult> changeRequestFunction) {
        try {
            return new Session(initialState, initialConnectFunction, changeRequestFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class Session
    implements Closeable,
    Runnable {
        private String sessionId = null;
        private int currentSessionCounter = 1;
        private final RemoteDevState initialState;
        private final Function<Set<String>, Map<String, byte[]>> initialConnectFunction;
        private final Supplier<RemoteDevClient.SyncResult> changeRequestFunction;
        private volatile boolean closed;
        private final Thread httpThread;
        private final String url;
        private final URL devUrl;
        int errorCount;

        private Session(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction, Supplier<RemoteDevClient.SyncResult> changeRequestFunction) throws MalformedURLException {
            this.initialState = initialState;
            this.initialConnectFunction = initialConnectFunction;
            this.changeRequestFunction = changeRequestFunction;
            this.devUrl = new URL(HttpRemoteDevClient.this.url + "/dev");
            this.url = HttpRemoteDevClient.this.url;
            this.httpThread = new Thread((Runnable)this, "Remote dev client thread");
            this.httpThread.start();
        }

        private void sendData(Map.Entry<String, byte[]> entry, String session) throws IOException {
            HttpRemoteDevClient.this.log.info((Object)("Sending " + entry.getKey()));
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url + "/" + entry.getKey()).openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
            connection.addRequestProperty("X-Quarkus-Count", Integer.toString(this.currentSessionCounter));
            connection.addRequestProperty("X-Quarkus-Password", HashUtil.sha256((String)(HashUtil.sha256((byte[])entry.getValue()) + session + this.currentSessionCounter + HttpRemoteDevClient.this.password)));
            ++this.currentSessionCounter;
            connection.addRequestProperty("X-Quarkus-Session", session);
            connection.getOutputStream().write(entry.getValue());
            connection.getOutputStream().close();
            IoUtil.readBytes((InputStream)connection.getInputStream());
        }

        private String doConnect(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction) throws IOException {
            this.currentSessionCounter = 1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                out.writeObject(initialState);
            }
            byte[] initialData = baos.toByteArray();
            String dataHash = HashUtil.sha256((byte[])initialData);
            HttpURLConnection connection = (HttpURLConnection)new URL(this.url + "/connect").openConnection();
            connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
            connection.addRequestProperty("X-Quarkus-Password", HashUtil.sha256((String)(dataHash + HttpRemoteDevClient.this.password)));
            connection.setDoOutput(true);
            connection.getOutputStream().write(initialData);
            connection.getOutputStream().close();
            String session = connection.getHeaderField("X-Quarkus-Session");
            if (session == null) {
                throw new IOException("Server did not start a remote dev session");
            }
            String result = new String(IoUtil.readBytes((InputStream)connection.getInputStream()), StandardCharsets.UTF_8);
            HashSet<String> changed = new HashSet<String>();
            changed.addAll(Arrays.asList(result.split(";")));
            LinkedHashMap<String, byte[]> data = new LinkedHashMap<String, byte[]>(initialConnectFunction.apply(changed));
            byte[] lastFile = (byte[])data.remove("lib/deployment/deployment-class-path.dat");
            if (lastFile != null) {
                data.put("lib/deployment/deployment-class-path.dat", lastFile);
            }
            for (Map.Entry<String, byte[]> entry : data.entrySet()) {
                this.sendData(entry, session);
            }
            if (lastFile != null) {
                session = this.waitForRestart(initialState, initialConnectFunction);
            } else {
                HttpRemoteDevClient.this.log.info((Object)"Connected to remote server");
            }
            return session;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.httpThread.interrupt();
        }

        @Override
        public void run() {
            Throwable problem = null;
            while (!this.closed) {
                HttpURLConnection connection = null;
                try {
                    if (this.sessionId == null) {
                        this.sessionId = this.doConnect(this.initialState, this.initialConnectFunction);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try (ObjectOutputStream out = new ObjectOutputStream(baos);){
                        out.writeObject(problem);
                    }
                    connection = (HttpURLConnection)this.devUrl.openConnection();
                    connection.setRequestMethod("POST");
                    connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
                    connection.addRequestProperty("X-Quarkus-Count", Integer.toString(this.currentSessionCounter));
                    connection.addRequestProperty("X-Quarkus-Password", HashUtil.sha256((String)(HashUtil.sha256((byte[])baos.toByteArray()) + this.sessionId + this.currentSessionCounter + HttpRemoteDevClient.this.password)));
                    ++this.currentSessionCounter;
                    connection.addRequestProperty("X-Quarkus-Session", this.sessionId);
                    connection.setDoOutput(true);
                    connection.getOutputStream().write(baos.toByteArray());
                    IoUtil.readBytes((InputStream)connection.getInputStream());
                    int status = connection.getResponseCode();
                    if (status == 200) {
                        RemoteDevClient.SyncResult sync = this.changeRequestFunction.get();
                        problem = sync.getProblem();
                        for (Map.Entry<String, byte[]> entry : sync.getChangedFiles().entrySet()) {
                            this.sendData(entry, this.sessionId);
                        }
                        for (String string : sync.getRemovedFiles()) {
                            if (string.endsWith("META-INF/MANIFEST.MF") || string.contains("META-INF/maven") || !string.contains("/")) continue;
                            HttpRemoteDevClient.this.log.info((Object)("deleting " + string));
                            connection = (HttpURLConnection)new URL(this.url + "/" + string).openConnection();
                            connection.setRequestMethod("DELETE");
                            connection.addRequestProperty(HttpHeaders.CONTENT_TYPE.toString(), "application/quarkus-live-reload");
                            connection.addRequestProperty("X-Quarkus-Count", Integer.toString(this.currentSessionCounter));
                            connection.addRequestProperty("X-Quarkus-Password", HashUtil.sha256((String)(HashUtil.sha256((String)("/" + string)) + this.sessionId + this.currentSessionCounter + HttpRemoteDevClient.this.password)));
                            ++this.currentSessionCounter;
                            connection.addRequestProperty("X-Quarkus-Session", this.sessionId);
                            connection.getOutputStream().close();
                            IoUtil.readBytes((InputStream)connection.getInputStream());
                        }
                    } else if (status == 203) {
                        this.sessionId = this.doConnect(this.initialState, this.initialConnectFunction);
                    }
                    this.errorCount = 0;
                }
                catch (Throwable e) {
                    ++this.errorCount;
                    HttpRemoteDevClient.this.log.error((Object)"Remote dev request failed", e);
                    if (this.errorCount == 10) {
                        HttpRemoteDevClient.this.log.error((Object)"Connection failed after 10 retries, exiting");
                        return;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private String waitForRestart(RemoteDevState initialState, Function<Set<String>, Map<String, byte[]>> initialConnectFunction) {
            long timeout = System.currentTimeMillis() + 30000L;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (System.currentTimeMillis() < timeout) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
                    IoUtil.readBytes((InputStream)connection.getInputStream());
                    return this.doConnect(initialState, initialConnectFunction);
                }
                catch (IOException iOException) {
                }
            }
            throw new RuntimeException("Could not connect to remote side after restart");
        }
    }
}

