/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.devmode.ArcEndpointRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;

public class ArcEndpointProcessor {
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    void registerRoutes(HttpBuildTimeConfig httpConfig, ArcConfig arcConfig, ArcEndpointRecorder recorder, BuildProducer<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints) {
        String basePath = httpConfig.consolePath + "/arc";
        String beansPath = basePath + "/beans";
        String removedBeansPath = basePath + "/removed-beans";
        String observersPath = basePath + "/observers";
        routes.produce((BuildItem)new RouteBuildItem(basePath, (Handler<RoutingContext>)recorder.createSummaryHandler(this.getConfigProperties(arcConfig))));
        routes.produce((BuildItem)new RouteBuildItem(beansPath, (Handler<RoutingContext>)recorder.createBeansHandler()));
        routes.produce((BuildItem)new RouteBuildItem(removedBeansPath, (Handler<RoutingContext>)recorder.createRemovedBeansHandler()));
        routes.produce((BuildItem)new RouteBuildItem(observersPath, (Handler<RoutingContext>)recorder.createObserversHandler()));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(basePath));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(beansPath));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(removedBeansPath));
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(observersPath));
    }

    private Map<String, String> getConfigProperties(ArcConfig arcConfig) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("quarkus.arc.remove-unused-beans", arcConfig.removeUnusedBeans);
        props.put("quarkus.arc.unremovable-types", arcConfig.unremovableTypes.map(Object::toString).orElse(""));
        props.put("quarkus.arc.detect-unused-false-positives", "" + arcConfig.detectUnusedFalsePositives);
        props.put("quarkus.arc.transform-unproxyable-classes", "" + arcConfig.transformUnproxyableClasses);
        props.put("quarkus.arc.auto-inject-fields", "" + arcConfig.autoInjectFields);
        props.put("quarkus.arc.auto-producer-methods", "" + arcConfig.autoProducerMethods);
        props.put("quarkus.arc.selected-alternatives", "" + arcConfig.selectedAlternatives.map(Object::toString).orElse(""));
        props.put("quarkus.arc.exclude-types", "" + arcConfig.excludeTypes.map(Object::toString).orElse(""));
        props.put("quarkus.arc.config-properties-default-naming-strategy", "" + arcConfig.configPropertiesDefaultNamingStrategy.toString());
        return props;
    }
}

