/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.runtime.StaticResourcesRecorder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class StaticResourcesProcessor {
    @BuildStep
    void collectStaticResources(Capabilities capabilities, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<StaticResourcesBuildItem> staticResources) throws Exception {
        if (capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        Set<String> paths = this.getClasspathResources(applicationArchivesBuildItem);
        if (!paths.isEmpty()) {
            staticResources.produce((BuildItem)new StaticResourcesBuildItem(paths));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(Optional<StaticResourcesBuildItem> staticResources, StaticResourcesRecorder recorder) throws Exception {
        if (staticResources.isPresent()) {
            recorder.staticInit(staticResources.get().getPaths());
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(Optional<StaticResourcesBuildItem> staticResources, StaticResourcesRecorder recorder, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, BuildProducer<DefaultRouteBuildItem> defaultRoutes) throws Exception {
        if (staticResources.isPresent()) {
            defaultRoutes.produce((BuildItem)new DefaultRouteBuildItem(recorder.start()));
        }
    }

    private Set<String> getClasspathResources(ApplicationArchivesBuildItem applicationArchivesBuildItem) throws Exception {
        HashSet<String> knownPaths = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            Path resource2 = i.getChildPath("META-INF/resources");
            if (resource2 == null || !Files.exists(resource2, new LinkOption[0])) continue;
            this.collectKnownPaths(resource2, knownPaths);
        }
        ClassPathUtils.consumeAsPaths((String)"META-INF/resources", resource -> this.collectKnownPaths((Path)resource, (Set<String>)knownPaths));
        return knownPaths;
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownPaths) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p, BasicFileAttributes attrs) throws IOException {
                    String simpleName = p.getFileName().toString();
                    Object file = resource.relativize(p).toString();
                    if (simpleName.equals("index.html") || simpleName.equals("index.htm")) {
                        Path parent = resource.relativize(p).getParent();
                        if (parent == null) {
                            knownPaths.add("/");
                        } else {
                            Object parentString = parent.toString();
                            if (!((String)parentString).startsWith("/")) {
                                parentString = "/" + (String)parentString;
                            }
                            knownPaths.add((String)parentString + "/");
                        }
                    }
                    if (!((String)file).startsWith("/")) {
                        file = "/" + (String)file;
                    }
                    file = ((String)file).replace('\\', '/');
                    knownPaths.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final class StaticResourcesBuildItem
    extends SimpleBuildItem {
        private final Set<String> paths;

        public StaticResourcesBuildItem(Set<String> paths) {
            this.paths = paths;
        }

        public Set<String> getPaths() {
            return this.paths;
        }
    }
}

