/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.LogHandlerBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.recording.BytecodeRecorderImpl;
import io.quarkus.deployment.util.ArtifactInfoUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualServerChannel;
import io.quarkus.qute.Engine;
import io.quarkus.qute.EngineBuilder;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Expression;
import io.quarkus.qute.HtmlEscaper;
import io.quarkus.qute.NamespaceResolver;
import io.quarkus.qute.RawString;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.ResultMapper;
import io.quarkus.qute.Results;
import io.quarkus.qute.SectionHelperFactory;
import io.quarkus.qute.TemplateException;
import io.quarkus.qute.TemplateLocator;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.UserTagSectionHelper;
import io.quarkus.qute.ValueResolver;
import io.quarkus.qute.ValueResolvers;
import io.quarkus.qute.Variant;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.TemplateHtmlBuilder;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.ConfiguredPathInfo;
import io.quarkus.vertx.http.deployment.devmode.console.DevConsole;
import io.quarkus.vertx.http.deployment.devmode.console.DevConsoleHttpHandler;
import io.quarkus.vertx.http.deployment.devmode.console.DevTemplatePathBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.DevTemplateVariantsBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.DevUIConfig;
import io.quarkus.vertx.http.deployment.devmode.console.FlashScopeHandler;
import io.quarkus.vertx.http.deployment.devmode.console.JsonObjectValueResolver;
import io.quarkus.vertx.http.deployment.devmode.console.MultiMapValueResolver;
import io.quarkus.vertx.http.deployment.devmode.console.OpenIdeHandler;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleFilter;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleRecorder;
import io.quarkus.vertx.http.runtime.devmode.RedirectHandler;
import io.quarkus.vertx.http.runtime.devmode.RuntimeDevConsoleRoute;
import io.quarkus.vertx.http.runtime.logstream.HistoryHandler;
import io.quarkus.vertx.http.runtime.logstream.LogStreamRecorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.Http1xServerConnection;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevConsoleProcessor {
    private static final Logger log = Logger.getLogger(DevConsoleProcessor.class);
    private static final String STATIC_RESOURCES_PATH = "dev-static/";
    private static final Object EMPTY = new Object();
    private static final String[] suffixes = new String[]{"html", "txt"};
    protected static volatile ServerBootstrap virtualBootstrap;
    protected static volatile Vertx devConsoleVertx;
    protected static volatile Channel channel;
    static Router router;
    static Router mainRouter;

    public static void initializeVirtual() {
        if (virtualBootstrap != null) {
            return;
        }
        devConsoleVertx = Vertx.vertx();
        final VertxInternal vertx = (VertxInternal)devConsoleVertx;
        QuarkusClassLoader ccl = (QuarkusClassLoader)DevConsoleProcessor.class.getClassLoader();
        ccl.addCloseTask(new Runnable(){

            @Override
            public void run() {
                virtualBootstrap = null;
                if (channel != null) {
                    try {
                        channel.close().sync();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("failed to close virtual http");
                    }
                }
                if (devConsoleVertx != null) {
                    devConsoleVertx.close();
                    devConsoleVertx = null;
                }
            }
        });
        virtualBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)virtualBootstrap.group(vertx.getEventLoopGroup()).channel(VirtualServerChannel.class)).handler((ChannelHandler)new ChannelInitializer<VirtualServerChannel>(){

            public void initChannel(VirtualServerChannel ch) throws Exception {
            }
        })).childHandler((ChannelHandler)new ChannelInitializer<VirtualChannel>(){

            public void initChannel(VirtualChannel ch) throws Exception {
                EventLoopContext context = vertx.createEventLoopContext();
                VertxHandler handler = VertxHandler.create(chctx -> {
                    Http1xServerConnection connection = new Http1xServerConnection(() -> context, null, new HttpServerOptions(), chctx, (ContextInternal)context, "localhost", null);
                    connection.handler((Handler)new Handler<HttpServerRequest>(){

                        public void handle(HttpServerRequest event) {
                            mainRouter.handle((Object)event);
                        }
                    });
                    return connection;
                });
                ch.pipeline().addLast("handler", (ChannelHandler)handler);
            }
        });
        try {
            ChannelFuture future = virtualBootstrap.bind((SocketAddress)DevConsoleHttpHandler.QUARKUS_DEV_CONSOLE);
            future.sync();
            channel = future.channel();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed to bind virtual http");
        }
    }

    protected static void newRouter(Engine engine, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem) {
        String httpRootPath = nonApplicationRootPathBuildItem.getNormalizedHttpRootPath();
        String frameworkRootPath = nonApplicationRootPathBuildItem.getNonApplicationRootPath();
        Handler<RoutingContext> errorHandler = new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                String message = "Dev console request failed";
                log.error((Object)message, event.failure());
                event.response().headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=utf-8");
                event.response().end(new TemplateHtmlBuilder("Internal Server Error", message, message).stack(event.failure()).toString());
            }
        };
        router = Router.router((Vertx)devConsoleVertx);
        router.errorHandler(500, (Handler)errorHandler);
        router.route().order(Integer.MIN_VALUE).handler((Handler)new FlashScopeHandler());
        router.route().method(HttpMethod.GET).order(-2147483647).handler((Handler)new DevConsole(engine, httpRootPath, frameworkRootPath));
        mainRouter = Router.router((Vertx)devConsoleVertx);
        mainRouter.errorHandler(500, (Handler)errorHandler);
        mainRouter.route(nonApplicationRootPathBuildItem.resolvePath("dev*")).subRouter(router);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public ServiceStartBuildItem buildTimeTemplates(List<DevConsoleTemplateInfoBuildItem> items, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashMap<String, Map> results = new HashMap<String, Map>();
        for (DevConsoleTemplateInfoBuildItem i : items) {
            Map.Entry groupAndArtifact = i.groupIdAndArtifactId(curateOutcomeBuildItem);
            Map map = results.computeIfAbsent((String)groupAndArtifact.getKey() + "." + (String)groupAndArtifact.getValue(), s -> new HashMap());
            map.put(i.getName(), i.getObject());
        }
        DevConsoleManager.setTemplateInfo(results);
        return null;
    }

    @BuildStep
    DevTemplateVariantsBuildItem collectTemplateVariants(List<DevTemplatePathBuildItem> templatePaths) throws IOException {
        Set allPaths = templatePaths.stream().map(DevTemplatePathBuildItem::getPath).collect(Collectors.toSet());
        HashMap<String, List<String>> baseToVariants = new HashMap<String, List<String>>();
        for (String path : allPaths) {
            int idx = path.lastIndexOf(46);
            if (idx == -1) continue;
            String base = path.substring(0, idx);
            ArrayList<String> variants = (ArrayList<String>)baseToVariants.get(base);
            if (variants == null) {
                variants = new ArrayList<String>();
                baseToVariants.put(base, variants);
            }
            variants.add(path);
        }
        return new DevTemplateVariantsBuildItem(baseToVariants);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeTemplates(List<DevConsoleRuntimeTemplateInfoBuildItem> items, DevConsoleRecorder recorder, List<ServiceStartBuildItem> gate) {
        for (DevConsoleRuntimeTemplateInfoBuildItem i : items) {
            recorder.addInfo(i.getGroupId(), i.getArtifactId(), i.getName(), i.getObject());
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public HistoryHandlerBuildItem handler(BuildProducer<LogHandlerBuildItem> logHandlerBuildItemBuildProducer, LogStreamRecorder recorder, DevUIConfig devUiConfig) {
        RuntimeValue handler = recorder.handler(devUiConfig.historySize);
        logHandlerBuildItemBuildProducer.produce((BuildItem)new LogHandlerBuildItem(handler));
        return new HistoryHandlerBuildItem((RuntimeValue<Optional<HistoryHandler>>)handler);
    }

    @Consume(value=LoggingSetupBuildItem.class)
    @BuildStep(onlyIf={IsDevelopment.class})
    public ServiceStartBuildItem setupDeploymentSideHandling(List<DevTemplatePathBuildItem> devTemplatePaths, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildSystemTargetBuildItem buildSystemTargetBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, List<RouteBuildItem> allRoutes, List<DevConsoleRouteBuildItem> routes, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return null;
        }
        DevConsoleProcessor.initializeVirtual();
        Engine quteEngine = this.buildEngine(devTemplatePaths, allRoutes, buildSystemTargetBuildItem, effectiveIdeBuildItem, nonApplicationRootPathBuildItem, launchModeBuildItem);
        DevConsoleProcessor.newRouter(quteEngine, nonApplicationRootPathBuildItem);
        for (DevConsoleRouteBuildItem i : routes) {
            Map.Entry groupAndArtifact = i.groupIdAndArtifactId(curateOutcomeBuildItem);
            if (i.getHandler() instanceof BytecodeRecorderImpl.ReturnedProxy) continue;
            router.route(HttpMethod.valueOf((String)i.getMethod()), "/" + (String)groupAndArtifact.getKey() + "." + (String)groupAndArtifact.getValue() + "/" + i.getPath()).handler(i.getHandler());
        }
        return null;
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=LoggingSetupBuildItem.class)
    @BuildStep(onlyIf={IsDevelopment.class})
    public void setupDevConsoleRoutes(DevConsoleRecorder recorder, LogStreamRecorder logStreamRecorder, List<DevConsoleRouteBuildItem> routes, CurateOutcomeBuildItem curateOutcomeBuildItem, HistoryHandlerBuildItem historyHandlerBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routeBuildItemBuildProducer, LiveReloadBuildItem liveReloadBuildItem) throws IOException {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return;
        }
        AppArtifact devConsoleResourcesArtifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)"io.quarkus", (String)"quarkus-vertx-http-deployment");
        Path devConsoleStaticResourcesDeploymentPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchModeBuildItem, (AppArtifact)devConsoleResourcesArtifact, (String)STATIC_RESOURCES_PATH);
        routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev/resources/*").handler(recorder.devConsoleHandler(devConsoleStaticResourcesDeploymentPath.toString(), (ShutdownContext)shutdownContext))).build());
        routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev/logstream").handler(logStreamRecorder.websocketHandler(historyHandlerBuildItem.value))).build());
        for (DevConsoleRouteBuildItem i : routes) {
            Map.Entry groupAndArtifact = i.groupIdAndArtifactId(curateOutcomeBuildItem);
            if (!(i.getHandler() instanceof BytecodeRecorderImpl.ReturnedProxy)) continue;
            routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().routeFunction("dev/" + (String)groupAndArtifact.getKey() + "." + (String)groupAndArtifact.getValue() + "/" + i.getPath(), (Consumer)new RuntimeDevConsoleRoute(i.getMethod()))).handler(i.getHandler())).build());
        }
        DevConsoleManager.registerHandler((Consumer)new DevConsoleHttpHandler());
        routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev/*").handler((Handler)new DevConsoleFilter())).build());
        routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev").displayOnNotFoundPage("Dev UI").handler((Handler)new RedirectHandler())).build());
    }

    @BuildStep
    void builder(Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, BuildProducer<DevConsoleRouteBuildItem> producer) {
        if (effectiveIdeBuildItem.isPresent()) {
            producer.produce((BuildItem)new DevConsoleRouteBuildItem("openInIDE", "POST", (Handler)new OpenIdeHandler(effectiveIdeBuildItem.get().getIde())));
        }
    }

    private Engine buildEngine(List<DevTemplatePathBuildItem> devTemplatePaths, List<RouteBuildItem> allRoutes, BuildSystemTargetBuildItem buildSystemTargetBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem) {
        EngineBuilder builder = Engine.builder().addDefaults();
        builder.addResultMapper((ResultMapper)new HtmlEscaper());
        builder.addValueResolver((ValueResolver)new ReflectionValueResolver()).addValueResolver((ValueResolver)new JsonObjectValueResolver()).addValueResolver((ValueResolver)new MultiMapValueResolver()).addValueResolver(ValueResolvers.rawResolver()).addNamespaceResolver(NamespaceResolver.builder((String)"ideInfo").resolve((Function)new IdeInfoContextFunction(buildSystemTargetBuildItem, effectiveIdeBuildItem, launchModeBuildItem)).build()).addNamespaceResolver(NamespaceResolver.builder((String)"info").resolve(ctx -> {
            String ext = DevConsole.currentExtension.get();
            if (ext == null) {
                return Results.Result.NOT_FOUND;
            }
            Map map = (Map)DevConsoleManager.getTemplateInfo().get(ext);
            if (map == null) {
                return Results.Result.NOT_FOUND;
            }
            Object result = map.get(ctx.getName());
            return result == null ? Results.Result.NOT_FOUND : result;
        }).build());
        HashMap<String, String> resolvedPaths = new HashMap<String, String>();
        for (Object item : allRoutes) {
            ConfiguredPathInfo resolvedPathBuildItem = item.getDevConsoleResolvedPath();
            if (resolvedPathBuildItem == null) continue;
            resolvedPaths.put(resolvedPathBuildItem.getName(), resolvedPathBuildItem.getEndpointPath(nonApplicationRootPathBuildItem));
        }
        builder.addNamespaceResolver(NamespaceResolver.builder((String)"config").resolveAsync(ctx -> {
            List params = ctx.getParams();
            if (params.size() != 1 || !ctx.getName().equals("property") && !ctx.getName().equals("http-path")) {
                return Results.NOT_FOUND;
            }
            if (ctx.getName().equals("http-path")) {
                return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> {
                    String value = (String)resolvedPaths.get(propertyName.toString());
                    return CompletableFuture.completedFuture(value != null ? value : Results.Result.NOT_FOUND);
                });
            }
            return ctx.evaluate((Expression)params.get(0)).thenCompose(propertyName -> {
                Optional val = ConfigProvider.getConfig().getOptionalValue(propertyName.toString(), String.class);
                return CompletableFuture.completedFuture(val.isPresent() ? val.get() : Results.Result.NOT_FOUND);
            });
        }).build());
        builder.addValueResolver((ValueResolver)new JavaDocResolver());
        HashMap<String, String> templates = new HashMap<String, String>();
        for (DevTemplatePathBuildItem devTemplatePath : devTemplatePaths) {
            templates.put(devTemplatePath.getPath(), devTemplatePath.getContents());
            if (!devTemplatePath.isTag()) continue;
            String tagName = devTemplatePath.getTagName();
            builder.addSectionHelper((SectionHelperFactory)new UserTagSectionHelper.Factory(tagName, devTemplatePath.getPath()));
        }
        builder.addLocator(id -> DevConsoleProcessor.locateTemplate(id, templates));
        builder.addResultMapper(new ResultMapper(){

            public int getPriority() {
                return 10;
            }

            public boolean appliesTo(TemplateNode.Origin origin, Object result) {
                return result.equals(Results.Result.NOT_FOUND);
            }

            public String map(Object result, Expression expression) {
                TemplateNode.Origin origin = expression.getOrigin();
                throw new TemplateException(origin, String.format("Property not found in expression {%s} in template %s on line %s", expression.toOriginalString(), origin.getTemplateId(), origin.getLine()));
            }
        });
        builder.addResultMapper(new ResultMapper(){

            public int getPriority() {
                return 10;
            }

            public boolean appliesTo(TemplateNode.Origin origin, Object result) {
                return result.equals(EMPTY);
            }

            public String map(Object result, Expression expression) {
                return "<<unset>>";
            }
        });
        Engine engine = builder.build();
        for (DevTemplatePathBuildItem devTemplatePath : devTemplatePaths) {
            if (devTemplatePath.isTag()) continue;
            engine.getTemplate(devTemplatePath.getPath());
        }
        return engine;
    }

    private static Optional<TemplateLocator.TemplateLocation> locateTemplate(String id, Map<String, String> templates) {
        String template = templates.get(id);
        if (template == null) {
            String suffix;
            String[] stringArray = suffixes;
            int n = stringArray.length;
            for (int i = 0; i < n && (template = templates.get(id = (String)id + "." + (suffix = stringArray[i]))) == null; ++i) {
            }
        }
        if (template == null) {
            return Optional.empty();
        }
        final String templateName = id;
        final String finalTemplate = template;
        return Optional.of(new TemplateLocator.TemplateLocation(){

            public Reader read() {
                return new StringReader(finalTemplate);
            }

            public Optional<Variant> getVariant() {
                int dotIdx;
                Variant variant = null;
                String fileName = templateName;
                int slashIdx = fileName.lastIndexOf(47);
                if (slashIdx != -1) {
                    fileName = fileName.substring(slashIdx, fileName.length());
                }
                if ((dotIdx = fileName.lastIndexOf(46)) != -1) {
                    String suffix = fileName.substring(dotIdx + 1, fileName.length());
                    if (suffix.equalsIgnoreCase("json")) {
                        variant = Variant.forContentType((String)"application/json");
                    } else {
                        String contentType = URLConnection.getFileNameMap().getContentTypeFor(fileName);
                        if (contentType != null) {
                            variant = Variant.forContentType((String)contentType);
                        }
                    }
                }
                return Optional.ofNullable(variant);
            }
        });
    }

    @BuildStep
    void collectTemplates(BuildProducer<DevTemplatePathBuildItem> devTemplatePaths) {
        try {
            ClassLoader classLoader = DevConsoleProcessor.class.getClassLoader();
            Enumeration<URL> devTemplateURLs = classLoader.getResources("/dev-templates");
            while (devTemplateURLs.hasMoreElements()) {
                String devTemplatesURL = devTemplateURLs.nextElement().toExternalForm();
                if (!devTemplatesURL.startsWith("jar:file:") || !devTemplatesURL.endsWith("!/dev-templates")) continue;
                String jarPath = devTemplatesURL.substring(9, devTemplatesURL.length() - 15);
                if (File.separatorChar == '\\') {
                    jarPath = jarPath.substring(1).replace('/', '\\');
                }
                FileSystem fs = FileSystems.newFileSystem(Paths.get(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()), new String[0]), classLoader);
                try {
                    this.scanTemplates(fs, devTemplatePaths);
                }
                finally {
                    if (fs == null) continue;
                    fs.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void scanTemplates(FileSystem fs, BuildProducer<DevTemplatePathBuildItem> devTemplatePaths) throws IOException {
        Map.Entry entry = ArtifactInfoUtil.groupIdAndArtifactId((FileSystem)fs);
        if (entry == null) {
            throw new RuntimeException("Artifact at " + fs + " is missing pom metadata");
        }
        Object prefix = ((String)entry.getKey()).equals("io.quarkus") && ((String)entry.getValue()).equals("quarkus-vertx-http") ? "" : (String)entry.getKey() + "." + (String)entry.getValue() + "/";
        for (Path root : fs.getRootDirectories()) {
            final Path devTemplatesPath = fs.getPath("/dev-templates", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((String)prefix, devTemplatePaths){
                final /* synthetic */ String val$prefix;
                final /* synthetic */ BuildProducer val$devTemplatePaths;
                {
                    this.val$prefix = string;
                    this.val$devTemplatePaths = buildProducer;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.toString().equals("/") || dir.startsWith(devTemplatesPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String contents = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                    String relativePath = devTemplatesPath.relativize(file).toString();
                    Object correctedPath = relativePath.startsWith("tags/") ? relativePath : this.val$prefix + relativePath;
                    this.val$devTemplatePaths.produce((BuildItem)new DevTemplatePathBuildItem((String)correctedPath, contents));
                    return super.visitFile(file, attrs);
                }
            });
        }
    }

    private static class IdeInfoContextFunction
    implements Function<EvalContext, Object> {
        private static final String[] SUPPORTED_LANGS = new String[]{"java", "kotlin"};
        private final Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem;
        private final Path srcMainPath;
        private final boolean disable;

        public IdeInfoContextFunction(BuildSystemTargetBuildItem buildSystemTargetBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, LaunchModeBuildItem launchModeBuildItem) {
            this.effectiveIdeBuildItem = effectiveIdeBuildItem;
            this.srcMainPath = buildSystemTargetBuildItem.getOutputDirectory().getParent().resolve("src").resolve("main");
            this.disable = launchModeBuildItem.getDevModeType().orElse(DevModeType.LOCAL) != DevModeType.LOCAL;
        }

        @Override
        public Object apply(EvalContext ctx) {
            String ctxName = ctx.getName();
            if (ctxName.equals("sourcePackages")) {
                if (this.disable) {
                    return Collections.emptyList();
                }
                HashMap<String, List<String>> sourcePackagesByLang = new HashMap<String, List<String>>();
                for (String lang : SUPPORTED_LANGS) {
                    List<String> packages = this.sourcePackagesForLang(this.srcMainPath, lang);
                    if (packages.isEmpty()) continue;
                    sourcePackagesByLang.put(lang, packages);
                }
                return sourcePackagesByLang;
            }
            if (this.disable) {
                return EMPTY;
            }
            switch (ctxName) {
                case "srcMainPath": {
                    return this.srcMainPath.toAbsolutePath().toString();
                }
                case "ideLinkType": {
                    if (!this.effectiveIdeBuildItem.isPresent()) {
                        return "none";
                    }
                    return this.effectiveIdeBuildItem.get().getIde().equals((Object)Ide.VSCODE) ? "client" : "server";
                }
                case "ideClientLinkFormat": {
                    if (!this.effectiveIdeBuildItem.isPresent()) {
                        return "unused";
                    }
                    if (this.effectiveIdeBuildItem.get().getIde() == Ide.VSCODE) {
                        return "vscode://file/{0}:{1}";
                    }
                    return "unused";
                }
                case "ideServerLinkEndpoint": {
                    if (!this.effectiveIdeBuildItem.isPresent()) {
                        return "unused";
                    }
                    return "/io.quarkus.quarkus-vertx-http/openInIDE";
                }
            }
            return Results.Result.NOT_FOUND;
        }

        private List<String> sourcePackagesForLang(Path srcMainPath, String lang) {
            Path langPath = srcMainPath.resolve(lang);
            if (!Files.exists(langPath, new LinkOption[0])) {
                return Collections.emptyList();
            }
            File[] rootFiles = langPath.toFile().listFiles();
            ArrayList<Path> rootPackages = new ArrayList<Path>(1);
            if (rootFiles != null) {
                for (File rootFile : rootFiles) {
                    if (!rootFile.isDirectory()) continue;
                    rootPackages.add(rootFile.toPath());
                }
            }
            if (rootPackages.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>(rootPackages.size());
            for (Path rootPackage : rootPackages) {
                ArrayList<String> paths = new ArrayList<String>();
                DetectPackageFileVisitor simpleFileVisitor = new DetectPackageFileVisitor(paths);
                try {
                    Files.walkFileTree(rootPackage, simpleFileVisitor);
                    if (paths.isEmpty()) continue;
                    String commonPath = this.commonPath(paths);
                    String rootPackageStr = commonPath.replace(langPath.toAbsolutePath().toString(), "").replace(File.separator, ".");
                    if (rootPackageStr.startsWith(".")) {
                        rootPackageStr = rootPackageStr.substring(1);
                    }
                    if (rootPackageStr.endsWith(".")) {
                        rootPackageStr = rootPackageStr.substring(0, rootPackageStr.length() - 1);
                    }
                    result.add(rootPackageStr);
                }
                catch (IOException e) {
                    log.debug((Object)"Unable to determine the sources directories", (Throwable)e);
                }
            }
            return result;
        }

        private String commonPath(List<String> paths) {
            Object commonPath = "";
            ArrayList<String[]> dirs = new ArrayList<String[]>(paths.size());
            for (int i = 0; i < paths.size(); ++i) {
                dirs.add(i, paths.get(i).split(Pattern.quote(File.separator)));
            }
            for (int j = 0; j < ((String[])dirs.get(0)).length; ++j) {
                String thisDir = ((String[])dirs.get(0))[j];
                boolean allMatched = true;
                for (int i = 1; i < dirs.size() && allMatched; ++i) {
                    if (((String[])dirs.get(i)).length < j) {
                        allMatched = false;
                        break;
                    }
                    allMatched = ((String[])dirs.get(i))[j].equals(thisDir);
                }
                if (!allMatched) break;
                commonPath = (String)commonPath + thisDir + File.separator;
            }
            return commonPath;
        }
    }

    private static class DetectPackageFileVisitor
    extends SimpleFileVisitor<Path> {
        private final List<String> paths;

        public DetectPackageFileVisitor(List<String> paths) {
            this.paths = paths;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            boolean hasRegularFiles = false;
            File[] files = dir.toFile().listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isFile()) continue;
                    hasRegularFiles = true;
                    break;
                }
            }
            if (hasRegularFiles) {
                this.paths.add(dir.toAbsolutePath().toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }

    public static final class HistoryHandlerBuildItem
    extends SimpleBuildItem {
        final RuntimeValue<Optional<HistoryHandler>> value;

        public HistoryHandlerBuildItem(RuntimeValue<Optional<HistoryHandler>> value) {
            this.value = value;
        }
    }

    public static class JavaDocResolver
    implements ValueResolver {
        private final Pattern codePattern = Pattern.compile("(\\{@code )([^}]+)(\\})");
        private final Pattern linkPattern = Pattern.compile("(\\{@link )([^}]+)(\\})");

        public boolean appliesTo(EvalContext context) {
            return context.getBase() instanceof String && context.getName().equals("fmtJavadoc");
        }

        public CompletionStage<Object> resolve(EvalContext context) {
            String val = context.getBase().toString();
            val = this.codePattern.matcher(val).replaceAll("<code>$2</code>");
            val = this.linkPattern.matcher(val).replaceAll("<code>$2</code>");
            val = val.replace("@see", "<br><strong>@see</strong>").replace("@deprecated", "<br><strong>@deprecated</strong>");
            return CompletableFuture.completedFuture(new RawString(val));
        }
    }
}

