/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.tests;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestListenerBuildItem;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.console.ContinuousTestingWebSocketListener;
import io.quarkus.vertx.http.deployment.devmode.tests.ClassResult;
import io.quarkus.vertx.http.deployment.devmode.tests.SuiteResult;
import io.quarkus.vertx.http.deployment.devmode.tests.TestStatus;
import io.quarkus.vertx.http.runtime.devmode.DevConsoleRecorder;
import io.quarkus.vertx.http.runtime.devmode.Json;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TestsProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleTemplateInfoBuildItem results(LaunchModeBuildItem launchModeBuildItem) {
        Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleTemplateInfoBuildItem("tests", ts.get());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    public void setupTestRoutes(DevConsoleRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchModeBuildItem, BuildProducer<RouteBuildItem> routeBuildItemBuildProducer, BuildProducer<TestListenerBuildItem> testListenerBuildItemBuildProducer) throws IOException {
        if (launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL) {
            return;
        }
        if (TestSupport.instance().isPresent()) {
            routeBuildItemBuildProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev/test").handler(recorder.continousTestHandler())).build());
            testListenerBuildItemBuildProducer.produce((BuildItem)new TestListenerBuildItem((TestListener)new ContinuousTestingWebSocketListener()));
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem handleTestStatus(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/status", "GET", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                TestsProcessor.this.jsonResponse(event);
                TestSupport.RunStatus status = ((TestSupport)ts.get()).getStatus();
                TestStatus testStatus = new TestStatus();
                testStatus.setLastRun(status.getLastRun());
                testStatus.setRunning(status.getRunning());
                if (status.getLastRun() > 0L) {
                    TestRunResults result = ((TestSupport)ts.get()).getResults();
                    testStatus.setTestsFailed(result.getCurrentFailedCount());
                    testStatus.setTestsPassed(result.getCurrentPassedCount());
                    testStatus.setTestsSkipped(result.getCurrentSkippedCount());
                    testStatus.setTestsRun(result.getFailedCount() + result.getPassedCount());
                    testStatus.setTotalTestsFailed(result.getFailedCount());
                    testStatus.setTotalTestsPassed(result.getPassedCount());
                    testStatus.setTotalTestsSkipped(result.getSkippedCount());
                }
                event.response().end(JsonObject.mapFrom((Object)testStatus).encode());
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void toggleTestRunner(LaunchModeBuildItem launchModeBuildItem, BuildProducer<DevConsoleRouteBuildItem> routeProducer) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return;
        }
        routeProducer.produce((BuildItem)new DevConsoleRouteBuildItem("tests/toggle", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (((TestSupport)ts.get()).isStarted()) {
                    ((TestSupport)ts.get()).stop();
                } else {
                    ((TestSupport)ts.get()).start();
                }
                Json.JsonObjectBuilder object = Json.object();
                object.put("running", Boolean.valueOf(((TestSupport)ts.get()).isRunning()));
                event.response().putHeader("Content-Type", "application/json; charset=utf-8").end(object.build());
            }
        }));
        routeProducer.produce((BuildItem)new DevConsoleRouteBuildItem("tests/toggle-broken-only", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                boolean brokenOnlyMode = ((TestSupport)ts.get()).toggleBrokenOnlyMode();
                Json.JsonObjectBuilder object = Json.object();
                object.put("brokenOnlyMode", Boolean.valueOf(brokenOnlyMode));
                event.response().putHeader("Content-Type", "application/json; charset=utf-8").end(object.build());
            }
        }));
    }

    private boolean testsDisabled(LaunchModeBuildItem launchModeBuildItem, Optional<TestSupport> ts) {
        return !ts.isPresent() || launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem runAllTests(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/runall", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                ((TestSupport)ts.get()).runAllTests();
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem runFailedTests(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/toggle-test-output", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                boolean isTestOutput = ((TestSupport)ts.get()).toggleTestOutput();
                Json.JsonObjectBuilder object = Json.object();
                object.put("isTestOutput", Boolean.valueOf(isTestOutput));
                event.response().putHeader("Content-Type", "application/json; charset=utf-8").end(object.build());
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem toggleTestOutput(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/runfailed", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                ((TestSupport)ts.get()).runFailedTests();
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem printfailures(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/printfailures", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                ((TestSupport)ts.get()).printFullResults();
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem toggleInstrumentation(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/toggle-instrumentation", "POST", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                boolean instrumentationEnabled = ((TestSupport)ts.get()).toggleInstrumentation();
                Json.JsonObjectBuilder object = Json.object();
                object.put("instrumentationEnabled", Boolean.valueOf(instrumentationEnabled));
                event.response().putHeader("Content-Type", "application/json; charset=utf-8").end(object.build());
            }
        });
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    DevConsoleRouteBuildItem handleTestResult(LaunchModeBuildItem launchModeBuildItem) {
        final Optional ts = TestSupport.instance();
        if (this.testsDisabled(launchModeBuildItem, ts)) {
            return null;
        }
        return new DevConsoleRouteBuildItem("tests/result", "GET", (Handler)new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                TestRunResults testRunResults = ((TestSupport)ts.get()).getResults();
                if (testRunResults == null) {
                    event.response().setStatusCode(204).end();
                } else {
                    TestsProcessor.this.jsonResponse(event);
                    HashMap<String, ClassResult> results = new HashMap<String, ClassResult>();
                    for (Map.Entry entry : testRunResults.getResults().entrySet()) {
                        results.put((String)entry.getKey(), new ClassResult((TestClassResult)entry.getValue()));
                    }
                    SuiteResult result = new SuiteResult(results);
                    event.response().end(JsonObject.mapFrom((Object)result).encode());
                }
            }
        });
    }

    public MultiMap jsonResponse(RoutingContext event) {
        return event.response().headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8");
    }
}

