/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.vertx.http.runtime.filters.Filter;
import io.quarkus.vertx.http.runtime.filters.Filters;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public final class FilterBuildItem
extends MultiBuildItem {
    public static final int CORS = 300;
    public static final int AUTHENTICATION = 200;
    public static final int AUTHORIZATION = 100;
    private final Handler<RoutingContext> handler;
    private final int priority;
    private final boolean isFailureHandler;

    public FilterBuildItem(Handler<RoutingContext> handler, int priority) {
        this.handler = handler;
        this.checkPriority(priority);
        this.priority = priority;
        this.isFailureHandler = false;
    }

    public FilterBuildItem(Handler<RoutingContext> handler, int priority, boolean isFailureHandler) {
        this.handler = handler;
        this.checkPriority(priority);
        this.priority = priority;
        this.isFailureHandler = isFailureHandler;
    }

    private void checkPriority(int priority) {
        if (priority < 0) {
            throw new IllegalArgumentException("`priority` must be positive");
        }
    }

    public Handler<RoutingContext> getHandler() {
        return this.handler;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isFailureHandler() {
        return this.isFailureHandler;
    }

    public Filter toFilter() {
        return new Filters.SimpleFilter(this.handler, this.priority, this.isFailureHandler);
    }
}

