/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.devui.deployment.BuildTimeConstBuildItem;
import io.quarkus.devui.deployment.DevUIRoutesBuildItem;
import io.quarkus.devui.deployment.DevUIWebJarBuildItem;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.JsonRPCMethodsBuildItem;
import io.quarkus.devui.deployment.MvnpmBuildItem;
import io.quarkus.devui.deployment.extension.Codestart;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.deployment.spi.DevUIContent;
import io.quarkus.devui.runtime.DevUIRecorder;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.StaticContentBuildItem;
import io.quarkus.devui.spi.page.Card;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.MenuPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.QuteDataPageBuilder;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.qute.Qute;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class DevUIProcessor {
    private static final String DEVUI = "dev-ui";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String SPACE = " ";
    private static final String DASH = "-";
    private static final String DOUBLE_POINT = ":";
    private static final String DASH_DEPLOYMENT = "-deployment";
    private static final String SLASH_ALL = "/*";
    private static final String JSONRPC = "json-rpc-ws";
    private static final String CONSTRUCTOR = "<init>";
    private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
    private static final String JAR = "jar";
    private static final GACT UI_JAR = new GACT("io.quarkus", "quarkus-vertx-http-dev-ui-resources", null, "jar");
    private static final String YAML_FILE = "/META-INF/quarkus-extension.yaml";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ARTIFACT = "artifact";
    private static final String METADATA = "metadata";
    private static final String KEYWORDS = "keywords";
    private static final String SHORT_NAME = "short-name";
    private static final String GUIDE = "guide";
    private static final String CATEGORIES = "categories";
    private static final String STATUS = "status";
    private static final String BUILT_WITH = "built-with-quarkus-core";
    private static final String CONFIG = "config";
    private static final String EXTENSION_DEPENDENCIES = "extension-dependencies";
    private static final String CAPABILITIES = "capabilities";
    private static final String PROVIDES = "provides";
    private static final String UNLISTED = "unlisted";
    private static final String CODESTART = "codestart";
    private static final String LANGUAGES = "languages";
    private static final Logger log = Logger.getLogger(DevUIProcessor.class);
    private final Comparator sortingComparator = new Comparator<Extension>(){

        @Override
        public int compare(Extension t, Extension t1) {
            if (t.getGuide() != null && t1.getGuide() != null) {
                return t.getName().compareTo(t1.getName());
            }
            if (t.getGuide() == null) {
                return 1;
            }
            return -1;
        }
    };

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerDevUiHandlers(MvnpmBuildItem mvnpmBuildItem, List<DevUIRoutesBuildItem> devUIRoutesBuildItems, List<StaticContentBuildItem> staticContentBuildItems, BuildProducer<RouteBuildItem> routeProducer, DevUIRecorder recorder, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, ShutdownContextBuildItem shutdownContext) throws IOException {
        routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/json-rpc-ws").handler(recorder.communicationHandler())).build());
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            String route = devUIRoutesBuildItem.getPath();
            String path = nonApplicationRootPathBuildItem.resolvePath(route);
            Handler uihandler = recorder.uiHandler(devUIRoutesBuildItem.getFinalDestination(), path, devUIRoutesBuildItem.getWebRootConfigurations(), (ShutdownContext)shutdownContext);
            RouteBuildItem.Builder builder = nonApplicationRootPathBuildItem.routeBuilder().route(route).handler(uihandler);
            if (route.endsWith(DEVUI)) {
                builder = ((NonApplicationRootPathBuildItem.Builder)builder).displayOnNotFoundPage("Dev UI 2.0");
                routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)builder).build());
            }
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route(route + SLASH_ALL).handler(uihandler)).build());
        }
        String basepath = nonApplicationRootPathBuildItem.resolvePath(DEVUI);
        Path devUiBasePath = Files.createTempDirectory("quarkus-devui", new FileAttribute[0]);
        recorder.shutdownTask((ShutdownContext)shutdownContext, devUiBasePath.toString());
        for (StaticContentBuildItem staticContentBuildItem : staticContentBuildItems) {
            HashMap<String, String> urlAndPath = new HashMap<String, String>();
            if (!staticContentBuildItem.isInternal()) continue;
            List content = staticContentBuildItem.getContent();
            for (DevUIContent c : content) {
                String parsedContent = Qute.fmt((String)new String(c.getTemplate()), (Map)c.getData());
                Path tempFile = devUiBasePath.resolve(c.getFileName());
                Files.write(tempFile, parsedContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                urlAndPath.put(c.getFileName(), tempFile.toString());
            }
            Handler buildTimeStaticHandler = recorder.buildTimeStaticHandler(basepath, urlAndPath);
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/*").handler(buildTimeStaticHandler)).build());
        }
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            String route = devUIRoutesBuildItem.getPath();
            basepath = nonApplicationRootPathBuildItem.resolvePath(route);
            Handler routerhandler = recorder.vaadinRouterHandler(basepath);
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route(route + SLASH_ALL).handler(routerhandler)).build());
        }
        routeProducer.produce((BuildItem)RouteBuildItem.builder().route("/_static/*").handler((Handler<RoutingContext>)recorder.mvnpmHandler(mvnpmBuildItem.getMvnpmJars())).build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexProducer, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonRpcRouter.class).setUnremovable().build());
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class c = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            additionalIndexProducer.produce((BuildItem)new AdditionalIndexedClassesBuildItem(c.getName()));
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(c).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void findAllJsonRPCMethods(BuildProducer<JsonRPCMethodsBuildItem> jsonRPCMethodsProvider, BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer, CombinedIndexBuildItem combinedIndexBuildItem, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems) {
        IndexView index = combinedIndexBuildItem.getIndex();
        HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = new HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>>();
        ArrayList<CallSite> requestResponseMethods = new ArrayList<CallSite>();
        ArrayList<CallSite> subscriptionMethods = new ArrayList<CallSite>();
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class clazz = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            String extension = jsonRPCProvidersBuildItem.getExtensionName();
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = new HashMap();
            if (extensionMethodsMap.containsKey(extension)) {
                jsonRpcMethods = (Map)extensionMethodsMap.get(extension);
            }
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)clazz.getName()));
            List methods = classInfo.methods();
            for (MethodInfo method : methods) {
                if (method.name().equals(CONSTRUCTOR) || !Modifier.isPublic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
                if (method.returnType().name().equals((Object)DotName.createSimple((String)Multi.class.getName()))) {
                    subscriptionMethods.add((CallSite)((Object)(extension + DOT + method.name())));
                } else {
                    requestResponseMethods.add((CallSite)((Object)(extension + DOT + method.name())));
                }
                JsonRpcMethodName jsonRpcMethodName = new JsonRpcMethodName(method.name());
                if (method.parametersCount() > 0) {
                    LinkedHashMap<String, Class> params = new LinkedHashMap<String, Class>();
                    for (int i = 0; i < method.parametersCount(); ++i) {
                        Type parameterType = method.parameterType(i);
                        Class parameterClass = this.toClass(parameterType);
                        String parameterName = method.parameterName(i);
                        params.put(parameterName, parameterClass);
                    }
                    JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), params);
                    jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                    jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                    jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
                    continue;
                }
                JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), null);
                jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
            }
            if (jsonRpcMethods.isEmpty()) continue;
            extensionMethodsMap.put(extension, jsonRpcMethods);
        }
        if (!extensionMethodsMap.isEmpty()) {
            jsonRPCMethodsProvider.produce((BuildItem)new JsonRPCMethodsBuildItem(extensionMethodsMap));
        }
        BuildTimeConstBuildItem methodInfo = new BuildTimeConstBuildItem("devui-jsonrpc");
        if (!subscriptionMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCSubscriptions", subscriptionMethods);
        }
        if (!requestResponseMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCMethods", requestResponseMethods);
        }
        buildTimeConstProducer.produce((BuildItem)methodInfo);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void createJsonRpcRouter(DevUIRecorder recorder, BeanContainerBuildItem beanContainer, JsonRPCMethodsBuildItem jsonRPCMethodsBuildItem) {
        if (jsonRPCMethodsBuildItem != null) {
            Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = jsonRPCMethodsBuildItem.getExtensionMethodsMap();
            recorder.createJsonRpcRouter(beanContainer.getValue(), extensionMethodsMap);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void getAllExtensions(List<CardPageBuildItem> cardPageBuildItems, List<MenuPageBuildItem> menuPageBuildItems, List<FooterPageBuildItem> footerPageBuildItems, BuildProducer<ExtensionsBuildItem> extensionsProducer, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer) {
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(UI_JAR).root("dev-ui/").build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(UI_JAR, DEVUI));
        Map<String, CardPageBuildItem> cardPagesMap = this.getCardPagesMap(cardPageBuildItems);
        Map<String, MenuPageBuildItem> menuPagesMap = this.getMenuPagesMap(menuPageBuildItems);
        Map<String, FooterPageBuildItem> footerPagesMap = this.getFooterPagesMap(footerPageBuildItems);
        try {
            Yaml yaml = new Yaml();
            ArrayList<Extension> activeExtensions = new ArrayList<Extension>();
            ArrayList<Extension> inactiveExtensions = new ArrayList<Extension>();
            ArrayList<Extension> sectionMenuExtensions = new ArrayList<Extension>();
            ArrayList<Extension> footerTabExtensions = new ArrayList<Extension>();
            ClassPathUtils.consumeAsPaths((String)YAML_FILE, p -> {
                try {
                    String extensionYaml;
                    Extension extension = new Extension();
                    try (Scanner scanner = new Scanner(Files.newBufferedReader(p, StandardCharsets.UTF_8));){
                        scanner.useDelimiter("\\A");
                        extensionYaml = scanner.hasNext() ? scanner.next() : null;
                    }
                    if (extensionYaml == null) {
                        return;
                    }
                    Map extensionMap = (Map)yaml.load(extensionYaml);
                    if (extensionMap.containsKey(NAME)) {
                        Page page;
                        Map buildTimeData;
                        String nameKey;
                        Map codestartMap;
                        String name = (String)extensionMap.get(NAME);
                        extension.setNamespace(this.getExtensionNamespace(extensionMap));
                        extension.setName(name);
                        extension.setDescription(extensionMap.getOrDefault(DESCRIPTION, null));
                        String artifactId = extensionMap.getOrDefault(ARTIFACT, null);
                        extension.setArtifact(artifactId);
                        Map metaData = extensionMap.getOrDefault(METADATA, null);
                        extension.setKeywords(metaData.getOrDefault(KEYWORDS, null));
                        extension.setShortName(metaData.getOrDefault(SHORT_NAME, null));
                        if (metaData.containsKey(GUIDE)) {
                            String guide = (String)metaData.get(GUIDE);
                            try {
                                extension.setGuide(new URL(guide));
                            }
                            catch (MalformedURLException mue) {
                                log.warn((Object)("Could not set Guide URL [" + guide + "] for exception [" + name + "]"));
                            }
                        }
                        extension.setCategories(metaData.getOrDefault(CATEGORIES, null));
                        extension.setStatus(metaData.getOrDefault(STATUS, null));
                        extension.setBuiltWith(metaData.getOrDefault(BUILT_WITH, null));
                        extension.setConfigFilter(metaData.getOrDefault(CONFIG, null));
                        extension.setExtensionDependencies(metaData.getOrDefault(EXTENSION_DEPENDENCIES, null));
                        extension.setUnlisted(String.valueOf(metaData.getOrDefault(UNLISTED, false)));
                        if (metaData.containsKey(CAPABILITIES)) {
                            Map capabilities = (Map)metaData.get(CAPABILITIES);
                            extension.setConfigFilter(capabilities.getOrDefault(PROVIDES, null));
                        }
                        if (metaData.containsKey(CODESTART) && (codestartMap = (Map)metaData.get(metaData)) != null) {
                            Codestart codestart = new Codestart();
                            codestart.setName(codestartMap.getOrDefault(NAME, null));
                            codestart.setLanguages(codestartMap.getOrDefault(LANGUAGES, null));
                            codestart.setArtifact(codestartMap.getOrDefault(ARTIFACT, null));
                            extension.setCodestart(codestart);
                        }
                        if (!cardPagesMap.containsKey(nameKey = name.toLowerCase().replaceAll(SPACE, DASH))) {
                            inactiveExtensions.add(extension);
                        } else {
                            CardPageBuildItem cardPageBuildItem = (CardPageBuildItem)cardPagesMap.get(nameKey);
                            List cardPageBuilders = cardPageBuildItem.getPages();
                            buildTimeData = cardPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : cardPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addCardPage(page);
                            }
                            cardPageBuildItem.getOptionalCard().ifPresent(card -> {
                                card.setNamespace(extension.getPathName());
                                extension.setCard((Card)card);
                            });
                            this.produceResources(artifactId, cardPageBuildItem.getExtensionPathName(), webJarBuildProducer, devUIWebJarProducer);
                            activeExtensions.add(extension);
                        }
                        if (menuPagesMap.containsKey(nameKey)) {
                            MenuPageBuildItem menuPageBuildItem = (MenuPageBuildItem)menuPagesMap.get(nameKey);
                            List menuPageBuilders = menuPageBuildItem.getPages();
                            buildTimeData = menuPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : menuPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addMenuPage(page);
                            }
                            this.produceResources(artifactId, menuPageBuildItem.getExtensionPathName(), webJarBuildProducer, devUIWebJarProducer);
                            sectionMenuExtensions.add(extension);
                        }
                        if (footerPagesMap.containsKey(nameKey)) {
                            FooterPageBuildItem footerPageBuildItem = (FooterPageBuildItem)footerPagesMap.get(nameKey);
                            List footerPageBuilders = footerPageBuildItem.getPages();
                            buildTimeData = footerPageBuildItem.getBuildTimeData();
                            for (PageBuilder pageBuilder : footerPageBuilders) {
                                page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                extension.addFooterPage(page);
                            }
                            this.produceResources(artifactId, footerPageBuildItem.getExtensionPathName(), webJarBuildProducer, devUIWebJarProducer);
                            footerTabExtensions.add(extension);
                        }
                    }
                    Collections.sort(activeExtensions, this.sortingComparator);
                    Collections.sort(inactiveExtensions, this.sortingComparator);
                }
                catch (IOException | RuntimeException e) {
                    log.error((Object)("Failed to process extension descriptor " + p.toUri()), (Throwable)e);
                }
            });
            extensionsProducer.produce((BuildItem)new ExtensionsBuildItem(activeExtensions, inactiveExtensions, sectionMenuExtensions, footerTabExtensions));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void produceResources(String artifactId, String extensionPathName, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer) {
        GACT gact = this.getGACT(artifactId);
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(gact).root("dev-ui/" + extensionPathName + SLASH).build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(gact, "dev-ui/" + extensionPathName));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void createAllRoutes(WebJarResultsBuildItem webJarResultsBuildItem, List<DevUIWebJarBuildItem> devUIWebJarBuiltItems, BuildProducer<DevUIRoutesBuildItem> devUIRoutesProducer) {
        for (DevUIWebJarBuildItem devUIWebJarBuiltItem : devUIWebJarBuiltItems) {
            WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(devUIWebJarBuiltItem.getArtifactKey());
            if (result == null) continue;
            devUIRoutesProducer.produce((BuildItem)new DevUIRoutesBuildItem(devUIWebJarBuiltItem.getPath(), result.getFinalDestination(), result.getWebRootConfigurations()));
        }
    }

    private Page buildFinalPage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        pageBuilder.namespace(extension.getPathName());
        pageBuilder.extension(extension.getName());
        if (pageBuilder.getClass().equals(QuteDataPageBuilder.class)) {
            return this.buildQutePage(pageBuilder, extension, buildTimeData);
        }
        return pageBuilder.build();
    }

    private Page buildQutePage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        try {
            QuteDataPageBuilder quteDataPageBuilder = (QuteDataPageBuilder)pageBuilder;
            String templatePath = quteDataPageBuilder.getTemplatePath();
            ClassPathUtils.consumeAsPaths((String)templatePath, p -> {
                try {
                    String template = Files.readString(p);
                    String fragment = Qute.fmt((String)template, (Map)buildTimeData);
                    pageBuilder.metadata("htmlFragment", fragment);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return pageBuilder.build();
    }

    private GACT getGACT(String artifactKey) {
        String[] split = artifactKey.split(DOUBLE_POINT);
        return new GACT(split[0], split[1] + DASH_DEPLOYMENT, null, JAR);
    }

    private Class toClass(Type type) {
        try {
            return this.tccl.loadClass(type.name().toString());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, CardPageBuildItem> getCardPagesMap(List<CardPageBuildItem> pages) {
        HashMap<String, CardPageBuildItem> m = new HashMap<String, CardPageBuildItem>();
        for (CardPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(), pageBuildItem);
        }
        return m;
    }

    private Map<String, MenuPageBuildItem> getMenuPagesMap(List<MenuPageBuildItem> pages) {
        HashMap<String, MenuPageBuildItem> m = new HashMap<String, MenuPageBuildItem>();
        for (MenuPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(), pageBuildItem);
        }
        return m;
    }

    private Map<String, FooterPageBuildItem> getFooterPagesMap(List<FooterPageBuildItem> pages) {
        HashMap<String, FooterPageBuildItem> m = new HashMap<String, FooterPageBuildItem>();
        for (FooterPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(), pageBuildItem);
        }
        return m;
    }

    private String getExtensionNamespace(Map<String, Object> extensionMap) {
        String artifactId;
        String groupId;
        String artifact = (String)extensionMap.get(ARTIFACT);
        if (artifact == null) {
            groupId = (String)extensionMap.get("group-id");
            artifactId = (String)extensionMap.get("artifact-id");
            if (artifactId == null || groupId == null) {
                throw new RuntimeException("Failed to locate 'artifact' or 'group-id' and 'artifact-id' among metadata keys " + extensionMap.keySet());
            }
        } else {
            GACTV coords = GACTV.fromString((String)artifact);
            groupId = coords.getGroupId();
            artifactId = coords.getArtifactId();
        }
        return groupId + DOT + artifactId;
    }
}

