/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.quarkus.vertx.http.deployment.HttpSecurityPolicyBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.SecurityInformationBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.PolicyConfig;
import io.quarkus.vertx.http.runtime.security.AuthenticatedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.FormAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.MtlsAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.PathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PermitSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.SupplierImpl;
import io.vertx.core.Handler;
import io.vertx.core.http.ClientAuth;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class HttpSecurityProcessor {
    @BuildStep
    public void builtins(BuildProducer<HttpSecurityPolicyBuildItem> producer, HttpBuildTimeConfig buildTimeConfig, BuildProducer<AdditionalBeanBuildItem> beanProducer) {
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("deny", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new DenySecurityPolicy())));
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("permit", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new PermitSecurityPolicy())));
        producer.produce((BuildItem)new HttpSecurityPolicyBuildItem("authenticated", (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new AuthenticatedHttpSecurityPolicy())));
        if (!buildTimeConfig.auth.permissions.isEmpty()) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(PathMatchingHttpSecurityPolicy.class));
        }
        for (Map.Entry e : buildTimeConfig.auth.rolePolicy.entrySet()) {
            producer.produce((BuildItem)new HttpSecurityPolicyBuildItem((String)e.getKey(), (Supplier<HttpSecurityPolicy>)new SupplierImpl((Object)new RolesAllowedHttpSecurityPolicy(((PolicyConfig)e.getValue()).rolesAllowed))));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initFormAuth(HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig, BuildProducer<RouteBuildItem> filterBuildItemBuildProducer) {
        if (!buildTimeConfig.auth.proactive) {
            filterBuildItemBuildProducer.produce((BuildItem)RouteBuildItem.builder().route(buildTimeConfig.auth.form.postLocation).handler((Handler<RoutingContext>)recorder.formAuthPostHandler()).build());
        }
        if (buildTimeConfig.auth.form.enabled) {
            return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FormAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupFormAuth()).done();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initMtlsClientAuth(HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig) {
        if (this.isMtlsClientAuthenticationEnabled(buildTimeConfig)) {
            return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(MtlsAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupMtlsClientAuth()).done();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initBasicAuth(HttpSecurityRecorder recorder, HttpBuildTimeConfig buildTimeConfig, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        if (buildTimeConfig.auth.basic.isPresent() && !((Boolean)buildTimeConfig.auth.basic.get()).booleanValue()) {
            return null;
        }
        boolean basicExplicitlyEnabled = buildTimeConfig.auth.basic.orElse(false);
        if ((buildTimeConfig.auth.form.enabled || this.isMtlsClientAuthenticationEnabled(buildTimeConfig)) && !basicExplicitlyEnabled) {
            return null;
        }
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BasicAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupBasicAuth(buildTimeConfig));
        if (!(buildTimeConfig.auth.form.enabled || this.isMtlsClientAuthenticationEnabled(buildTimeConfig) || basicExplicitlyEnabled)) {
            configurator.defaultBean();
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        return configurator.done();
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(HttpSecurityRecorder recorder, BuildProducer<FilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Capabilities capabilities, BuildProducer<BeanContainerListenerBuildItem> beanContainerListenerBuildItemBuildProducer, HttpBuildTimeConfig buildTimeConfig, List<HttpSecurityPolicyBuildItem> httpSecurityPolicyBuildItemList, BuildProducer<SecurityInformationBuildItem> securityInformationProducer) {
        HashMap<String, Supplier<HttpSecurityPolicy>> policyMap = new HashMap<String, Supplier<HttpSecurityPolicy>>();
        for (HttpSecurityPolicyBuildItem e : httpSecurityPolicyBuildItemList) {
            if (policyMap.containsKey(e.getName())) {
                throw new RuntimeException("Multiple HTTP security policies defined with name " + e.getName());
            }
            policyMap.put(e.getName(), e.policySupplier);
        }
        if (!buildTimeConfig.auth.form.enabled && buildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            securityInformationProducer.produce((BuildItem)SecurityInformationBuildItem.BASIC());
        }
        if (capabilities.isPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(HttpAuthorizer.class).build());
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.authenticationMechanismHandler(buildTimeConfig.auth.proactive), 200));
            filterBuildItemBuildProducer.produce((BuildItem)new FilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), 100));
            if (!buildTimeConfig.auth.permissions.isEmpty()) {
                beanContainerListenerBuildItemBuildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initPermissions(buildTimeConfig, policyMap)));
            }
        } else if (!buildTimeConfig.auth.permissions.isEmpty()) {
            throw new IllegalStateException("HTTP permissions have been set however security is not enabled");
        }
    }

    private boolean isMtlsClientAuthenticationEnabled(HttpBuildTimeConfig buildTimeConfig) {
        return !ClientAuth.NONE.equals((Object)buildTimeConfig.tlsClientAuth);
    }
}

