/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerListenerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.vertx.http.deployment.HttpSecurityProcessor;
import io.quarkus.vertx.http.deployment.ManagementInterfaceFilterBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.PolicyConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.AuthenticatedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.DenySecurityPolicy;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.PermitSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.RolesAllowedHttpSecurityPolicy;
import io.quarkus.vertx.http.runtime.security.SupplierImpl;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;

public class ManagementInterfaceSecurityProcessor {
    @BuildStep
    public void builtins(ManagementInterfaceBuildTimeConfig buildTimeConfig, BuildProducer<AdditionalBeanBuildItem> beanProducer) {
        if (!buildTimeConfig.auth.permissions.isEmpty()) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ManagementPathMatchingHttpSecurityPolicy.class));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    SyntheticBeanBuildItem initBasicAuth(HttpBuildTimeConfig httpBuildTimeConfig, ManagementInterfaceSecurityRecorder recorder, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (HttpSecurityProcessor.applicationBasicAuthRequired(httpBuildTimeConfig, managementInterfaceBuildTimeConfig)) {
            return null;
        }
        if (managementInterfaceBuildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BasicAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).setRuntimeInit().scope(Singleton.class)).supplier(recorder.setupBasicAuth());
            return configurator.done();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(ManagementInterfaceSecurityRecorder recorder, BuildProducer<ManagementInterfaceFilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Capabilities capabilities, BuildProducer<BeanContainerListenerBuildItem> beanContainerListenerBuildItemBuildProducer, ManagementInterfaceBuildTimeConfig buildTimeConfig) {
        HashMap<String, SupplierImpl> policyMap = new HashMap<String, SupplierImpl>();
        for (Map.Entry e : buildTimeConfig.auth.rolePolicy.entrySet()) {
            policyMap.put((String)e.getKey(), new SupplierImpl((Object)new RolesAllowedHttpSecurityPolicy(((PolicyConfig)e.getValue()).rolesAllowed)));
        }
        policyMap.put("deny", new SupplierImpl((Object)new DenySecurityPolicy()));
        policyMap.put("permit", new SupplierImpl((Object)new PermitSecurityPolicy()));
        policyMap.put("authenticated", new SupplierImpl((Object)new AuthenticatedHttpSecurityPolicy()));
        if (buildTimeConfig.auth.basic.orElse(false).booleanValue() && capabilities.isPresent("io.quarkus.security")) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(ManagementInterfaceHttpAuthorizer.class).build());
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.authenticationMechanismHandler(buildTimeConfig.auth.proactive), -200));
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(buildTimeConfig, policyMap), -100));
            if (!buildTimeConfig.auth.permissions.isEmpty()) {
                beanContainerListenerBuildItemBuildProducer.produce((BuildItem)new BeanContainerListenerBuildItem(recorder.initPermissions(buildTimeConfig, policyMap)));
            }
        } else if (!buildTimeConfig.auth.permissions.isEmpty()) {
            throw new IllegalStateException("HTTP permissions have been set however security is not enabled");
        }
    }
}

