/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.ide;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.ide.EffectiveIdeBuildItem;
import io.quarkus.deployment.ide.Ide;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.utilities.OS;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.ide.IdeRecorder;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class IdeProcessor {
    private static final Logger log = Logger.getLogger(IdeProcessor.class);
    private static final Map<String, String> LANG_TO_EXT = Map.of("java", "java", "kotlin", "kt");
    private static final String NAMESPACE = "devui-ide-interaction";

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createOpenInIDEService(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, BuildProducer<RouteBuildItem> routeProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Optional<EffectiveIdeBuildItem> effectiveIdeBuildItem, IdeRecorder recorder) {
        Ide ide;
        if (effectiveIdeBuildItem.isPresent() && (ide = effectiveIdeBuildItem.get().getIde()) != null) {
            routeProducer.produce((BuildItem)((NonApplicationRootPathBuildItem.Builder)nonApplicationRootPathBuildItem.routeBuilder().route("open-in-ide/:fileName/:lang/:lineNumber").handler(recorder.openInIde())).build());
            BuildTimeActionBuildItem ideActions = new BuildTimeActionBuildItem(NAMESPACE);
            ideActions.addAction("open", map -> {
                String fileName = (String)map.get("fileName");
                String lang = (String)map.get("lang");
                String lineNumber = (String)map.get("lineNumber");
                if (this.isNullOrEmpty(fileName) || this.isNullOrEmpty(lang)) {
                    return false;
                }
                return this.typicalProcessLaunch(fileName, lang, lineNumber, ide);
            });
            buildTimeActionProducer.produce((BuildItem)ideActions);
        }
    }

    private boolean typicalProcessLaunch(String className, String lang, String line, Ide ide) {
        String fileName = this.toFileName(className, lang);
        if (fileName == null) {
            return false;
        }
        List args = ide.createFileOpeningArgs(fileName, line);
        return this.launchInIDE(ide, args);
    }

    private String toFileName(String className, String lang) {
        String fileName;
        Path sourceFile;
        String effectiveClassName = className;
        int dollarIndex = className.indexOf("$");
        if (dollarIndex > -1) {
            effectiveClassName = className.substring(0, dollarIndex);
        }
        if ((sourceFile = Ide.findSourceFile((String)(fileName = effectiveClassName.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang)))) == null) {
            return null;
        }
        return sourceFile.toAbsolutePath().toString();
    }

    protected boolean launchInIDE(Ide ide, final List<String> args) {
        final String effectiveCommand = ide.getEffectiveCommand();
        if (this.isNullOrEmpty(effectiveCommand)) {
            return false;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(effectiveCommand);
                    command.addAll(args);
                    new ProcessBuilder(command).inheritIO().start().waitFor(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    log.error((Object)"Could not launch IDE", (Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
        return true;
    }

    public static void openBrowser(HttpRootPathBuildItem rp, NonApplicationRootPathBuildItem np, String path, String host, String port) {
        block9: {
            path = path.startsWith("/q") ? np.resolvePath(path.substring(3)) : rp.resolvePath(path.substring(1));
            StringBuilder sb = new StringBuilder("http://");
            Config c = ConfigProvider.getConfig();
            sb.append(host);
            sb.append(":");
            sb.append(port);
            sb.append(path);
            String url = sb.toString();
            Runtime rt = Runtime.getRuntime();
            OS os = OS.determineOS();
            String[] command = null;
            try {
                switch (os) {
                    case MAC: {
                        command = new String[]{"open", url};
                        break;
                    }
                    case LINUX: {
                        command = new String[]{"xdg-open", url};
                        break;
                    }
                    case WINDOWS: {
                        command = new String[]{"rundll32", "url.dll,FileProtocolHandler", url};
                        break;
                    }
                    case OTHER: {
                        log.error((Object)"Cannot launch browser on this operating system");
                    }
                }
                if (command != null) {
                    rt.exec(command);
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to launch browser", (Throwable)e);
                if (command == null) break block9;
                log.warn((Object)("Unable to open browser using command: '" + String.join((CharSequence)" ", command) + "'. Failure is: '" + e.getMessage() + "'"));
            }
        }
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isBlank();
    }
}

