/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.vertx.http.deployment.HttpSecurityProcessor;
import io.quarkus.vertx.http.deployment.ManagementInterfaceFilterBuildItem;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceBuildTimeConfig;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceConfiguration;
import io.quarkus.vertx.http.runtime.management.ManagementInterfaceSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.quarkus.vertx.http.runtime.security.ManagementInterfaceHttpAuthorizer;
import io.quarkus.vertx.http.runtime.security.ManagementPathMatchingHttpSecurityPolicy;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import jakarta.inject.Singleton;
import java.util.Optional;

public class ManagementInterfaceSecurityProcessor {
    @BuildStep(onlyIfNot={HttpSecurityProcessor.IsApplicationBasicAuthRequired.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem initBasicAuth(ManagementInterfaceSecurityRecorder recorder, ManagementInterfaceBuildTimeConfig managementInterfaceBuildTimeConfig) {
        if (managementInterfaceBuildTimeConfig.auth.basic.orElse(false).booleanValue()) {
            SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(BasicAuthenticationMechanism.class).types(new Class[]{HttpAuthenticationMechanism.class})).scope(Singleton.class)).supplier(recorder.setupBasicAuth());
            return configurator.done();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void setupAuthenticationMechanisms(ManagementInterfaceSecurityRecorder recorder, BuildProducer<ManagementInterfaceFilterBuildItem> filterBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> beanProducer, Optional<ManagementAuthenticationHandlerBuildItem> managementAuthenticationHandlerBuildItem) {
        if (managementAuthenticationHandlerBuildItem.isPresent()) {
            beanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClass(HttpAuthenticator.class).addBeanClass(ManagementPathMatchingHttpSecurityPolicy.class).addBeanClass(ManagementInterfaceHttpAuthorizer.class).build());
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.getAuthenticationHandler(managementAuthenticationHandlerBuildItem.get().handler), -200));
            filterBuildItemBuildProducer.produce((BuildItem)new ManagementInterfaceFilterBuildItem((Handler<RoutingContext>)recorder.permissionCheckHandler(), -100));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void createManagementAuthMechHandler(ManagementInterfaceSecurityRecorder recorder, Capabilities capabilities, ManagementInterfaceBuildTimeConfig buildTimeConfig, BuildProducer<ManagementAuthenticationHandlerBuildItem> managementAuthMechHandlerProducer) {
        if (buildTimeConfig.auth.enabled && capabilities.isPresent("io.quarkus.security")) {
            managementAuthMechHandlerProducer.produce((BuildItem)new ManagementAuthenticationHandlerBuildItem((RuntimeValue<HttpSecurityRecorder.AuthenticationHandler>)recorder.managementAuthenticationHandler(buildTimeConfig.auth.proactive)));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    @Consume(value=BeanContainerBuildItem.class)
    void initializeAuthMechanismHandler(Optional<ManagementAuthenticationHandlerBuildItem> managementAuthenticationHandler, ManagementInterfaceSecurityRecorder recorder, ManagementInterfaceConfiguration runTimeConfig) {
        if (managementAuthenticationHandler.isPresent()) {
            recorder.initializeAuthenticationHandler(managementAuthenticationHandler.get().handler, runTimeConfig);
        }
    }

    static final class ManagementAuthenticationHandlerBuildItem
    extends SimpleBuildItem {
        private final RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler;

        private ManagementAuthenticationHandlerBuildItem(RuntimeValue<HttpSecurityRecorder.AuthenticationHandler> handler) {
            this.handler = handler;
        }
    }
}

