/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.continuoustesting.ContinuousTestingJsonRPCService;
import io.quarkus.devui.runtime.continuoustesting.ContinuousTestingRecorder;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;

public class ContinuousTestingProcessor {
    private static final String NAMESPACE = "devui-continuous-testing";
    private static final String DASH = "-";

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={IsDevelopment.class})
    public void continuousTestingState(ContinuousTestingRecorder recorder, LaunchModeBuildItem launchModeBuildItem, ShutdownContextBuildItem shutdownContextBuildItem, BeanContainerBuildItem beanContainer) throws IOException {
        DevModeType devModeType = launchModeBuildItem.getDevModeType().orElse(null);
        if (devModeType == null || !devModeType.isContinuousTestingSupported()) {
            return;
        }
        if (TestSupport.instance().isPresent()) {
            recorder.createContinuousTestingSharedStateManager(beanContainer.getValue(), (ShutdownContext)shutdownContextBuildItem);
        }
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    InternalPageBuildItem createContinuousTestingPages() {
        InternalPageBuildItem continuousTestingPages = new InternalPageBuildItem("Continuous Testing", 30);
        continuousTestingPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace(NAMESPACE)).title("Continuous Testing")).icon("font-awesome-solid:flask-vial")).componentLink("qwc-continuous-testing.js"));
        return continuousTestingPages;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    JsonRPCProvidersBuildItem createJsonRPCService(LaunchModeBuildItem launchModeBuildItem) {
        this.registerStartMethod(launchModeBuildItem);
        this.registerStopMethod(launchModeBuildItem);
        this.registerRunAllMethod(launchModeBuildItem);
        this.registerRunFailedMethod(launchModeBuildItem);
        this.registerToggleBrokenOnlyMethod(launchModeBuildItem);
        this.registerGetResultsMethod(launchModeBuildItem);
        return new JsonRPCProvidersBuildItem(NAMESPACE, ContinuousTestingJsonRPCService.class);
    }

    private boolean testsDisabled(LaunchModeBuildItem launchModeBuildItem, Optional<TestSupport> ts) {
        return ts.isEmpty() || launchModeBuildItem.getDevModeType().orElse(null) != DevModeType.LOCAL;
    }

    private void registerStartMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-start", ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                if (testSupport.isStarted()) {
                    return false;
                }
                testSupport.start();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void registerStopMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-stop", ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                if (testSupport.isStarted()) {
                    testSupport.stop();
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void registerRunAllMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-runAll", ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                testSupport.runAllTests();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void registerRunFailedMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-runFailed", ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                testSupport.runFailedTests();
                return true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void registerToggleBrokenOnlyMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-toggleBrokenOnly", ignored -> {
            try {
                Optional ts = TestSupport.instance();
                if (this.testsDisabled(launchModeBuildItem, ts)) {
                    return false;
                }
                TestSupport testSupport = (TestSupport)ts.get();
                return testSupport.toggleBrokenOnlyMode();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void registerGetResultsMethod(LaunchModeBuildItem launchModeBuildItem) {
        DevConsoleManager.register((String)"devui-continuous-testing-getResults", ignored -> {
            String string;
            ObjectMapper objectMapper = new ObjectMapper();
            Optional ts = TestSupport.instance();
            if (this.testsDisabled(launchModeBuildItem, ts)) {
                return null;
            }
            TestSupport testSupport = (TestSupport)ts.get();
            TestRunResults testRunResults = testSupport.getResults();
            if (testRunResults == null) {
                return null;
            }
            StringWriter sw = new StringWriter();
            try {
                objectMapper.writeValue((Writer)sw, (Object)testRunResults);
                string = sw.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        sw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            sw.close();
            return string;
        });
    }
}

