/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public final class EagerSecurityInterceptorBindingBuildItem
extends MultiBuildItem {
    private final DotName[] annotationBindings;
    private final Function<String, Consumer<RoutingContext>> interceptorCreator;
    private final Map<String, String> bindingToValue;
    private final boolean requiresSecurityCheck;

    public EagerSecurityInterceptorBindingBuildItem(Function<String, Consumer<RoutingContext>> interceptorCreator, DotName ... interceptorBindings) {
        this.annotationBindings = interceptorBindings;
        this.interceptorCreator = interceptorCreator;
        this.bindingToValue = Map.of();
        this.requiresSecurityCheck = false;
    }

    EagerSecurityInterceptorBindingBuildItem(Function<String, Consumer<RoutingContext>> interceptorCreator, Map<String, String> bindingToValue, DotName ... interceptorBindings) {
        this.annotationBindings = interceptorBindings;
        this.interceptorCreator = interceptorCreator;
        this.bindingToValue = bindingToValue;
        this.requiresSecurityCheck = true;
    }

    public DotName[] getAnnotationBindings() {
        return this.annotationBindings;
    }

    Function<String, Consumer<RoutingContext>> getInterceptorCreator() {
        return this.interceptorCreator;
    }

    public String getBindingValue(AnnotationInstance annotationInstance, DotName annotation, AnnotationTarget annotationTarget) {
        if (this.bindingToValue.containsKey(annotation.toString())) {
            return this.bindingToValue.get(annotation.toString());
        }
        if (annotationInstance.value() == null || annotationInstance.value().asString().isBlank()) {
            throw new ConfigurationException("Annotation '" + String.valueOf(annotation) + "' placed on '" + EagerSecurityInterceptorBindingBuildItem.toTargetName(annotationTarget) + "' must not have blank value");
        }
        return annotationInstance.value().asString();
    }

    private static String toTargetName(AnnotationTarget target) {
        if (target.kind() == AnnotationTarget.Kind.METHOD) {
            return target.asMethod().declaringClass().name().toString() + "#" + target.asMethod().name();
        }
        return target.asClass().name().toString();
    }

    boolean requiresSecurityCheck() {
        return this.requiresSecurityCheck;
    }
}

