/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.BuildException;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.paths.FilteredPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisitor;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import io.quarkus.vertx.http.deployment.spi.GeneratedStaticResourceBuildItem;
import io.quarkus.vertx.http.runtime.GeneratedStaticResourcesRecorder;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class GeneratedStaticResourcesProcessor {
    private static final int ROUTE_ORDER = 1060;
    private static final String META_INF_GENERATED_RESOURCES_TEST = "META-INF/generated-resources-test";

    @BuildStep
    public void produceResources(List<GeneratedStaticResourceBuildItem> generatedStaticResources, BuildProducer<GeneratedResourceBuildItem> generatedResourceBuildItem, BuildProducer<NativeImageResourceBuildItem> nativeImageResourcesProducer, LaunchModeBuildItem launchModeBuildItem, BuildProducer<AdditionalStaticResourceBuildItem> additionalStaticResourcesProducer) {
        for (GeneratedStaticResourceBuildItem generatedStaticResource : generatedStaticResources) {
            String generatedStaticResourceLocation = GeneratedStaticResourcesProcessor.buildGeneratedStaticResourceLocation(generatedStaticResource);
            if (!generatedStaticResource.isFile()) {
                generatedResourceBuildItem.produce((BuildItem)new GeneratedResourceBuildItem(generatedStaticResourceLocation, generatedStaticResource.getContent(), false));
            } else if (launchModeBuildItem.getLaunchMode() != LaunchMode.DEVELOPMENT) {
                try {
                    byte[] content = Files.readAllBytes(generatedStaticResource.getFile());
                    generatedResourceBuildItem.produce((BuildItem)new GeneratedResourceBuildItem(generatedStaticResourceLocation, content, false));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (launchModeBuildItem.getLaunchMode() != LaunchMode.NORMAL) continue;
            additionalStaticResourcesProducer.produce((BuildItem)new AdditionalStaticResourceBuildItem(generatedStaticResource.getEndpoint(), false));
            nativeImageResourcesProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{generatedStaticResourceLocation}));
        }
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void process(List<GeneratedStaticResourceBuildItem> generatedStaticResources, LaunchModeBuildItem launchModeBuildItem, BuildProducer<RouteBuildItem> routes, GeneratedStaticResourcesRecorder generatedStaticResourcesRecorder, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> notFoundPageProducer) throws BuildException {
        if (generatedStaticResources.isEmpty()) {
            return;
        }
        List<String> duplicates = GeneratedStaticResourcesProcessor.collectDuplicates(generatedStaticResources);
        if (!duplicates.isEmpty()) {
            throw new BuildException("Duplicate endpoints detected, the endpoint for static resources must be unique: " + String.valueOf(duplicates));
        }
        Map<String, String> generatedFilesResources = generatedStaticResources.stream().peek(path -> notFoundPageProducer.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem(path.getEndpoint()))).filter(GeneratedStaticResourceBuildItem::isFile).collect(Collectors.toMap(GeneratedStaticResourceBuildItem::getEndpoint, GeneratedStaticResourceBuildItem::getFileAbsolutePath));
        Set generatedClassPathResources = generatedStaticResources.stream().map(GeneratedStaticResourceBuildItem::getEndpoint).collect(Collectors.toSet());
        routes.produce((BuildItem)RouteBuildItem.builder().orderedRoute("/*", 1060, generatedStaticResourcesRecorder.createRouteCustomizer()).handler((Handler<RoutingContext>)generatedStaticResourcesRecorder.createHandler(generatedClassPathResources, generatedFilesResources)).build());
    }

    private static String buildGeneratedStaticResourceLocation(GeneratedStaticResourceBuildItem generatedStaticResourceBuildItem) {
        return "META-INF/resources" + generatedStaticResourceBuildItem.getEndpoint();
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    public void devMode(BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeployment, BuildProducer<GeneratedStaticResourceBuildItem> generatedStaticResourceProducer, LaunchModeBuildItem launchMode) throws IOException {
        if (!launchMode.isTest()) {
            return;
        }
        hotDeployment.produce((BuildItem)HotDeploymentWatchedFileBuildItem.builder().setRestartNeeded(true).setLocationPredicate(l -> l.startsWith("META-INF/generated-resources-test/bytes")).build());
        Map<String, Path> classpathResources = this.getClasspathResources();
        for (Map.Entry<String, Path> entry : classpathResources.entrySet()) {
            String key = "/" + entry.getKey();
            GeneratedStaticResourceBuildItem item = key.startsWith("/bytes") ? new GeneratedStaticResourceBuildItem(key, Files.readAllBytes(entry.getValue())) : new GeneratedStaticResourceBuildItem(key, entry.getValue());
            generatedStaticResourceProducer.produce((BuildItem)item);
        }
    }

    private Map<String, Path> getClasspathResources() {
        HashMap<String, Path> knownPaths = new HashMap<String, Path>();
        GeneratedStaticResourcesProcessor.visitRuntimeMetaInfResources(visit -> {
            if (!Files.isDirectory(visit.getPath(), new LinkOption[0])) {
                String resourcePath = visit.getRelativePath("/").substring("/".concat(META_INF_GENERATED_RESOURCES_TEST).length());
                knownPaths.put(resourcePath, visit.getPath());
            }
        });
        return knownPaths;
    }

    private static void visitRuntimeMetaInfResources(PathVisitor visitor) {
        List elements = QuarkusClassLoader.getElements((String)META_INF_GENERATED_RESOURCES_TEST, (boolean)false);
        if (!elements.isEmpty()) {
            PathFilter filter = PathFilter.forIncludes(List.of("META-INF/generated-resources-test/**", META_INF_GENERATED_RESOURCES_TEST));
            for (ClassPathElement element : elements) {
                if (!element.isRuntime()) continue;
                element.apply(tree -> {
                    new FilteredPathTree((PathTree)tree, filter).walk(visitor);
                    return null;
                });
            }
        }
    }

    private static List<String> collectDuplicates(List<GeneratedStaticResourceBuildItem> generatedStaticResources) {
        HashSet uniques = new HashSet();
        return generatedStaticResources.stream().map(GeneratedStaticResourceBuildItem::getEndpoint).filter(e -> !uniques.add(e)).toList();
    }
}

